/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ElapsedTimeFormatter {
    private static final long ONE_SEC = 1000L;
    private static final long ONE_MIN = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_MONTH = 2678400000L;
    private static final long ONE_YEAR = 31536000000L;
    private static final DecimalFormat df = new DecimalFormat("#######################0.#################################");
    private static final SimpleDateFormat ABBREVIATED_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat ABBREVIATED_TIME_FORMAT_NOMS = new SimpleDateFormat("HH:mm:ss");

    protected boolean isBad(double t) {
        return Double.isNaN(t) || Double.isInfinite(t) || Double.MAX_VALUE == t || Double.MIN_VALUE == t;
    }

    public String getFormattedTimeAgo(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "-";
        }
        if (Language.DEFLANG_ID.equalsIgnoreCase("es") || Language.DEFLANG_ID.equalsIgnoreCase("fr")) {
            return Language.get("AGO_TIME") + " " + this.getFormattedTime(timeInMillis);
        }
        return this.getFormattedTime(timeInMillis) + " " + Language.get("AGO_TIME");
    }

    public String getFormattedTimeIn(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "-";
        }
        return Language.get("IN_TIME") + " " + this.getFormattedTime(timeInMillis);
    }

    public String getFormattedTime(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "";
        }
        if (timeInMillis < 1000L) {
            if (timeInMillis == 1L) {
                return df.format(timeInMillis) + " " + Language.get("UNIT_MILLISECOND");
            }
            return df.format(timeInMillis) + " " + Language.get("UNIT_MILLISECONDS");
        }
        if (timeInMillis < 60000L) {
            if (timeInMillis / 1000L == 1L) {
                return df.format(timeInMillis / 1000L) + " " + Language.get("UNIT_SECOND");
            }
            return df.format(timeInMillis / 1000L) + " " + Language.get("UNIT_SECONDS");
        }
        if (timeInMillis < 3600000L) {
            if (timeInMillis / 60000L == 1L) {
                return df.format(timeInMillis / 60000L) + " " + Language.get("UNIT_MINUTE");
            }
            return df.format(timeInMillis / 60000L) + " " + Language.get("UNIT_MINUTES");
        }
        if (timeInMillis < 86400000L) {
            if (timeInMillis / 3600000L == 1L) {
                return df.format(timeInMillis / 3600000L) + " " + Language.get("UNIT_HOUR");
            }
            return df.format(timeInMillis / 3600000L) + " " + Language.get("UNIT_HOURS");
        }
        if (timeInMillis < 2678400000L) {
            if (timeInMillis / 86400000L == 1L) {
                return df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAY");
            }
            return df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAYS");
        }
        if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            if (timeInMillis / 2678400000L == 1L) {
                return df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTH");
            }
            return df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTHS");
        }
        if (timeInMillis / 31536000000L == 1L) {
            return df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEAR");
        }
        return df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEARS");
    }

    public String getAbbreviatedFormattedTime(long timeInMillis, boolean useMS) {
        if (timeInMillis == 0L) {
            return "";
        }
        if (this.isBad(timeInMillis)) {
            return "";
        }
        String cur = "";
        long remaining = 0L;
        if (timeInMillis < 1000L || timeInMillis < 60000L || timeInMillis < 3600000L || timeInMillis < 86400000L) {
            cur = useMS ? ABBREVIATED_TIME_FORMAT.format(new Date(timeInMillis)) : ABBREVIATED_TIME_FORMAT_NOMS.format(new Date(timeInMillis));
        } else if (timeInMillis < 2678400000L) {
            cur = timeInMillis / 86400000L == 1L ? df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAY") : df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAYS");
            remaining = timeInMillis % 86400000L;
        } else if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            cur = timeInMillis / 2678400000L == 1L ? df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTH") : df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTHS");
            remaining = timeInMillis % 2678400000L;
        } else {
            cur = timeInMillis / 31536000000L == 1L ? df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEAR") : df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEARS");
            remaining = timeInMillis % 31536000000L;
        }
        return cur + " " + this.getAbbreviatedFormattedTime(remaining, useMS);
    }

    public String getCompleteFormattedTime(long timeInMillis) {
        return this.getCompleteFormattedTime(timeInMillis, true);
    }

    public String getCompleteFormattedTime(long timeInMillis, boolean includeMillis) {
        if (timeInMillis == 0L) {
            return "";
        }
        if (this.isBad(timeInMillis)) {
            return "";
        }
        if (!includeMillis) {
            timeInMillis = 1000L * (timeInMillis / 1000L);
        }
        String cur = "";
        long remaining = 0L;
        if (timeInMillis < 1000L) {
            cur = timeInMillis == 1L ? df.format(timeInMillis) + " " + Language.get("UNIT_MILLISECOND") : df.format(timeInMillis) + " " + Language.get("UNIT_MILLISECONDS");
        } else if (timeInMillis < 60000L) {
            cur = timeInMillis / 1000L == 1L ? df.format(timeInMillis / 1000L) + " " + Language.get("UNIT_SECOND") : df.format(timeInMillis / 1000L) + " " + Language.get("UNIT_SECONDS");
            remaining = timeInMillis % 1000L;
        } else if (timeInMillis < 3600000L) {
            cur = timeInMillis / 60000L == 1L ? df.format(timeInMillis / 60000L) + " " + Language.get("UNIT_MINUTE") : df.format(timeInMillis / 60000L) + " " + Language.get("UNIT_MINUTES");
            remaining = timeInMillis % 60000L;
        } else if (timeInMillis < 86400000L) {
            cur = timeInMillis / 3600000L == 1L ? df.format(timeInMillis / 3600000L) + " " + Language.get("UNIT_HOUR") : df.format(timeInMillis / 3600000L) + " " + Language.get("UNIT_HOURS");
            remaining = timeInMillis % 3600000L;
        } else if (timeInMillis < 2678400000L) {
            cur = timeInMillis / 86400000L == 1L ? df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAY") : df.format(timeInMillis / 86400000L) + " " + Language.get("UNIT_DAYS");
            remaining = timeInMillis % 86400000L;
        } else if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            cur = timeInMillis / 2678400000L == 1L ? df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTH") : df.format(timeInMillis / 2678400000L) + " " + Language.get("UNIT_MONTHS");
            remaining = timeInMillis % 2678400000L;
        } else {
            cur = timeInMillis / 31536000000L == 1L ? df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEAR") : df.format(timeInMillis / 31536000000L) + " " + Language.get("UNIT_YEARS");
            remaining = timeInMillis % 31536000000L;
        }
        String nextBit = this.getCompleteFormattedTime(remaining);
        return (cur + " " + nextBit).trim();
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle.loadTestBundle();
        ElapsedTimeFormatter et = new ElapsedTimeFormatter();
        System.out.println(et.getCompleteFormattedTime(123123123L));
        System.out.println(et.getCompleteFormattedTime(123123123L, false));
        System.out.println(et.getAbbreviatedFormattedTime(123123123L, false));
    }

    static {
        ABBREVIATED_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ABBREVIATED_TIME_FORMAT_NOMS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

