/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ColourDepthIcon
implements Icon {
    boolean colour = true;
    int shades = 64;
    Icon icon;

    public ColourDepthIcon(Icon icon) {
        this.icon = icon;
    }

    public void setColour(boolean col) {
        this.colour = col;
    }

    public void setShades(int n) {
        this.shades = n;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics gg, int x, int y) {
        BufferedImage bimg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 1);
        this.icon.paintIcon(c, bimg.getGraphics(), x, y);
        for (int i = 0; i < this.getIconWidth(); ++i) {
            for (int k = 0; k < this.getIconHeight(); ++k) {
                int bits;
                int coldepth;
                int rgb = bimg.getRGB(i, k);
                int r = 0xFF & rgb >>> 16;
                int g = 0xFF & rgb >>> 8;
                int b = 0xFF & rgb >>> 0;
                if (!this.colour) {
                    int total = r + g + b;
                    r = total /= 3;
                    g = total;
                    b = total;
                }
                if ((coldepth = this.shades) < 2) {
                    coldepth = 2;
                }
                if (coldepth > 255) {
                    coldepth = 255;
                }
                if ((bits = 255 / coldepth) > 1) {
                    r -= r % bits;
                    g -= g % bits;
                    b -= b % bits;
                }
                rgb = 0xFF000000 | 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
                bimg.setRGB(i, k, rgb);
            }
        }
        gg.drawImage(bimg, x, y, null);
    }
}

