/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters.simplemachinemodel;

import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNodeListener;
import java.util.ArrayList;
import utils.message.Message;
import utils.progtools.collections.SortedList;

public class MachineGroupNode
extends SimpleMachineNode {
    public String groupName;
    private SortedList<MachineGroupNode> childGroups = new SortedList();
    private SortedList<MachineNode> childMachines = new SortedList();

    public String toString() {
        return this.groupName;
    }

    public MachineGroupNode(SimpleMachineNodeListener listener, String groupName) {
        super(listener);
        this.groupName = groupName;
    }

    public void groundWith(MachineTreeModel model) {
        for (MachineGroupNode group : this.childGroups) {
            group.groundWith(model);
        }
        for (MachineNode machine : this.childMachines) {
            machine.groundWith(model);
        }
    }

    public void removeChild(SimpleMachineNode node) {
        boolean removed = false;
        removed = node instanceof MachineGroupNode ? this.childGroups.remove((MachineGroupNode)node) : this.childMachines.remove((MachineNode)node);
        if (this.listener != null && removed) {
            this.listener.nodeRemoved(node);
        }
        if (this.parent != null && this.getState() == null && this.childGroups.size() == 0 && this.childMachines.size() == 0) {
            this.parent.removeChild(this);
        }
    }

    public void addChild(SimpleMachineNode node) {
        if (node instanceof MachineGroupNode) {
            this.childGroups.add((MachineGroupNode)node);
        } else {
            this.childMachines.add((MachineNode)node);
        }
        node.parent = this;
        if (this.listener != null) {
            this.listener.nodeAdded(node);
        }
    }

    public MachineGroupNode(SimpleMachineNodeListener listener, Message m) {
        super(listener);
        int i;
        this.groupName = m.getNextString();
        int count = m.getNextInt();
        for (i = 0; i < count; ++i) {
            this.addChild(new MachineGroupNode(listener, m.getNextMessage()));
        }
        count = m.getNextInt();
        for (i = 0; i < count; ++i) {
            this.addChild(new MachineNode(listener, m.getNextMessage()));
        }
        super.fromMessage(m);
    }

    @Override
    public Message toMessage() {
        Message m = new Message(1);
        m.append(this.groupName);
        m.append(this.childGroups.size());
        for (MachineGroupNode machineGroupNode : this.childGroups) {
            m.append(machineGroupNode.toMessage());
        }
        m.append(this.childMachines.size());
        for (MachineNode machineNode : this.childMachines) {
            m.append(machineNode.toMessage());
        }
        super.toMessage(m);
        return m;
    }

    public MachineGroupNode createPath(String[] groupPath) {
        if (groupPath == null) {
            return this;
        }
        MachineGroupNode parent = this;
        for (String group : groupPath) {
            MachineGroupNode child = parent.getChildGroupByName(group);
            if (child == null) {
                child = new MachineGroupNode(this.listener, group);
                parent.addChild(child);
            }
            parent = child;
        }
        return parent;
    }

    public MachineGroupNode getChildGroupByName(String name) {
        for (MachineGroupNode childNode : this.childGroups) {
            if (!childNode.groupName.equals(name)) continue;
            return childNode;
        }
        return null;
    }

    public boolean matches(String[] group) {
        MachineGroupNode parent = this;
        for (String groupToMatch : group) {
            if ((parent = parent.getChildGroupByName(groupToMatch)) != null) continue;
            return false;
        }
        return true;
    }

    public Boolean getMostRecentStateForPath(String[] group) {
        MachineGroupNode parent = this;
        Boolean state = null;
        if (group == null) {
            return null;
        }
        for (String groupToMatch : group) {
            if ((parent = parent.getChildGroupByName(groupToMatch)) == null) {
                return state;
            }
            if (parent.getState() == null) continue;
            state = parent.getState();
        }
        return state;
    }

    public MachineGroupNode getMachineGroupNodeFor(String[] path) {
        MachineGroupNode parent = this;
        for (String groupToMatch : path) {
            if ((parent = parent.getChildGroupByName(groupToMatch)) != null) continue;
            return null;
        }
        return parent;
    }

    @Override
    public SimpleMachineNode replicate() {
        MachineGroupNode node = new MachineGroupNode(null, this.groupName);
        node.setState(this.getState());
        node.childGroups.addAll(this.childGroups);
        node.childMachines.addAll(this.childMachines);
        return node;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MachineGroupNode) {
            return ((MachineGroupNode)o).groupName.equals(this.groupName);
        }
        return false;
    }

    public MachineNode createMachineFor(String name, String machineID) {
        for (MachineNode machineNode : this.childMachines) {
            if (!machineNode.machineID.equals(machineID)) continue;
            return machineNode;
        }
        MachineNode node = new MachineNode(this.listener, name, machineID);
        this.addChild(node);
        return node;
    }

    public Iterable<MachineGroupNode> getGroups() {
        return this.childGroups;
    }

    public Iterable<MachineNode> getMachines() {
        return this.childMachines;
    }

    public Object getChildByIndex(int index) {
        if (index < this.childGroups.size()) {
            return this.childGroups.get(index);
        }
        return this.childMachines.get(index - this.childGroups.size());
    }

    public int getChildCount() {
        return this.childGroups.size() + this.childMachines.size();
    }

    public int getIndexOfChild(SimpleMachineNode child) {
        if (child instanceof MachineGroupNode) {
            return this.childGroups.indexOf(child);
        }
        int index = this.childMachines.indexOf((MachineNode)child);
        if (index == -1) {
            return -1;
        }
        return this.childGroups.size() + index;
    }

    @Override
    public void setState(Boolean state) {
        super.setState(state);
        if (this.parent != null && state == null && this.childGroups.size() == 0 && this.childMachines.size() == 0) {
            this.parent.removeChild(this);
        }
    }

    public String[] getPath() {
        ArrayList<String> result = new ArrayList<String>();
        MachineGroupNode node = this;
        this.getPath(node, result);
        return result.toArray(new String[0]);
    }

    private void getPath(MachineGroupNode node, ArrayList<String> result) {
        if (node != null && node.parent != null) {
            this.getPath(node.parent, result);
            result.add(node.groupName);
        }
    }
}

