/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.MachinePickerTree;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import com.aem.shelp.tech.utils.filters.SimpleMachineFilterTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.UIManager;
import utils.swing.SwingUtil;
import utils.swing.components.NoContentsInfoPanel;

public class SimpleMachineFiltersUI {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private NoContentsInfoPanel noContentsInfoPanel;
    private MachinePickerTree tree;
    private SimpleMachineFilter simpleMachineFilter;
    private MachineTreeModel model;
    private FilterChangeListener filterListener;

    public SimpleMachineFiltersUI(FilterChangeListener listener) {
        this.filterListener = listener;
        this.initUI();
    }

    private void initUI() {
        this.simpleMachineFilter = new SimpleMachineFilter();
        this.tree = new MachinePickerTree(this.simpleMachineFilter, false, true);
        this.noContentsInfoPanel = new NoContentsInfoPanel(Language.get("MACHINE_FILTERS_NONE"), null, false, false);
        this.noContentsInfoPanel.setContentsPanel(this.tree.getRootComponent());
        this.noContentsInfoPanel.setBorder(UIManager.getBorder("ScrollPane.border"));
        this.rootComponent.add((Component)this.noContentsInfoPanel, "Center");
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
    }

    public void setExistingFilter(SimpleMachineFilter filter) {
        this.simpleMachineFilter = filter;
        if (filter != null && !filter.isEmpty()) {
            this.noContentsInfoPanel.setHasContents(true);
            SimpleMachineFilterTreeModel smpm = new SimpleMachineFilterTreeModel(filter, this.model);
            this.tree.setMachineTreeModel(smpm);
        } else {
            this.noContentsInfoPanel.setHasContents(false);
        }
    }

    public void setEnabled(boolean b) {
        this.rootComponent.setEnabled(b);
    }

    public SimpleMachineFilter getFilter() {
        return this.getFilter(this.tree, this.model);
    }

    public SimpleMachineFilter getFilter(MachinePickerTree tree, MachineTreeModel model) {
        return this.simpleMachineFilter;
    }

    public void showPicker() {
        MachinePickerTree dialogTree = new MachinePickerTree(this.simpleMachineFilter, true, true);
        dialogTree.setMachineTreeModel(this.model);
        MachinePickerTree machinePickerTree = dialogTree;
        machinePickerTree.getClass();
        MachinePickerTree.MachinePickerDialog mpd = machinePickerTree.new MachinePickerTree.MachinePickerDialog(false);
        mpd.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent));
        SimpleMachineFilter filter = this.getFilter(dialogTree, this.model);
        this.setExistingFilter(filter);
        this.filterListener.filterChanged();
    }
}

