/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHComboBox;
import utils.swing.components.reorderablepanel.ReorderablePanel;
import utils.swing.components.reorderablepanel.ReorderablePanelList;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdvancedFiltersUI {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private Filter[] existingFilters;
    private ReorderablePanelList filterListPanel;
    private ArrayList<FilterUI> filterUIList = new ArrayList();
    private FilterChangeListener filterListener;
    private boolean isRemoteAccess;
    private String[] detailKeys = new String[0];
    private NoContentsInfoPanel noContentsInfoPanel;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public AdvancedFiltersUI(FilterChangeListener filterListener, boolean isRemoteAccess) {
        this.isRemoteAccess = isRemoteAccess;
        this.filterListener = filterListener;
        this.initUI();
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        AdvancedFiltersUI ui = new AdvancedFiltersUI(null, true);
        ui.setDetailKeys(new String[]{"Name", "Doodad"});
        ui.setExistingFilters(null);
        testFrame.getContentPane().add(ui.getRootComponent());
        testFrame.setVisible(true);
    }

    public void setDetailKeys(String[] keys) {
        this.detailKeys = keys;
    }

    public void setExistingFilters(Filter[] existingFilters) {
        this.clearFilters(false);
        this.existingFilters = existingFilters;
        if (existingFilters != null) {
            for (int i = 0; i < existingFilters.length; ++i) {
                Filter filter = existingFilters[i];
                this.addFilterToListPanels(filter, i == existingFilters.length - 1);
            }
        }
        this.filterListPanel.relayout();
    }

    public boolean isComplete() {
        if (this.filterUIList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.filterUIList.size(); ++i) {
            FilterUI ui = this.filterUIList.get(i);
            if (ui.isComplete()) continue;
            return false;
        }
        return true;
    }

    private void initUI() {
        this.filterListPanel = new ReorderablePanelList();
        this.filterListPanel.setBackground(UIManager.getColor("TextField.background"));
        JScrollPane sp = new JScrollPane(this.filterListPanel);
        sp.setBackground(UIManager.getColor("TextField.background"));
        this.noContentsInfoPanel = this.isRemoteAccess ? new NoContentsInfoPanel(Language.get("MACHINE_FILTERS_NONE"), null, false, false) : new NoContentsInfoPanel(Language.get("CUSTOMER_FILTERS_NONE"), null, false, false);
        this.noContentsInfoPanel.setContentsPanel(sp);
        this.noContentsInfoPanel.setBorder(UIManager.getBorder("ScrollPane.border"));
        this.rootComponent.add((Component)this.noContentsInfoPanel, "Center");
        sp.setBorder(SHBorderFactory.createEmptyBorder());
    }

    public void addNewFilter() {
        Filter filter = this.isRemoteAccess ? new MachineFilter() : new CustomerFilter();
        this.addFilterToListPanels(filter, true);
        this.filterListener.filterChanged();
    }

    private void clearFilters(boolean relayout) {
        this.filterUIList.clear();
        this.filterListPanel.getReorderablePanels().clear();
        this.noContentsInfoPanel.setHasContents(false);
        if (relayout) {
            this.filterListPanel.relayout();
        }
    }

    private void addFilterToListPanels(Filter filter, boolean relayout) {
        FilterUI ui = new FilterUI(filter);
        this.filterUIList.add(ui);
        ui.setDragDropListener(this.filterListPanel.demoPanelDropTargetListener);
        this.filterListPanel.getReorderablePanels().add(ui);
        if (relayout) {
            this.filterListPanel.relayout();
        }
        this.noContentsInfoPanel.setHasContents(true);
    }

    public void removeFilter(final FilterUI filterUI) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdvancedFiltersUI.this.filterUIList.remove(filterUI);
                AdvancedFiltersUI.this.filterListPanel.getReorderablePanels().remove(filterUI);
                AdvancedFiltersUI.this.filterListPanel.relayout();
                AdvancedFiltersUI.this.noContentsInfoPanel.setHasContents(AdvancedFiltersUI.this.filterUIList.size() > 0);
                AdvancedFiltersUI.this.filterListener.filterChanged();
            }
        });
    }

    public Filter[] getFilters() {
        Filter[] allFilters = new Filter[this.filterUIList.size()];
        for (int i = 0; i < this.filterUIList.size(); ++i) {
            allFilters[i] = this.filterUIList.get(i).getFilter();
        }
        return allFilters;
    }

    protected String getHideText() {
        return Language.get("HIDE_COLUMN");
    }

    protected String getShowText() {
        return Language.get("SHOW_COLUMN");
    }

    public void setEnabled(boolean b) {
        this.rootComponent.setEnabled(b);
        if (this.filterListPanel != null) {
            this.filterListPanel.setEnabled(b);
            for (int i = 0; i < this.filterUIList.size(); ++i) {
                this.filterUIList.get(i).setEnabled(b);
            }
        }
    }

    public class FilterUI
    extends ReorderablePanel
    implements KeyListener,
    ActionListener {
        private GbPanel filterRoot = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        private SHComboBox actionBox;
        private SHComboBox fieldBox;
        private SHComboBox showHideBox;
        private JTextField actionTextField = new JTextField();
        private JLabel deleteLabel;
        private boolean loading;

        public FilterUI(Filter filter) {
            this.initUI(filter);
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.filterRoot);
        }

        private void selectFieldForKey(String key) {
            if (AdvancedFiltersUI.this.isRemoteAccess) {
                if (key == null) {
                    this.fieldBox.setSelectedIndex(4);
                } else if (key.equals(MachineFilter.FIELD_NAME)) {
                    this.fieldBox.setSelectedIndex(0);
                } else if (key.equals(MachineFilter.FIELD_GROUP)) {
                    this.fieldBox.setSelectedIndex(1);
                } else if (key.equals(MachineFilter.FIELD_ANCESTOR_SINGLE)) {
                    this.fieldBox.setSelectedIndex(2);
                } else if (key.equals(MachineFilter.FIELD_ANCESTOR)) {
                    this.fieldBox.setSelectedIndex(3);
                } else if (key.equals(MachineFilter.FIELD_DETAILS)) {
                    this.fieldBox.setSelectedIndex(4);
                } else {
                    this.fieldBox.setSelectedIndex(4);
                }
            } else if (key == null) {
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 3);
            } else if (key.equals("Filter_Country")) {
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 0);
            } else if (key.equals("Filter_URL")) {
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 1);
            } else if (key.equals("Filter_Domain")) {
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 2);
            } else if (key.equals("Filter_Details")) {
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 3);
            } else {
                for (int i = 0; i < AdvancedFiltersUI.this.detailKeys.length; ++i) {
                    if (!AdvancedFiltersUI.this.detailKeys[i].equals(key)) continue;
                    this.fieldBox.setSelectedIndex(i);
                    return;
                }
                this.fieldBox.setSelectedIndex(AdvancedFiltersUI.this.detailKeys.length + 3);
            }
        }

        private String getFieldKeyForIndex(int index) {
            if (AdvancedFiltersUI.this.isRemoteAccess) {
                switch (index) {
                    case 0: {
                        return MachineFilter.FIELD_NAME;
                    }
                    case 1: {
                        return MachineFilter.FIELD_GROUP;
                    }
                    case 2: {
                        return MachineFilter.FIELD_ANCESTOR_SINGLE;
                    }
                    case 3: {
                        return MachineFilter.FIELD_ANCESTOR;
                    }
                    case 4: {
                        return MachineFilter.FIELD_DETAILS;
                    }
                }
                return MachineFilter.FIELD_DETAILS;
            }
            if (index >= AdvancedFiltersUI.this.detailKeys.length) {
                switch (index -= AdvancedFiltersUI.this.detailKeys.length) {
                    case 0: {
                        return "Filter_Country";
                    }
                    case 1: {
                        return "Filter_URL";
                    }
                    case 2: {
                        return "Filter_Domain";
                    }
                    case 3: {
                        return "Filter_Details";
                    }
                }
                return "Filter_Details";
            }
            return AdvancedFiltersUI.this.detailKeys[index];
        }

        private void initUI(Filter initFilter) {
            Object[] variablesPlusAll;
            JLabel primaryLabel;
            this.filterRoot.setBackground(UIManager.getColor("TextField.background"));
            boolean isGerman = Language.DEFLANG_ID.equalsIgnoreCase("de");
            JLabel secondaryLabel = null;
            if (!isGerman) {
                primaryLabel = AdvancedFiltersUI.this.isRemoteAccess ? new JLabel(Language.get("FILTERS_MACHINE")) : new JLabel(Language.get("FILTERS_CUSTOMER"));
            } else if (AdvancedFiltersUI.this.isRemoteAccess) {
                primaryLabel = new JLabel(Language.get("FILTERS_MACHINE_1"));
                secondaryLabel = new JLabel(Language.get("FILTERS_MACHINE_2"));
            } else {
                primaryLabel = new JLabel(Language.get("FILTERS_CUSTOMER_1"));
                secondaryLabel = new JLabel(Language.get("FILTERS_CUSTOMER_2"));
            }
            this.actionBox = new SHComboBox(new Object[]{Language.get("EQUALS"), Language.get("NOT_EQUALS"), Language.get("CONTAINS"), Language.get("DOES_NOT_CONTAIN"), Language.get("MATCHES"), Language.get("NOT_MATCHES")});
            this.makeNaked((JComboBox)this.actionBox);
            this.showHideBox = isGerman ? new SHComboBox(new Object[]{AdvancedFiltersUI.this.getShowText().toLowerCase(), AdvancedFiltersUI.this.getHideText().toLowerCase()}) : new SHComboBox(new Object[]{AdvancedFiltersUI.this.getShowText(), AdvancedFiltersUI.this.getHideText()});
            this.makeNaked((JComboBox)this.showHideBox);
            if (AdvancedFiltersUI.this.isRemoteAccess) {
                variablesPlusAll = new String[]{Language.get("NAME").toLowerCase(), Language.get("GROUP").toLowerCase(), Language.get("ANCESTOR_GROUP_SINGLE").toLowerCase(), Language.get("ANCESTOR_GROUP").toLowerCase(), Language.get("ANY_DETAILS").toLowerCase()};
            } else {
                int length = 4 + AdvancedFiltersUI.this.detailKeys.length;
                variablesPlusAll = new String[length];
                for (int i = 0; i < AdvancedFiltersUI.this.detailKeys.length; ++i) {
                    variablesPlusAll[i] = AdvancedFiltersUI.this.detailKeys[i].toLowerCase();
                }
                variablesPlusAll[length - 4] = Language.get("COUNTRY").toLowerCase();
                variablesPlusAll[length - 3] = Language.get("CONNECT_URL").toLowerCase();
                variablesPlusAll[length - 2] = Language.get("CONNECT_DOMAIN").toLowerCase();
                variablesPlusAll[length - 1] = Language.get("ANY_DETAILS").toLowerCase();
            }
            this.fieldBox = new SHComboBox(variablesPlusAll);
            this.makeNaked((JComboBox)this.fieldBox);
            this.deleteLabel = new JLabel();
            this.deleteLabel.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/remove.svg,16"));
            this.deleteLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    FilterUI.this.deleteFilter();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            int X = 0;
            if (!isGerman) {
                this.filterRoot.add((Component)this.showHideBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)primaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.fieldBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.actionBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.actionTextField, X++, 0, 1, 1, 1, 1, 10, 1);
                this.filterRoot.add((Component)this.deleteLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            } else {
                this.filterRoot.add((Component)primaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.showHideBox, X++, 0, 1, 1, 0, 1, 10, 1);
                if (secondaryLabel != null) {
                    this.filterRoot.add((Component)secondaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                }
                this.filterRoot.add((Component)this.fieldBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.actionTextField, X++, 0, 1, 1, 1, 1, 10, 1);
                this.filterRoot.add((Component)this.actionBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add((Component)this.deleteLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            }
            this.loadFromFilter(initFilter);
            this.actionTextField.addKeyListener(this);
            this.showHideBox.addActionListener((ActionListener)this);
            this.fieldBox.addActionListener((ActionListener)this);
            this.actionBox.addActionListener((ActionListener)this);
            Font smallFont = SHStyle.smallerFont;
            primaryLabel.setFont(smallFont);
            if (secondaryLabel != null) {
                secondaryLabel.setFont(smallFont);
            }
            this.fieldBox.setFont(smallFont);
            this.showHideBox.setFont(smallFont);
            this.actionBox.setFont(smallFont);
            this.actionTextField.setFont(smallFont);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.actionBox.setEnabled(enabled);
            this.showHideBox.setEnabled(enabled);
            this.fieldBox.setEnabled(enabled);
            this.actionTextField.setEnabled(enabled);
            this.deleteLabel.setEnabled(enabled);
        }

        public boolean isComplete() {
            return this.actionTextField.getText().trim().length() > 0;
        }

        private void deleteFilter() {
            AdvancedFiltersUI.this.removeFilter(this);
        }

        private void loadFromFilter(Filter initFilter) {
            try {
                this.loading = true;
                this.actionBox.setSelectedIndex(initFilter.getCheckAction());
                this.selectFieldForKey(initFilter.getFieldNameToFilter());
                this.showHideBox.setSelectedIndex(initFilter.isShow() ? 0 : 1);
                this.actionTextField.setText(initFilter.getCheckActionText());
            }
            finally {
                this.loading = false;
            }
        }

        private void makeNaked(JComboBox box) {
            box.putClientProperty("NAKED", "YES");
        }

        public Filter getFilter() {
            if (AdvancedFiltersUI.this.isRemoteAccess) {
                return new MachineFilter(this.showHideBox.getSelectedIndex() == 0, this.getFieldKeyForIndex(this.fieldBox.getSelectedIndex()), this.actionBox.getSelectedIndex(), this.actionTextField.getText());
            }
            return new CustomerFilter(this.showHideBox.getSelectedIndex() == 0, this.getFieldKeyForIndex(this.fieldBox.getSelectedIndex()), this.actionBox.getSelectedIndex(), this.actionTextField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.loading && AdvancedFiltersUI.this.filterListener != null) {
                AdvancedFiltersUI.this.filterListener.filterChanged();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!this.loading && AdvancedFiltersUI.this.filterListener != null) {
                AdvancedFiltersUI.this.filterListener.filterChanged();
            }
        }
    }
}

