/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.MachinePickerTree;
import com.aem.shelp.tech.utils.MachinesSummaryLabel;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineGroupNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class MachinesPickerPanel {
    private final ActionListener listener;
    private MachineTreeModel machineTreeModel;
    private String pickerTitle;
    private final String pickerEmptyText;
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private MachinePickerTree pickerTree;
    private JLabel notifyLabel;
    private JButton pickMachineButton;
    private MachinesSummaryLabel machinesSummaryLabel;
    private Icon titleIcon;
    private ArrayList<Machine> selectedMachines = new ArrayList();
    private ArrayList<MachineGroup> selectedGroups = new ArrayList();
    private SimpleMachineFilter filter = new SimpleMachineFilter();

    public MachinesPickerPanel(boolean oneLine, String pickerTitle, String pickerEmptyText, ActionListener listener) {
        this.pickerTitle = pickerTitle;
        this.pickerEmptyText = pickerEmptyText;
        this.listener = listener;
        this.pickerTree = new MachinePickerTree(this.filter, true, false);
        this.initUI(oneLine);
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.machineTreeModel = model;
        this.pickerTree.setMachineTreeModel(model);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    private void initUI(boolean oneLine) {
        this.machinesSummaryLabel = new MachinesSummaryLabel(oneLine, 5);
        this.machinesSummaryLabel.setTagColor(SHStyle.PANEL_BACKGROUND_BLUE_LIGHTER);
        this.notifyLabel = new JLabel(this.pickerTitle);
        this.notifyLabel.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
        this.pickMachineButton = new JButton(Language.get("PICK_MACHINES_OR_GROUPS"));
        this.pickMachineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MachinesPickerPanel.this.showPickerDialog();
            }
        });
        this.rootComponent.add((Component)this.notifyLabel, 0, 0, 1, 1, 0, 0, 18, 2, (Insets)new ScaledInsets(8, 0, 0, 3));
        this.rootComponent.add(this.machinesSummaryLabel.getRootComponent(), 1, 0, 1, 1, 1, 1, 17, 1);
        this.rootComponent.add((Component)this.pickMachineButton, 2, 0, 1, 1, 0, 0, 12, 0, (Insets)new ScaledInsets(5, 3, 0, 0));
        this.updateSummaryLabel();
    }

    public void setEnabled(boolean enabled) {
        this.notifyLabel.setEnabled(enabled);
        this.machinesSummaryLabel.setEnabled(enabled);
    }

    private void updateSummaryLabel() {
        this.machinesSummaryLabel.setPickedMachinesAndGroups(this.selectedMachines.toArray(new Machine[0]), this.selectedGroups.toArray(new MachineGroup[0]));
        if (this.pickerTree.containsIncludes()) {
            this.notifyLabel.setIcon(null);
            this.notifyLabel.setText(this.pickerTitle);
        } else {
            this.notifyLabel.setIcon(this.titleIcon);
            this.notifyLabel.setText("<html>" + this.pickerTitle + " <font color=" + "#626262" + ">" + this.pickerEmptyText);
        }
    }

    protected void showPickerDialog() {
        this.pickerTree.showInDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent));
        SimpleMachineFilter.SimpleNodeIterator nodeIterator = this.filter.getNodeIterator();
        this.selectedMachines.clear();
        this.selectedGroups.clear();
        while (nodeIterator.hasNext()) {
            SimpleMachineNode next = nodeIterator.next();
            if (next instanceof MachineNode) {
                this.selectedMachines.add((Machine)this.machineTreeModel.getElementWithID(((MachineNode)next).machineID));
                continue;
            }
            MachineGroup group = (MachineGroup)this.machineTreeModel.getGroup(((MachineGroupNode)next).getPath(), false);
            if (group == null) continue;
            this.selectedGroups.add(group);
        }
        this.updateSummaryLabel();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void setBackground(Color background) {
        this.rootComponent.setBackground(background);
        this.machinesSummaryLabel.setBackground(background);
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon = titleIcon;
        this.pickerTitle = "";
        this.updateSummaryLabel();
    }

    public int getButtonWidth() {
        return this.pickMachineButton.getPreferredSize().width;
    }

    public void setButtonWidth(int buttonWidth) {
        SwingUtil.setWidth((JComponent)this.pickMachineButton, (int)buttonWidth);
    }

    public String[] getSelectedMachinesIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Machine m : this.selectedMachines) {
            result.add(m.getID());
        }
        for (MachineGroup group : this.selectedGroups) {
            for (Machine machine : (Machine[])this.machineTreeModel.getDescendentElementsArray(group)) {
                result.add(machine.getMachineID());
            }
        }
        return result.toArray(new String[0]);
    }
}

