/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.MachineName;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.images.ImageLoader;

public class MachineGroupLabel
extends ColorPropagatingPanel {
    private int height = -1;
    private Icon icon;

    private void addGroups(String[] groups) {
        if (this.icon != null) {
            this.add(new SameHeightLabel(this.icon));
        }
        if (groups == null) {
            return;
        }
        for (String group : groups) {
            if (this.getComponentCount() > 0) {
                this.add(new SameHeightLabel(ImageLoader.getImageIcon((String)Icons.GROUP_SEPARATOR)));
            }
            this.add(new SameHeightLabel(group));
        }
    }

    public void setForeground(Color foreground) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setForeground(foreground);
        }
    }

    public void setGroups(String[] groups) {
        this.removeAll();
        this.addGroups(groups);
        this.revalidate();
        this.repaint();
    }

    public MachineGroupLabel() {
        this.setLayout((LayoutManager)new ScaledFlowLayout(0, 0, 0));
    }

    public void setMachineName(MachineName name, boolean includeMachineName) {
        this.removeAll();
        this.addGroups(name.getGroup());
        if (includeMachineName) {
            if (this.getComponentCount() > 0) {
                this.add(new SameHeightLabel(ImageLoader.getImageIcon((String)Icons.GROUP_SEPARATOR)));
            }
            SameHeightLabel machineName = new SameHeightLabel(name.getName());
            this.add(machineName);
        }
        this.revalidate();
        this.repaint();
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setIcon(Icon imageIcon) {
        this.icon = imageIcon;
    }

    class SameHeightLabel
    extends JLabel {
        public SameHeightLabel(String name) {
            super(name);
        }

        public SameHeightLabel(Icon icon) {
            super(icon);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (MachineGroupLabel.this.height != -1) {
                return new Dimension(dim.width, MachineGroupLabel.this.height);
            }
            return dim;
        }
    }
}

