/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.SystemIconUtil;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ToolResourcesUI
implements ActionListener {
    private GbPanel rootPanel = new GbPanel(){

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = Math.min(SimpleHelpLookAndFeel.scale((int)130), d.height);
            return d;
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            d.height = Math.min(SimpleHelpLookAndFeel.scale((int)130), d.height);
            return d;
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.height = Math.min(SimpleHelpLookAndFeel.scale((int)130), d.height);
            return d;
        }
    };
    private GbPanel resourceList = new GbPanel();
    private ArrayList<ToolBoxResource> resources = new ArrayList();
    private JButton addResourceButton = new JButton(Language.get("TOOLBOX_PICK_RESOURCE"));
    private ToolBoxItem item;
    private JLabel noContentsLabel = new JLabel(Language.get("TOOLBOX_NO_RESOURCES"));
    private JPanel paddy = new JPanel();
    private JScrollPane pane;

    public ToolResourcesUI() {
        this.initUI();
    }

    public void load(ToolBoxItem item, boolean isImported) {
        this.item = item;
        this.addResourceButton.setVisible(!isImported);
        this.resources = item.getResources();
        SwingUtil.setHeight((JComponent)this.paddy, (int)1);
        this.resourceList.removeAll();
        this.resourceList.add((Component)this.paddy, 0, this.resourceList.getComponentCount(), 1, 1, 1, 1, 10, 0);
        for (ToolBoxResource resource : this.resources) {
            this.addResource(resource, isImported);
        }
        this.updateVisible();
    }

    private void updateVisible() {
        this.noContentsLabel.setVisible(this.resources.size() == 0);
        this.pane.setVisible(this.resources.size() > 0);
    }

    private void initUI() {
        this.pane = new JScrollPane((Component)this.resourceList);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.noContentsLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.rootPanel.add((Component)this.pane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.rootPanel.add((Component)this.noContentsLabel, 0, 1, 1, 1, 1, 1, 11, 1);
        this.rootPanel.add((Component)this.addResourceButton, 1, 0, 1, 2, 0, 0, 18, 0, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.addResourceButton.addActionListener(this);
    }

    public static String getUniqueID(ArrayList<ToolBoxResource> existingResources) {
        boolean exists = true;
        int offset = 0;
        while (exists) {
            exists = false;
            String id = Long.toString(System.currentTimeMillis() + (long)offset++);
            for (ToolBoxResource resource : existingResources) {
                if (!resource.getID().equals(id)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return id;
        }
        return null;
    }

    public JPanel getRootComponent() {
        return this.rootPanel;
    }

    public void addResource() {
        File[] files = SafeJFileChooser.pickFiles((Component)this.rootPanel);
        this.addResources(files);
    }

    public void addResources(File[] files) {
        if (files != null && files.length > 0) {
            for (File file : files) {
                ToolBoxResource resource = new ToolBoxResource(ToolResourcesUI.getUniqueID(this.resources), file);
                this.resources.add(resource);
                this.addResource(resource, false);
                this.item.addToRecentlyAddedResources(resource);
            }
            SwingUtil.getRootPaneContainer((Component)this.pane).getContentPane().invalidate();
            SwingUtil.getRootPaneContainer((Component)this.pane).getContentPane().validate();
            this.pane.repaint();
            this.updateVisible();
        }
    }

    private void addResource(ToolBoxResource resource, boolean isImported) {
        ResourcePanel panel = new ResourcePanel(resource);
        if (isImported) {
            panel.removeButton.setVisible(false);
        }
        this.resourceList.remove((Component)this.paddy);
        this.resourceList.add((Component)panel, 0, this.resourceList.getComponentCount(), 1, 1, 1, 1, 17, 2);
        this.resourceList.add((Component)this.paddy, 0, this.resourceList.getComponentCount(), 1, 1, 1, 1000, 10, 0);
        this.resourceList.revalidate();
        this.resourceList.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addResource();
    }

    class ResourcePanel
    extends JPanel
    implements MouseListener {
        private ToolBoxResource resource;
        private JLabel resourceLabel;
        private JLabel removeButton;

        public ResourcePanel(ToolBoxResource resource) {
            super((LayoutManager)new ScaledFlowLayout(0, SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
            this.resourceLabel = new JLabel();
            this.resource = resource;
            this.removeButton = new JLabel(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
            this.removeButton.setBorder(null);
            this.removeButton.addMouseListener(this);
            this.resourceLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
            this.resourceLabel.setText(resource.getFilename());
            if (resource.isDirectory()) {
                this.resourceLabel.setIcon(SystemIconUtil.getDefaultFolderIcon());
            } else {
                this.resourceLabel.setIcon(SystemIconUtil.getDefaultFileIcon());
            }
            this.add(this.resourceLabel);
            this.add(this.removeButton);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ToolResourcesUI.this.item.getResources().remove(this.resource);
            ToolResourcesUI.this.item.addToRecentlyRemovedResources(this.resource);
            ToolResourcesUI.this.updateVisible();
            ToolResourcesUI.this.item.getRecentlyAddedResources().remove(this.resource);
            ToolResourcesUI.this.resourceList.remove((Component)this);
            ToolResourcesUI.this.resourceList.revalidate();
            ToolResourcesUI.this.resourceList.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

