/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.tech.toolbox.ToolBoxResultWrapper;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ToolBoxResultUI {
    public GbPanel rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
    private JLabel iconLabel = new JLabel();
    private JWrapLabel titleLabel = new JWrapLabel();
    private JWrapLabel statusLabel = new JWrapLabel();
    private JWrapLabel errorLabel = new JWrapLabel();
    private CircularProgressLabel progressIcon;
    private JLabel stdoutLabel = new JLabel(Language.get("TOOLBOX_STDOUT"));
    private JTextArea stdout = new JTextArea();
    private JScrollPane stdoutScroller = new JScrollPane(this.stdout){

        private Dimension limitHeight(Dimension dim) {
            if (dim.height < SimpleHelpLookAndFeel.scale((int)100)) {
                dim.height = SimpleHelpLookAndFeel.scale((int)100);
            }
            if (dim.height > SimpleHelpLookAndFeel.scale((int)300)) {
                dim.height = SimpleHelpLookAndFeel.scale((int)300);
            }
            dim.width = 1;
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.limitHeight(super.getMaximumSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.limitHeight(super.getMinimumSize());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.limitHeight(super.getPreferredSize());
        }
    };
    private JLabel stderrLabel = new JLabel(Language.get("TOOLBOX_STDERR"));
    private JTextArea stderr = new JTextArea();
    private JScrollPane stderrScroller = new JScrollPane(this.stderr){

        private Dimension limitHeight(Dimension dim) {
            if (dim.height < SimpleHelpLookAndFeel.scale((int)100)) {
                dim.height = SimpleHelpLookAndFeel.scale((int)100);
            }
            if (dim.height > SimpleHelpLookAndFeel.scale((int)300)) {
                dim.height = SimpleHelpLookAndFeel.scale((int)300);
            }
            dim.width = 1;
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.limitHeight(super.getMaximumSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.limitHeight(super.getMinimumSize());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.limitHeight(super.getPreferredSize());
        }
    };
    private ToolBoxResultWrapper loadedWrapperResult;

    public ToolBoxResultUI(ToolBoxItem item) {
        if (item != null) {
            this.titleLabel.setText(item.getName());
        }
        this.initUI();
    }

    public void initUI() {
        int Y = 0;
        this.stdout.setEditable(false);
        this.stderr.setEditable(false);
        this.progressIcon = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_16);
        this.titleLabel.setFont(SHStyle.largeFont);
        this.titleLabel.setBorder(SHBorderFactory.createEmptyBorder((int)8, (int)0, (int)3, (int)3));
        Border border = SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3);
        this.iconLabel.setBorder(border);
        this.iconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/box.svg,16"));
        this.rootComponent.add((Component)this.iconLabel, 0, Y, 1, 1, 0, 0, 11, 2);
        this.rootComponent.add((Component)this.titleLabel, 1, Y++, 1, 1, 1, 0, 11, 2);
        this.rootComponent.add((Component)this.progressIcon, 0, Y, 1, 1, 0, 0, 10, 2);
        this.rootComponent.add((Component)this.statusLabel, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add((Component)this.errorLabel, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add((Component)this.stdoutLabel, 0, Y++, 2, 1, 1, 0, 17, 2);
        this.rootComponent.add((Component)this.stdoutScroller, 0, Y++, 2, 1, 0, 0, 17, 1);
        this.rootComponent.add((Component)this.stderrLabel, 0, Y++, 2, 1, 1, 0, 17, 2);
        this.rootComponent.add((Component)this.stderrScroller, 0, Y++, 2, 1, 0, 0, 17, 1);
        this.rootComponent.add((Component)new JPanel(), 0, Y++, 2, 1, 1, 10000, 17, 1);
    }

    public ToolBoxResultWrapper getLoadedWrapperResult() {
        return this.loadedWrapperResult;
    }

    public void load(ToolBoxResultWrapper result) {
        this.loadedWrapperResult = result;
        System.out.println("[ToolBoxResultUI] " + result);
        boolean showStdout = false;
        boolean showStderr = false;
        if (result != null) {
            if (result.tool != null) {
                this.iconLabel.setIcon(result.tool.getIcon(20));
            }
            this.statusLabel.setVisible(true);
            this.errorLabel.setVisible(false);
            switch (result.statusCode) {
                case 1: {
                    this.progressIcon.switchOn();
                    this.statusLabel.setText(Language.get("TOOLBOX_INIT"));
                    break;
                }
                case 4: {
                    this.progressIcon.switchOn();
                    this.statusLabel.setText(Language.get("TOOLBOX_RUNNING"));
                    break;
                }
                case 2: {
                    this.progressIcon.switchOn();
                    this.statusLabel.setText(Language.get("TOOLBOX_COPY_RESOURCES"));
                    break;
                }
                case 3: {
                    this.progressIcon.switchOn();
                    this.statusLabel.setText(Language.get("TOOLBOX_LAUNCHING"));
                    break;
                }
                case 5: {
                    this.progressIcon.switchOff();
                    this.progressIcon.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
                    this.statusLabel.setText(Language.get("TOOLBOX_SUCCESS") + " " + result.returnCode);
                    break;
                }
                case 6: {
                    this.progressIcon.switchOff();
                    this.progressIcon.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"));
                    this.statusLabel.setText(Language.get("TOOLBOX_ERROR"));
                    if (result.launchError != null) {
                        this.errorLabel.setText("<html>" + Language.get("REASON") + ": " + result.launchError);
                        this.errorLabel.setVisible(true);
                        break;
                    }
                    this.errorLabel.setVisible(false);
                }
            }
            showStdout = result.stdout != null && result.stdout.length() != 0;
            showStderr = result.stderr != null && result.stderr.length() != 0;
            this.stdout.setText(result.stdout.toString());
            this.stderr.setText(result.stderr.toString());
        } else {
            this.progressIcon.switchOff();
            this.statusLabel.setVisible(false);
        }
        this.stdoutLabel.setVisible(showStdout);
        this.stdoutScroller.setVisible(showStdout);
        this.stderrLabel.setVisible(showStderr);
        this.stderrScroller.setVisible(showStderr);
        this.rootComponent.repaint();
    }
}

