/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.toolbox.ToolBoxResultUI;
import com.aem.shelp.tech.toolbox.ToolBoxResultWrapper;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class RunToolResultsPanel
implements ActionListener {
    private final AccessPanelListener accessPanelListener;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel titleBar = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
    private JLabel titleLabel = new JLabel(Language.get("TOOL_RUN_TITLE"));
    private JWrapLabel desc = new JWrapLabel("<html>" + Language.get("TOOL_RUN_DESC"));
    private JButton runToolButton = new JButton(Language.get("RUN_TOOL_TARGET_NAME"), ImageLoader.getImageIcon((String)"images/svg/users/runner.svg,16"));
    private GbPanel mainPanel = new GbPanel();
    private JButton stopAllButton;
    private StrippedContentPanel mainPanelWrapper;
    private final Object LOCK = new Object();
    private final HashMap<Long, ToolBoxUIs> runIdToUI = new HashMap();
    private Machine selectedMachine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.stopAllButton) {
            boolean showDialog = false;
            Object object = this.LOCK;
            synchronized (object) {
                for (ToolBoxUIs existingTools : this.runIdToUI.values()) {
                    byte existingState = existingTools.panel.getLoadedWrapperResult().statusCode;
                    if (existingState == 5 || existingState == 6) continue;
                    showDialog = true;
                    break;
                }
            }
            if (showDialog && !SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.stopAllButton), (String)Language.get("TOOLS_RUNNING_MSG"), (String)Language.get("TOOLS_RUNNING_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("TERMINATE"))) {
                return;
            }
            ArrayList<ToolBoxResultWrapper> runsToTerminate = new ArrayList<ToolBoxResultWrapper>();
            Object object2 = this.LOCK;
            synchronized (object2) {
                for (ToolBoxUIs existingTools : this.runIdToUI.values()) {
                    ToolBoxResultWrapper loadedWrapperResult = existingTools.panel.getLoadedWrapperResult();
                    runsToTerminate.add(loadedWrapperResult);
                }
            }
            new TerminateRunsThread(this.selectedMachine, runsToTerminate).start();
        } else {
            this.accessPanelListener.showToolRunDialog(this.selectedMachine, this.runToolButton);
        }
    }

    private void setHasContents(final boolean hasContents) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunToolResultsPanel.this.titleBar.removeAll();
                JPanel buttons = new JPanel((LayoutManager)new ScaledFlowLayout());
                buttons.add(RunToolResultsPanel.this.runToolButton);
                if (!hasContents) {
                    RunToolResultsPanel.this.titleBar.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)5, (int)0, (int)0));
                    RunToolResultsPanel.this.titleBar.add((Component)RunToolResultsPanel.this.titleLabel, "North");
                    RunToolResultsPanel.this.titleBar.add((Component)RunToolResultsPanel.this.desc, "Center");
                    RunToolResultsPanel.this.titleBar.add((Component)buttons, "South");
                } else {
                    buttons.add(RunToolResultsPanel.this.stopAllButton);
                    RunToolResultsPanel.this.titleBar.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)0)));
                    RunToolResultsPanel.this.titleBar.add((Component)RunToolResultsPanel.this.titleLabel, "Center");
                    RunToolResultsPanel.this.titleBar.add((Component)buttons, "East");
                }
                RunToolResultsPanel.this.titleBar.revalidate();
                RunToolResultsPanel.this.titleBar.repaint();
            }
        });
    }

    public RunToolResultsPanel(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    public void initUI() {
        this.stopAllButton = new JButton(Language.get("TOOLS_STOP_ALL"));
        this.stopAllButton.addActionListener(this);
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.stopAllButton, this.runToolButton});
        this.titleLabel.setFont(SHStyle.largeFont);
        this.runToolButton.addActionListener(this);
        this.mainPanelWrapper = new SHStrippedContentPanel(this.mainPanel, false);
        JScrollPane sp = new JScrollPane((Component)this.mainPanel);
        sp.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
        this.rootComponent.add((Component)sp, "Center");
        this.rootComponent.add((Component)this.titleBar, "North");
        this.setHasContents(false);
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedMachine(Machine machine) {
        if (this.selectedMachine == null || !this.selectedMachine.equals(machine)) {
            this.selectedMachine = machine;
            Object object = this.LOCK;
            synchronized (object) {
                this.runIdToUI.clear();
            }
            this.mainPanel.removeAll();
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.mainPanel.getComponentCount() > 0) {
            this.mainPanel.remove(this.mainPanel.getComponentCount() - 1);
        }
        boolean atLeastOneTool = false;
        if (this.selectedMachine != null) {
            Object object = this.LOCK;
            synchronized (object) {
                HashSet<ToolBoxUIs> uisToRemove = new HashSet<ToolBoxUIs>(this.runIdToUI.values());
                ToolBoxResultWrapper[] toolRuns = this.accessPanelListener.getToolRuns(this.selectedMachine);
                for (ToolBoxResultWrapper wrapper : toolRuns) {
                    atLeastOneTool = true;
                    ToolBoxUIs uis = this.runIdToUI.get(wrapper.getInternalRunID());
                    if (uis != null) {
                        uisToRemove.remove(uis);
                        uis.panel.load(wrapper);
                        continue;
                    }
                    ToolBoxResultUI panel = new ToolBoxResultUI(wrapper.tool);
                    panel.load(wrapper);
                    uis = new ToolBoxUIs();
                    uis.panel = panel;
                    uis.runID = wrapper.getInternalRunID();
                    uis.section = this.mainPanelWrapper.addContent((JComponent)panel.rootComponent, null);
                    this.runIdToUI.put(uis.runID, uis);
                }
                for (ToolBoxUIs uiToRemove : uisToRemove) {
                    this.mainPanel.remove((Component)uiToRemove.section);
                    this.runIdToUI.remove(uiToRemove.runID);
                }
            }
        }
        this.mainPanelWrapper.addVerticalFiller();
        this.mainPanelWrapper.setBackgroundColours();
        this.setHasContents(atLeastOneTool);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResult(ToolBoxResultWrapper toolRun) {
        Object object = this.LOCK;
        synchronized (object) {
            ToolBoxUIs toolBoxUIs = this.runIdToUI.get(toolRun.getInternalRunID());
            if (toolBoxUIs != null) {
                toolBoxUIs.panel.load(toolRun);
            }
        }
    }

    class ToolBoxUIs {
        long runID;
        StrippedContentPanel.TitledSection section;
        ToolBoxResultUI panel;

        ToolBoxUIs() {
        }

        public boolean equals(Object o) {
            if (o instanceof ToolBoxUIs) {
                return ((ToolBoxUIs)o).runID == this.runID;
            }
            return false;
        }
    }

    class TerminateRunsThread
    extends Thread {
        private final Machine machine;
        private final ArrayList<ToolBoxResultWrapper> runsToTerminate;

        public TerminateRunsThread(Machine selectedMachine, ArrayList<ToolBoxResultWrapper> runsToTerminate) {
            this.machine = selectedMachine;
            this.runsToTerminate = runsToTerminate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator<ToolBoxResultWrapper> iterator = RunToolResultsPanel.this.LOCK;
            synchronized (iterator) {
                for (ToolBoxResultWrapper wrapper : this.runsToTerminate) {
                    try {
                        RunToolResultsPanel.this.accessPanelListener.getTechClient().cancelToolboxRun(new Machine[]{RunToolResultsPanel.this.selectedMachine}, wrapper.getServerRunID(), 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (ToolBoxResultWrapper wrapper : this.runsToTerminate) {
                RunToolResultsPanel.this.accessPanelListener.removeToolRun(this.machine, wrapper);
            }
            RunToolResultsPanel.this.accessPanelListener.ensureElementSelected(RunToolResultsPanel.this.selectedMachine.getMachineID());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunToolResultsPanel.this.load();
                }
            });
        }
    }
}

