/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.software.AbstractSoftwareTable;
import com.aem.shelp.tech.software.AbstractSoftwareTableCellRenderer;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import utils.software.windows.WindowsApplication;
import utils.software.windows.WindowsSoftware;
import utils.swing.customlaf.SHStyle;
import utils.swing.simplelist.jtable.TableStructure;

public class WindowsSoftwareTable
extends AbstractSoftwareTable<WindowsApplication> {
    public WindowsSoftwareTable(AccessPanelListener accessPanelListener) {
        super(accessPanelListener);
    }

    @Override
    protected TableCellRenderer createTableRenderer() {
        return new SoftwareRenderer();
    }

    @Override
    protected TableStructure getTableStructure() {
        return TableStructure.createTableStructure(WindowsApplication.class, new String[]{"installDate", "applicationName", "appVersion", "vendor", "path"}, new String[]{Language.get("SOFTWARE_INSTALL"), Language.get("SOFTWARE_APP_NAME"), Language.get("SOFTWARE_APP_VERSION"), Language.get("SOFTWARE_VENDOR"), Language.get("SOFTWARE_PATH")});
    }

    public void load(WindowsSoftware software) {
        ArrayList applications = software.getApplicationsArray();
        this.list.startBatch();
        try {
            this.list.setListContents(applications);
        }
        finally {
            this.list.endBatch();
        }
    }

    public class SoftwareRenderer
    extends AbstractSoftwareTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                label.setFont(SHStyle.smallerFont);
            } else {
                label.setFont(UIManager.getFont("Label.font"));
            }
            if (column == 0) {
                long time = (Long)value;
                label.setText(WindowsSoftwareTable.this.dateFormatter.formatDate(time));
            }
            return label;
        }
    }
}

