/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.software.LinuxSoftwareTable;
import com.aem.shelp.tech.software.LinuxUpdatesTable;
import com.aem.shelp.tech.software.OSXSoftwareTable;
import com.aem.shelp.tech.software.OSXUpdatesTable;
import com.aem.shelp.tech.software.WindowsHotfixTable;
import com.aem.shelp.tech.software.WindowsSoftwareTable;
import com.aem.shelp.tech.software.WindowsUpdatesTable;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import utils.progtools.OnDemandThreadPool;
import utils.software.macos.OSXSoftware;
import utils.software.types.software.Software;
import utils.software.windows.WindowsSoftware;
import utils.swing.components.NoContentsInfoPanel;

public class MachineSoftwarePanel {
    private final AccessPanelListener accessPanelListener;
    private final OnDemandThreadPool threadPool = new OnDemandThreadPool("SoftwarePanelThreadPool", 2, 0, 5);
    private NoContentsInfoPanel rootComponent;
    private String selectedMachineID;
    private TechClient techClient;
    private JTabbedPane tabs = new JTabbedPane();
    private WindowsSoftwareTable windowsSoftwareTable;
    private WindowsUpdatesTable windowsUpdatesTable;
    private WindowsHotfixTable windowsHotfixTable;
    private OSXSoftwareTable osxSoftwareTable;
    private OSXUpdatesTable osxUpdatesTable;
    private LinuxSoftwareTable linuxSoftwareTable;
    private LinuxUpdatesTable linuxUpdatesTable;

    public MachineSoftwarePanel(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    public NoContentsInfoPanel getRootComponent() {
        return this.rootComponent;
    }

    public void initUI() {
        this.rootComponent = new NoContentsInfoPanel(Language.get("LOADING") + "...", null, false);
        this.rootComponent.setContentsPanel(this.tabs);
        this.rootComponent.setTitle(Language.get("ACCESS_SOFTWARE_NONE"));
        this.windowsSoftwareTable = new WindowsSoftwareTable(this.accessPanelListener);
        this.windowsHotfixTable = new WindowsHotfixTable(this.accessPanelListener);
        this.windowsUpdatesTable = new WindowsUpdatesTable(this.accessPanelListener);
        this.osxSoftwareTable = new OSXSoftwareTable(this.accessPanelListener);
        this.osxUpdatesTable = new OSXUpdatesTable(this.accessPanelListener);
        this.linuxSoftwareTable = new LinuxSoftwareTable(this.accessPanelListener);
        this.linuxUpdatesTable = new LinuxUpdatesTable(this.accessPanelListener);
    }

    public void showMachineSoftware(final Machine machine) {
        if (machine == null) {
            this.rootComponent.setHasContents(false);
            return;
        }
        if (this.selectedMachineID != null && this.selectedMachineID.equals(machine.getMachineID())) {
            return;
        }
        final String machineID = this.selectedMachineID = machine.getMachineID();
        this.threadPool.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    MachineSoftwarePanel.this.rootComponent.setHasContents(false);
                    System.out.println("[MachineSoftwarePanel] Requesting software update from " + machineID);
                    Software software = MachineSoftwarePanel.this.techClient.requestMachineSoftware(machineID);
                    System.out.println("[MachineSoftwarePanel] Received software of type " + software.getClass().getName() + " from " + machineID);
                    if (machineID.equalsIgnoreCase(MachineSoftwarePanel.this.selectedMachineID)) {
                        MachineSoftwarePanel.this.showSoftware(machine, software);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showSoftware(Machine machine, Software software) {
        this.rootComponent.setHasContents(true);
        if (machine.getOsBaseType() == 0) {
            this.windowsSoftwareTable.load((WindowsSoftware)software);
            this.windowsHotfixTable.load((WindowsSoftware)software);
            this.windowsUpdatesTable.load((WindowsSoftware)software);
        } else if (machine.getOsBaseType() == 1) {
            this.osxSoftwareTable.load((OSXSoftware)software);
            this.osxUpdatesTable.load((OSXSoftware)software);
        } else if (machine.getOsBaseType() == 2) {
            this.linuxSoftwareTable.load(software);
            this.linuxUpdatesTable.load(software);
        }
        this.updateUI(machine.getOsBaseType(), software);
    }

    private void updateUI(final int osBaseType, final Software software) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MachineSoftwarePanel.this.updateUI(osBaseType, software);
                }
            });
            return;
        }
        this.tabs.removeAll();
        switch (osBaseType) {
            case 0: {
                if (software.hasUpdateDetails()) {
                    this.tabs.addTab(Language.get("SOFTWARE_UPDATES"), this.windowsUpdatesTable.getRootComponent());
                }
                if (software.hasApplicationDetails()) {
                    this.tabs.addTab(Language.get("SOFTWARE_CURRENT"), this.windowsSoftwareTable.getRootComponent());
                }
                if (!((WindowsSoftware)software).hasHotfixDetails()) break;
                this.tabs.addTab(Language.get("SOFTWARE_HOTFIXES"), this.windowsHotfixTable.getRootComponent());
                break;
            }
            case 1: {
                if (software.hasUpdateDetails()) {
                    this.tabs.addTab(Language.get("SOFTWARE_UPDATES"), this.osxUpdatesTable.getRootComponent());
                }
                if (!software.hasApplicationDetails()) break;
                this.tabs.addTab(Language.get("SOFTWARE_CURRENT"), this.osxSoftwareTable.getRootComponent());
                break;
            }
            case 2: {
                if (software.hasUpdateDetails()) {
                    this.tabs.addTab(Language.get("SOFTWARE_UPDATES"), this.linuxUpdatesTable.getRootComponent());
                }
                if (!software.hasApplicationDetails()) break;
                this.tabs.addTab(Language.get("SOFTWARE_CURRENT"), this.linuxSoftwareTable.getRootComponent());
            }
        }
        this.tabs.revalidate();
        this.tabs.repaint();
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
        this.windowsSoftwareTable.setTechClient(techClient);
        this.windowsHotfixTable.setTechClient(techClient);
        this.windowsUpdatesTable.setTechClient(techClient);
        this.osxSoftwareTable.setTechClient(techClient);
        this.osxUpdatesTable.setTechClient(techClient);
    }
}

