/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.sdesktop.client.gui.ToolsPanel;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class ToolsPropertiesPanel
extends PropertiesPage
implements ActionListener {
    private ToolsPanel toolsPanel;
    private Tool[] allTools;

    public ToolsPropertiesPanel(PageListener listener) {
        super(listener);
        this.initUI();
    }

    private void initUI() {
        GbPanel panel = new GbPanel();
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        SHStrippedContentPanel contentsPanel = new SHStrippedContentPanel(panel);
        ColorPropagatingGBPanel mainPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 0, 3, 0));
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("TOOLS_CONFIGURE") + "</html>");
        for (Tool allTool : this.allTools = Tool.getAllToolsNoUI()) {
            allTool.setSimulateTool(true);
        }
        this.toolsPanel = new ToolsPanel(this.allTools, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolsPropertiesPanel.this.recheckValidity();
            }
        });
        this.toolsPanel.setRemoteOS(-1, -1);
        this.toolsPanel.getRootComponent().setBorder(SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR));
        SwingUtil.setWidth((JComponent)this.toolsPanel.getRootComponent(), (int)SimpleHelpLookAndFeel.scale((int)350));
        mainPanel.add((Component)description, 0, 0, 1, 1, 0, 0, 17, 2);
        mainPanel.add(this.toolsPanel.getRootComponent(), 0, 1, 1, 1, 1, 1, 17, 3);
        contentsPanel.addContentGrabVertical((JComponent)((Object)mainPanel), Language.get("TOOLS_DETAILS"), true);
        contentsPanel.setBackgroundColours();
        GbPanelWrapper mainWrapper = new GbPanelWrapper((Container)this);
        mainWrapper.add((Component)panel, 0, 0, 1, 1, 1, 1, 11, 1);
    }

    @Override
    public void load(Object loadFromObject) {
        Properties props = (Properties)loadFromObject;
        for (Tool allTool : this.allTools) {
            allTool.loadFrom(props, false);
        }
    }

    @Override
    public void save(Object saveToObject) {
        Properties props = (Properties)saveToObject;
        for (Tool allTool : this.allTools) {
            allTool.saveTo(props);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }
}

