/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.LocalProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class LayoutPreferencesPanel
extends PropertiesPage
implements ActionListener {
    private JCheckBox showChat;
    private JCheckBox enableEcho = new JCheckBox(Language.get("ENABLE_TEXT_ECHOING"));
    private JCheckBox enableControl = new JCheckBox(Language.get("ENABLE_CONTROL"));
    private JCheckBox showButtonBar;
    private JCheckBox showRecording;
    private JCheckBox darkMode;
    private JComboBox scalingBox;
    private JComboBox sizeBox;
    private JComboBox zoomBox;
    private static final boolean REMEMBER_SIZE = true;
    private boolean loading = false;

    public LayoutPreferencesPanel(PageListener listener) {
        super(listener);
        this.showChat = new JCheckBox(Language.get("SHOW_CHAT_OPTION"));
        this.showButtonBar = new JCheckBox(Language.get("SHOW_BUTTON_OPTION"));
        this.showRecording = new JCheckBox(Language.get("SHOW_RECORDING_SHORTCUTS"));
        this.darkMode = new JCheckBox(Language.get("USE_DARK_MODE"));
        this.zoomBox = new JComboBox<String>(new String[]{Language.get("TECH_UI_FIT_NO_ZOOM"), Language.get("TECH_UI_FIT_ALL"), Language.get("TECH_UI_FIT_HEIGHT")});
        this.sizeBox = new JComboBox<String>(new String[]{Language.get("MAXIMIZED"), "80 % " + Language.get("PERCENT_OF_THE_SCREEN"), "70 % " + Language.get("PERCENT_OF_THE_SCREEN"), "60 % " + Language.get("PERCENT_OF_THE_SCREEN"), "50 % " + Language.get("PERCENT_OF_THE_SCREEN"), Language.get("SAME_AS_LAST_SIZE"), Language.get("SAME_AS_LAST_SIZE_LOCATION")});
        this.sizeBox.setSelectedIndex(1);
        this.scalingBox = new JComboBox<String>(new String[]{Language.get("AUTODETECT"), "50 %", "75 %", "100 %", "125 %", "150 %", "200 %", "250 %", "300 %", "400 %"});
        this.scalingBox.setSelectedIndex(0);
        JLabel scalingLabel = new JLabel(Language.get("TECH_PROPERTIES_SCALING"));
        JLabel sizeLabel = new JLabel(Language.get("TECH_PROPERTIES_SIZE"));
        JLabel zoomLabel = new JLabel(Language.get("TECH_PROPERTIES_ZOOM"));
        JWrapLabel descLabel = new JWrapLabel("<html>" + Language.get("VISUAL_NEW_SESSION_DESC") + "</html>");
        JWrapLabel descTCLabel = new JWrapLabel("<html>" + Language.get("VISUAL_NEW_TC") + "</html>");
        this.showChat.addActionListener(this);
        this.showButtonBar.addActionListener(this);
        this.showRecording.addActionListener(this);
        this.darkMode.addActionListener(this);
        this.sizeBox.addActionListener(this);
        this.scalingBox.addActionListener(this);
        this.zoomBox.addActionListener(this);
        this.enableEcho.addActionListener(this);
        this.enableControl.addActionListener(this);
        GbPanel panel = new GbPanel();
        SHStrippedContentPanel contentsPanel = new SHStrippedContentPanel(panel);
        ColorPropagatingGBPanel sessionUIPreferences = new ColorPropagatingGBPanel();
        int Y = 0;
        sessionUIPreferences.add((Component)descLabel, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 5, 0));
        sessionUIPreferences.add(this.showChat, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        sessionUIPreferences.add(this.showButtonBar, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        sessionUIPreferences.add(this.enableControl, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        sessionUIPreferences.add(this.enableEcho, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        sessionUIPreferences.add(this.showRecording, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        sessionUIPreferences.add(sizeLabel, 0, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(0, 0, 5, 0));
        sessionUIPreferences.add(this.sizeBox, 1, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 10, 5, 0));
        sessionUIPreferences.add(zoomLabel, 0, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        sessionUIPreferences.add(this.zoomBox, 1, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 10, 0, 0));
        contentsPanel.addContent((JComponent)((Object)sessionUIPreferences), Language.get("SESSION_UI"));
        ColorPropagatingGBPanel techConsolePreferences = new ColorPropagatingGBPanel();
        Y = 0;
        techConsolePreferences.add((Component)descTCLabel, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 5, 0));
        techConsolePreferences.add(this.darkMode, 0, Y++, 2, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 5, 0));
        techConsolePreferences.add(scalingLabel, 0, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(0, 0, 5, 0));
        techConsolePreferences.add(this.scalingBox, 1, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 10, 5, 0));
        contentsPanel.addContent((JComponent)((Object)techConsolePreferences), Language.get("LAYOUT_PREFERENCE_TITLE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
        JScrollPane pane = new JScrollPane((Component)panel);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Object loadFromObject) {
        this.loading = true;
        try {
            Properties props = (Properties)loadFromObject;
            this.showChat.setSelected(props.getProperty(TechProperties.PROP_SHOW_CHAT, "on").equalsIgnoreCase("on"));
            this.showButtonBar.setSelected(props.getProperty(TechProperties.PROP_SHOW_MENU, "on").equalsIgnoreCase("on"));
            this.enableEcho.setSelected(props.getProperty(TechProperties.PROP_ENABLE_TEXT_ECHO, "on").equalsIgnoreCase("on"));
            this.enableControl.setSelected(props.getProperty(TechProperties.PROP_ENABLE_CONTROL, "on").equalsIgnoreCase("on"));
            this.showRecording.setSelected(props.getProperty(TechProperties.PROP_SHOW_RECORDING, "on").equalsIgnoreCase("on"));
            this.darkMode.setSelected(props.getProperty(TechProperties.PROP_DARK_MODE, "off").equalsIgnoreCase("on"));
            int scaling = LocalProperties.getScalingPercentageOverride();
            if (scaling <= 0) {
                this.scalingBox.setSelectedIndex(0);
            } else {
                try {
                    String percentage = scaling + " %";
                    this.scalingBox.setSelectedItem(percentage);
                }
                catch (Throwable t) {
                    this.scalingBox.setSelectedItem(0);
                }
            }
            try {
                System.out.println("[LayoutPreferencesPanel] Loading windows size option: " + props.getProperty(TechProperties.PROP_WINDOW_SIZE));
                this.sizeBox.setSelectedIndex(Integer.parseInt(props.getProperty(TechProperties.PROP_WINDOW_SIZE, "1")));
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.sizeBox.setSelectedIndex(3);
            }
            try {
                this.zoomBox.setSelectedIndex(Integer.parseInt(props.getProperty(TechProperties.PROP_ZOOM, "0")));
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.zoomBox.setSelectedIndex(0);
            }
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public void save(Object saveToObject) {
        Properties props = (Properties)saveToObject;
        props.setProperty(TechProperties.PROP_SHOW_CHAT, this.showChat.isSelected() ? "on" : "off");
        props.setProperty(TechProperties.PROP_SHOW_MENU, this.showButtonBar.isSelected() ? "on" : "off");
        props.setProperty(TechProperties.PROP_ENABLE_TEXT_ECHO, this.enableEcho.isSelected() ? "on" : "off");
        props.setProperty(TechProperties.PROP_ENABLE_CONTROL, this.enableControl.isSelected() ? "on" : "off");
        props.setProperty(TechProperties.PROP_SHOW_RECORDING, this.showRecording.isSelected() ? "on" : "off");
        props.setProperty(TechProperties.PROP_DARK_MODE, this.darkMode.isSelected() ? "on" : "off");
        System.out.println("[LayoutPreferencesPanel] Saving windows size option: " + this.sizeBox.getSelectedIndex());
        props.setProperty(TechProperties.PROP_WINDOW_SIZE, Integer.toString(this.sizeBox.getSelectedIndex()));
        props.setProperty(TechProperties.PROP_ZOOM, Integer.toString(this.zoomBox.getSelectedIndex()));
        LocalProperties.setDarkMode(this.darkMode.isSelected());
        try {
            if (this.scalingBox.getSelectedIndex() == 0) {
                LocalProperties.setScalingPercentageOverride(0);
            } else {
                String item = String.valueOf(this.scalingBox.getSelectedItem());
                if (item.contains("%")) {
                    item = item.substring(0, item.indexOf(37)).trim();
                    LocalProperties.setScalingPercentageOverride(Integer.parseInt(item));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            LocalProperties.setScalingPercentageOverride(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        boolean restartNow;
        if (this.loading) {
            return;
        }
        super.contentChanged(true);
        if (arg0.getSource() == this.darkMode) {
            boolean restartNow2 = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)Language.get("DARK_RESTART_M"), (String)Language.get("DARK_RESTART_T"), (Icon)ImageLoader.getImageIcon((String)"images/svg/arrows/reboot.svg,48"), (String)Language.get("RESTART_NOW"), (String)Language.get("RESTART_LATER"));
            if (restartNow2) {
                try {
                    JWSystem.forkVirtualApp((String)JWSystem.getMyAppName(), null, null, (boolean)false, (boolean)true);
                    Thread.sleep(1000L);
                    System.exit(0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else if (arg0.getSource() == this.scalingBox && (restartNow = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)Language.get("DARK_RESTART_M"), (String)Language.get("DARK_RESTART_T"), (Icon)ImageLoader.getImageIcon((String)"images/svg/arrows/reboot.svg,48"), (String)Language.get("RESTART_NOW"), (String)Language.get("RESTART_LATER")))) {
            try {
                JWSystem.forkVirtualApp((String)JWSystem.getMyAppName(), null, null, (boolean)false, (boolean)true);
                Thread.sleep(1000L);
                System.exit(0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }
}

