/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.notifiers;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.tech.notifiers.AbstractNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.ostools.OS;
import utils.swing.customlaf.SHBorderFactory;

public class FrameNotification
extends AbstractNotification {
    private static final int SLEEP = 4000;
    boolean enable = false;

    public FrameNotification(ResourceBundle lang) {
        super(lang);
    }

    @Override
    public void enable() {
        this.enable = true;
    }

    @Override
    public void disable() {
        this.enable = false;
    }

    @Override
    public void sendNotification(int customerCount, TreeSet joined, TreeSet left) {
        if (!this.enable) {
            return;
        }
        if (!this.join && left.size() == 0) {
            return;
        }
        if (!this.leave && joined.size() == 0) {
            return;
        }
        StringBuffer message1 = new StringBuffer();
        StringBuffer message2 = new StringBuffer();
        if (this.join) {
            if (joined.size() == 1) {
                message1.append("1 " + this.lang.getString("TRAY_MESSAGE_SINGLE"));
            } else if (joined.size() > 0) {
                message1.append(joined.size() + " " + this.lang.getString("TRAY_MESSAGE_MULTIPLE"));
            }
        }
        if (this.leave) {
            if (left.size() == 1) {
                message2.append("1 " + this.lang.getString("TRAY_MESSAGE_LEFT_SINGLE"));
            } else if (left.size() > 0) {
                message2.append(left.size() + " " + this.lang.getString("TRAY_MESSAGE_LEFT_MULTIPLE"));
            }
        }
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createEtchedBorder(), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        JLabel icon = new JLabel();
        icon.setIcon(ClientBranding.get().getLogo32(true));
        panel.add((Component)icon, "West");
        JPanel contentPanel = new JPanel();
        int count = 0;
        if (message1.length() > 0) {
            ++count;
        }
        if (message2.length() > 0) {
            ++count;
        }
        contentPanel.setLayout(new GridLayout(count, 1));
        if (message1.length() > 0) {
            JLabel label1 = new JLabel(message1.toString());
            label1.setHorizontalAlignment(2);
            contentPanel.add(label1);
        }
        if (message2.length() > 0) {
            JLabel label2 = new JLabel(message2.toString());
            label2.setHorizontalAlignment(2);
            contentPanel.add(label2);
        }
        panel.add((Component)contentPanel, "Center");
        frame.getContentPane().add(panel);
        frame.setUndecorated(true);
        frame.setDefaultCloseOperation(0);
        frame.setResizable(false);
        this.setAlwaysOnTop(frame, true);
        frame.setFocusableWindowState(false);
        frame.setFocusable(false);
        frame.pack();
        Toolkit toolkit = frame.getToolkit();
        Insets insets = toolkit.getScreenInsets(frame.getGraphicsConfiguration());
        Dimension frameSize = frame.getSize();
        Dimension size = toolkit.getScreenSize();
        if (OS.isWindows()) {
            frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right, size.height - (int)frameSize.getHeight() - insets.bottom);
        } else {
            frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right, insets.top);
        }
        frame.setVisible(true);
        new FrameCloser(frame, 4000).start();
    }

    private void setAlwaysOnTop(JFrame frame, boolean b) {
        try {
            Method method = frame.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
            method.invoke((Object)frame, new Boolean(b));
        }
        catch (Throwable t) {
            System.out.println("Frame notification not always on top - pre 1.5 JVM");
            return;
        }
    }

    public void setSettings(boolean enable, boolean join, boolean leave) {
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
        this.join = join;
        this.leave = leave;
    }

    private class FrameCloser
    extends Thread {
        private int sleep;
        private JFrame frame;

        public FrameCloser(JFrame frame, int sleep) {
            this.sleep = sleep;
            this.frame = frame;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.sleep);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }
}

