/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.notifiers;

import com.aem.sdesktop.server.sounds.SHSounds;
import com.aem.shelp.tech.notifiers.AbstractNotification;
import com.aem.utils.sound.SampledSound;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class AudioNotification
extends AbstractNotification {
    private boolean enable = false;
    private SampledSound sound = SHSounds.bell;

    public AudioNotification(ResourceBundle lang) {
        super(lang);
    }

    public SampledSound getSound() {
        return this.sound;
    }

    public void setSound(SampledSound sound) {
        this.sound = sound;
    }

    @Override
    public void enable() {
        this.enable = true;
    }

    @Override
    public void disable() {
        this.enable = false;
    }

    @Override
    public void sendNotification(int customerCount, TreeSet joined, TreeSet left) {
        if (this.enable) {
            boolean play;
            boolean bl = play = this.join && joined.size() > 0 || this.leave && left.size() > 0;
            if (this.sound != null && play) {
                SHSounds.play(this.sound);
            }
        }
    }

    public void setSettings(boolean audioEnabled, boolean playSoundOnJoin, boolean playSoundOnLeave, SampledSound sampledSound) {
        if (audioEnabled) {
            this.enable();
        } else {
            this.disable();
        }
        this.join = playSoundOnJoin;
        this.leave = playSoundOnLeave;
        this.sound = sampledSound;
    }
}

