/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.history.SessionDownloader;
import com.aem.shelp.tech.history.SessionPanel;
import com.aem.shelp.tech.history.SessionUploader;
import com.aem.shelp.tech.video.TechVideoRepository;
import com.aem.shelp.tech.video.VideoPlayer;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.files.FileUtil;
import utils.progtools.TimeUtil;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JSearchTextField;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class VideoPanel
extends ColorPropagatingGBPanel
implements ActionListener,
SessionUploader.UploaderListener {
    private final SessionPanel sessionPanel;
    private TechClient tc;
    private SessionUploader uploader;
    private JButton playVideoButton;
    private JButton deleteVideoButton;
    private JButton syncVideoButton;
    private JButton copyURLButton;
    private JLabel videoLabel;
    private TechClient.VideoDetails selectedSessionVideoDetails = null;
    private JSearchTextField passwordField;
    private JCheckBox passwordBox;
    private ColorPropagatingPanel passwordWrapper;
    private GbPanel syncPanel;
    private JLabel syncLabel;
    private JLabel htmlStatusLabel;
    private GbPanel copyPanel;
    private ColorPropagatingPanel copyPanelWrapper;
    private String suffix;
    private ElapsedTimeFormatter timeFormatter = new ElapsedTimeFormatter();

    public VideoPanel(SessionPanel sessionPanel) {
        this.sessionPanel = sessionPanel;
        this.initUI();
    }

    public void initUI() {
        this.playVideoButton = new JButton(Language.get("VIDEO_PLAY"), ImageLoader.getImageIcon((String)"images/svg/av/play.svg,16"));
        this.deleteVideoButton = new JButton(Language.get("DELETE"));
        this.playVideoButton.addActionListener(this);
        this.deleteVideoButton.addActionListener(this);
        this.videoLabel = new JLabel();
        SHButtonUI.makeButtonRed((JButton)this.deleteVideoButton);
        this.syncVideoButton = new JButton(Language.get("VIDEO_SEND_TO_SERVER"));
        this.copyURLButton = new JButton(Language.get("VIDEO_SHARE"));
        SwingUtil.setHeight((JComponent)this.syncVideoButton, (int)this.playVideoButton.getPreferredSize().height);
        SwingUtil.setHeight((JComponent)this.copyURLButton, (int)this.playVideoButton.getPreferredSize().height);
        this.syncLabel = new JLabel();
        this.syncLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.playVideoButton, this.copyURLButton, this.deleteVideoButton, this.syncVideoButton});
        this.playVideoButton.setHorizontalAlignment(2);
        this.deleteVideoButton.setHorizontalAlignment(2);
        this.copyURLButton.setHorizontalAlignment(2);
        this.syncVideoButton.setHorizontalAlignment(2);
        this.passwordField = new JSearchTextField(Language.get("VIDEO_NO_PASSWORD"));
        this.passwordBox = new JCheckBox(Language.get("VIDEO_PASSWORD"));
        this.passwordBox.addActionListener(this);
        SwingUtil.setWidth((JComponent)this.passwordField, (int)SimpleHelpLookAndFeel.scale((int)200));
        this.passwordField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                VideoPanel.this.savePassword();
            }
        });
        this.htmlStatusLabel = new JLabel();
        this.htmlStatusLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.syncPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 5, 3, 0));
        this.syncPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.syncPanel.add((Component)this.syncVideoButton, 0, 0, 1, 1, 0, 1, 17, 0);
        this.syncPanel.add((Component)this.syncLabel, 1, 0, 1, 1, 1, 1, 17, 0);
        this.copyPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 5, 3, 0));
        this.copyPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.copyPanel.add((Component)this.copyURLButton, 0, 0, 1, 1, 0, 1, 17, 0);
        this.copyPanel.add((Component)this.htmlStatusLabel, 1, 0, 1, 1, 1, 1, 17, 0);
        ColorPropagatingPanel syncPanelWrapper = new ColorPropagatingPanel((LayoutManager)new GridLayout(1, 1));
        syncPanelWrapper.add((Component)this.syncPanel);
        this.copyPanelWrapper = new ColorPropagatingPanel((LayoutManager)new GridLayout(1, 1));
        this.copyPanelWrapper.add((Component)this.copyPanel);
        this.passwordWrapper = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
        this.passwordWrapper.add((Component)this.passwordBox, (Object)"West");
        this.passwordWrapper.add((Component)this.passwordField, (Object)"Center");
        this.syncVideoButton.addActionListener(this);
        this.copyURLButton.addActionListener(this);
        int Y = 0;
        this.add(this.videoLabel, 0, Y++, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 5, 3, 0));
        this.add(this.playVideoButton, 0, Y++, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(3, 5, 3, 0));
        this.add((Component)this.copyPanelWrapper, 0, Y++, 2, 1, 0, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.add((Component)syncPanelWrapper, 0, Y++, 2, 1, 0, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.add(this.deleteVideoButton, 0, Y++, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(3, 5, 3, 0));
        this.add((Component)this.passwordWrapper, 0, Y++, 2, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(3, 5, 3, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.passwordBox) {
            this.updatePasswordBoxEnabled();
        } else if (e.getSource() == this.playVideoButton) {
            new PlayVideoThread();
        } else if (e.getSource() == this.deleteVideoButton) {
            if (!SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)((Object)this)), (String)Language.get("VIDEO_REMOVE_MSG"), (String)Language.get("VIDEO_REMOVE"), null, (String)Language.get("REMOVE"), (String)Language.get("CANCEL"))) {
                return;
            }
            File videoFile = TechVideoRepository.getVideoFileFor(this.sessionPanel.getSelectedSession());
            if (videoFile.exists()) {
                videoFile.delete();
            }
            try {
                this.tc.deleteVideo(this.sessionPanel.getSelectedSession());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.sessionPanel.setVideoSectionVisible(false);
        } else if (e.getSource() == this.syncVideoButton) {
            File videoFile = TechVideoRepository.getVideoFileFor(this.sessionPanel.getSelectedSession());
            if (this.uploader != null) {
                this.uploader.addFileToUpload(this.sessionPanel.getSelectedSession(), videoFile);
            } else {
                new DummyUploader(this.sessionPanel.getSelectedSession().getSessionID()).start();
            }
            this.syncVideoButton.setEnabled(false);
            this.syncVideoButton.setIcon(new SHProgressAnimatedIcon());
        } else if (e.getSource() == this.copyURLButton) {
            ClipboardUtil.setClipboardAsText(SHJWUtil.getUpdateURLProtocol() + "://" + this.tc.getVirtualServerHostname() + "/session/" + this.selectedSessionVideoDetails.videoID);
        }
    }

    public void setTechClient(TechClient tc, SessionUploader uploader) {
        this.tc = tc;
        this.uploader = uploader;
        if (uploader != null) {
            uploader.setUploaderListener(this);
        }
        boolean showUploadButton = true;
        if (tc != null) {
            if (tc.getPermissions().mustAlwaysUpload()) {
                showUploadButton = false;
            } else if (!tc.getPermissions().canUpload()) {
                showUploadButton = false;
            }
        }
        this.setSyncPanelVisible(showUploadButton);
        this.deleteVideoButton.setVisible(tc == null || tc.getPermissions().canManageRecordings());
        this.passwordWrapper.setVisible(tc == null || tc.getPermissions().canManageRecordings());
    }

    public void loadSelectedSessionVideo(TechClient.VideoDetails selectedSessionVideoDetails, boolean isLocal) {
        this.selectedSessionVideoDetails = selectedSessionVideoDetails;
        SwingUtilities.invokeLater(new ServerVideoUpdater(selectedSessionVideoDetails, isLocal));
    }

    private void setSyncPanelVisible(boolean b) {
        boolean canUpload = true;
        if (this.tc != null && !this.tc.getPermissions().canUpload()) {
            canUpload = false;
        }
        this.syncPanel.setVisible(b && canUpload);
        this.syncVideoButton.setVisible(b && canUpload);
        this.syncLabel.setVisible(b && canUpload);
    }

    private void updatePasswordBoxEnabled() {
        if (this.passwordBox.isSelected()) {
            this.passwordField.setEnabled(true);
            this.savePassword();
        } else {
            this.passwordField.setEnabled(false);
            this.savePassword();
        }
    }

    private void savePassword() {
        if (this.sessionPanel.getSelectedSession() == null) {
            return;
        }
        String videoPassword = this.passwordField.getText();
        try {
            if (this.tc != null) {
                this.tc.setVideoPassword(this.sessionPanel.getSelectedSession().getStartTime(), this.sessionPanel.getSelectedSession().getSessionID(), videoPassword);
            } else {
                System.out.println("[SessionPanel] Save password requested, but there is no TC? Demo test?");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void setPlayButtonState(boolean isDownloading) {
        if (isDownloading) {
            this.playVideoButton.setEnabled(false);
            this.playVideoButton.setIcon(new SHProgressAnimatedIcon());
        } else {
            this.playVideoButton.setEnabled(true);
            this.playVideoButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/av/play.svg,16"));
        }
    }

    @Override
    public void starting(String id) {
        if (id == null || this.sessionPanel.getSelectedSession() == null) {
            return;
        }
        if (id.equals(this.sessionPanel.getSelectedSession().getSessionID())) {
            // empty if block
        }
    }

    @Override
    public void progress(String id, long sentBytes, long totalBytes) {
        if (id == null || this.sessionPanel.getSelectedSession() == null) {
            return;
        }
        if (id.equals(this.sessionPanel.getSelectedSession().getSessionID())) {
            long percentage = sentBytes * 100L / totalBytes;
            this.syncLabel.setText(Language.get("VIDEO_UPLOAD_PROGRESS") + "... (" + percentage + "%)");
        }
    }

    @Override
    public void done(String id) {
        if (id == null || this.sessionPanel.getSelectedSession() == null) {
            return;
        }
        if (id.equals(this.sessionPanel.getSelectedSession().getSessionID())) {
            this.syncVideoButton.setEnabled(false);
            this.syncVideoButton.setIcon(null);
            this.syncLabel.setText(Language.get("VIDEO_UPLOAD_DONE"));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.syncLabel.setText("");
            this.videoLabel.setText("<html>" + Language.get("VIDEO_SERVER") + this.suffix);
            this.sessionPanel.queryServer(false);
        }
    }

    public void setVideoDetails(long length, long videoDuration) {
        this.suffix = "";
        if (videoDuration > 0L) {
            videoDuration = TimeUtil.stripMS((long)videoDuration);
            this.suffix = " - <font color=\"#8A8A8A\">" + this.timeFormatter.getCompleteFormattedTime(videoDuration);
        }
        if (length > 0L) {
            double sizeInMB = (double)length / 1024.0 / 1024.0;
            sizeInMB = Math.round(sizeInMB * 10.0);
            this.suffix = this.suffix + " (" + (sizeInMB /= 10.0) + " MB)";
        }
        this.videoLabel.setText("<html>" + Language.get("VIDEO_LOCAL") + this.suffix);
    }

    private class PlayVideoThread
    extends Thread {
        boolean die;
        File tempVideoDir;

        public PlayVideoThread() {
            super("PlayVideoThread");
            this.die = false;
            this.tempVideoDir = null;
            this.start();
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File videoFile;
            block8: {
                block7: {
                    ArrayList<File> files = null;
                    if (!((VideoPanel)VideoPanel.this).selectedSessionVideoDetails.existsOnServer) break block7;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VideoPanel.this.setPlayButtonState(true);
                        }
                    });
                    try {
                        try {
                            this.tempVideoDir = File.createTempFile("shvideo", "tmp");
                            this.tempVideoDir.delete();
                            this.tempVideoDir.mkdirs();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        System.out.println("[SessionPanel] Requested to view a video stored on the server.");
                        System.out.println("[SessionPanel] Downloading to " + this.tempVideoDir);
                        SessionDownloader downloader = new SessionDownloader(VideoPanel.this.tc, VideoPanel.this.sessionPanel.getSelectedSession(), VideoPanel.this.selectedSessionVideoDetails, this.tempVideoDir, new SessionDownloader.DownloaderListener(){

                            @Override
                            public void starting(String id) {
                                System.out.println("[SessionPanel] Starting download " + id);
                            }

                            @Override
                            public void progress(String id, long gotBytes, long totalBytes) {
                                System.out.println("[SessionPanel] Progress " + id + " " + gotBytes + "/" + totalBytes);
                            }

                            @Override
                            public void done(boolean worked, String id, File targetFile) {
                                System.out.println("[SessionPanel] Finished " + id + " " + worked + " - " + targetFile);
                            }
                        });
                        downloader.run();
                        files = downloader.getDownloadedFiles();
                        videoFile = files.get(0);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VideoPanel.this.setPlayButtonState(false);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    break block8;
                }
                videoFile = TechVideoRepository.getVideoFileFor(VideoPanel.this.sessionPanel.getSelectedSession());
            }
            if (this.die) {
                return;
            }
            SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
            frame.setDefaultCloseOperation(2);
            frame.setTitle(VideoPanel.this.sessionPanel.getSelectedSession().getDescription());
            frame.setSize(700, 512);
            frame.setIconImage(ImageLoader.getAsImage((String)"images/svg/logos/simplehelp-blue.svg,48"));
            frame.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (PlayVideoThread.this.tempVideoDir != null) {
                        FileUtil.deleteDir((File)PlayVideoThread.this.tempVideoDir);
                    }
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            VideoPlayer player = new VideoPlayer(videoFile, true);
            this.initCleanup(player, frame);
            frame.setContentPane((Container)player.getRootComponent());
            frame.setVisible(true);
            try {
                player.loadVideo();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            player.playFromIndex(0L);
        }

        private void initCleanup(final VideoPlayer player, SimpleHelpFrame frame) {
            frame.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    player.cleanup();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
        }
    }

    private class DummyUploader
    extends Thread {
        private String id;

        public DummyUploader(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            VideoPanel.this.starting(this.id);
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                VideoPanel.this.progress(this.id, i + 1, 10L);
            }
            VideoPanel.this.done(this.id);
        }
    }

    class ServerVideoUpdater
    implements Runnable {
        private TechClient.VideoDetails details;
        private boolean existsLocally;

        public ServerVideoUpdater(TechClient.VideoDetails details, boolean existsLocally) {
            this.details = details;
            this.existsLocally = existsLocally;
        }

        @Override
        public void run() {
            VideoPanel.this.passwordBox.setSelected(false);
            VideoPanel.this.passwordField.setEnabled(false);
            VideoPanel.this.passwordField.setText(null);
            if (!(this.details != null && this.details.existsOnServer || this.existsLocally)) {
                VideoPanel.this.sessionPanel.setVideoSectionVisible(false);
            } else if (this.details == null || !this.details.existsOnServer) {
                VideoPanel.this.sessionPanel.setVideoSectionVisible(true);
                VideoPanel.this.setSyncPanelVisible(true);
                VideoPanel.this.copyURLButton.setVisible(false);
                VideoPanel.this.htmlStatusLabel.setVisible(false);
                if (VideoPanel.this.uploader != null && VideoPanel.this.uploader.isUploadingOrQueued(VideoPanel.this.sessionPanel.getSelectedSession().getSessionID())) {
                    VideoPanel.this.syncLabel.setText(Language.get("VIDEO_UPLOAD_WAIT") + "...");
                    VideoPanel.this.syncVideoButton.setEnabled(false);
                    VideoPanel.this.syncVideoButton.setIcon(new SHProgressAnimatedIcon());
                } else {
                    VideoPanel.this.syncLabel.setText(Language.get("VIDEO_SYNC_DESC"));
                    VideoPanel.this.syncVideoButton.setEnabled(true);
                    VideoPanel.this.syncVideoButton.setIcon(null);
                }
                VideoPanel.this.sessionPanel.setVideoSectionVisible(true);
            } else if (this.details != null && this.details.existsOnServer) {
                VideoPanel.this.sessionPanel.setVideoSectionVisible(true);
                VideoPanel.this.setSyncPanelVisible(false);
                VideoPanel.this.copyURLButton.setVisible(true);
                VideoPanel.this.htmlStatusLabel.setVisible(true);
                if (this.details.htmlExistsOnServer) {
                    VideoPanel.this.htmlStatusLabel.setText(Language.get("VIDEO_CONVERTED"));
                } else {
                    VideoPanel.this.htmlStatusLabel.setText(Language.get("VIDEO_NOT_YET_CONVERTED"));
                }
                VideoPanel.this.setVideoDetails(this.details.lengthInBytes, this.details.duration);
                if (this.details.hasPassword()) {
                    VideoPanel.this.passwordBox.setSelected(true);
                    VideoPanel.this.passwordField.setEnabled(true);
                    VideoPanel.this.passwordField.setText(this.details.getPassword());
                } else {
                    VideoPanel.this.passwordBox.setSelected(false);
                    VideoPanel.this.passwordField.setEnabled(false);
                    VideoPanel.this.passwordField.setText(null);
                }
                VideoPanel.this.videoLabel.setText("<html>" + Language.get("VIDEO_SERVER") + VideoPanel.this.suffix);
                VideoPanel.this.sessionPanel.setVideoSectionVisible(true);
            }
        }
    }
}

