/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.mdupload.fs.FSMirror;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import jwrapper.jwutils.JWSystem;
import utils.dataservice.gziplist.SplitChunkList;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;

public class SessionUploader {
    private final LinkedList<UploadItem> idsToUpload = new LinkedList();
    private File queueFile = new File(JWSystem.getAllAppVersionsSharedFolder(), "upload.queue");
    private final SessionUploadThread sessionUploadThreadHandler;
    private TechClient tc;
    private Thread uploadThread;
    private UploadItem currentItem;
    private UploaderListener listener;

    public SessionUploader(TechClient tc) {
        this.loadFrom();
        this.tc = tc;
        this.sessionUploadThreadHandler = new SessionUploadThread();
        this.uploadThread = new Thread((Runnable)this.sessionUploadThreadHandler, "SessionUploadThread");
        this.uploadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo() {
        LinkedList<UploadItem> linkedList = this.idsToUpload;
        synchronized (linkedList) {
            System.out.println("[SessionUploader] Saving queue of size " + this.idsToUpload.size());
            if (this.idsToUpload.size() == 0) {
                if (this.queueFile.exists()) {
                    this.queueFile.delete();
                }
                return;
            }
            try {
                AtomicFileOutputStream fout = new AtomicFileOutputStream(this.queueFile);
                try {
                    StreamUtils.writeInt((OutputStream)fout, this.idsToUpload.size());
                    for (UploadItem item : this.idsToUpload) {
                        StreamUtils.writeStringUTF8((OutputStream)fout, item.sessionID);
                        StreamUtils.writeStringUTF8((OutputStream)fout, item.file.getAbsolutePath());
                        StreamUtils.writeLong((OutputStream)fout, item.startTime);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    FileUtil.robustClose((OutputStream)fout);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFrom() {
        if (!this.queueFile.exists() || this.queueFile.length() == 0L) {
            return;
        }
        LinkedList<UploadItem> linkedList = this.idsToUpload;
        synchronized (linkedList) {
            this.idsToUpload.clear();
            try {
                AtomicFileOutputStream.prepareForReading((File)this.queueFile);
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(this.queueFile));
                try {
                    int count = StreamUtils.readInt(bin);
                    System.out.println("[SessionUploader] Loading queue of size " + count);
                    for (int i = 0; i < count; ++i) {
                        UploadItem item = new UploadItem();
                        item.sessionID = StreamUtils.readNStringUTF8(bin, 1000);
                        item.file = new File(StreamUtils.readNStringUTF8(bin, 1000));
                        item.startTime = StreamUtils.readLong(bin);
                        this.idsToUpload.add(item);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    FileUtil.robustClose((InputStream)bin);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void setUploaderListener(UploaderListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToUpload(AbstractSession session, File file) {
        LinkedList<UploadItem> linkedList = this.idsToUpload;
        synchronized (linkedList) {
            UploadItem item = new UploadItem();
            item.file = file;
            item.startTime = session.getStartTime();
            item.sessionID = session.getSessionID();
            this.idsToUpload.add(item);
            this.saveTo();
            this.idsToUpload.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToUpload(String sessionID, long startTime, File file) {
        if (file == null) {
            return;
        }
        LinkedList<UploadItem> linkedList = this.idsToUpload;
        synchronized (linkedList) {
            if (this.isUploadingOrQueued(sessionID)) {
                System.out.println("[SessionUploader] " + file.getName() + " is already in the queue...");
                return;
            }
            UploadItem item = new UploadItem();
            item.file = file;
            item.startTime = startTime;
            if (sessionID == null) {
                file.delete();
                return;
            }
            item.sessionID = sessionID;
            this.idsToUpload.add(item);
            this.saveTo();
            this.idsToUpload.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUploadingOrQueued(String sessionID) {
        LinkedList<UploadItem> linkedList = this.idsToUpload;
        synchronized (linkedList) {
            if (this.currentItem != null && this.currentItem.sessionID.equals(sessionID)) {
                return true;
            }
            for (UploadItem newItem : this.idsToUpload) {
                if (!newItem.sessionID.equals(sessionID)) continue;
                return true;
            }
        }
        return false;
    }

    class SessionUploadThread
    implements Runnable,
    FSMirror.ProgressListener {
        private boolean die = false;
        private String id;
        private long totalToUpload;
        private long totalUploaded;

        SessionUploadThread() {
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.die) {
                LinkedList linkedList = SessionUploader.this.idsToUpload;
                synchronized (linkedList) {
                    System.out.println("[SessionUploader] About to wait.");
                    while (SessionUploader.this.idsToUpload.size() == 0) {
                        try {
                            SessionUploader.this.idsToUpload.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.out.println("[SessionUploader] Woke up! " + SessionUploader.this.idsToUpload.size() + " items in queue for me to deal with.");
                    }
                    SessionUploader.this.currentItem = (UploadItem)SessionUploader.this.idsToUpload.getFirst();
                }
                if (SessionUploader.this.currentItem == null) continue;
                this.id = ((SessionUploader)SessionUploader.this).currentItem.sessionID;
                long startTime = ((SessionUploader)SessionUploader.this).currentItem.startTime;
                System.out.println("[SessionUploader] Instructed to upload " + ((SessionUploader)SessionUploader.this).currentItem.file + " [" + this.id + "]");
                File sourceFirstFile = ((SessionUploader)SessionUploader.this).currentItem.file;
                if (sourceFirstFile.exists()) {
                    try {
                        SessionUploader.this.listener.starting(this.id);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        File targetFile = new File(SessionUploader.this.tc.getVideoFileName(startTime, this.id, ".esvf"));
                        File file = sourceFirstFile;
                        while (file.exists()) {
                            AtomicFileOutputStream.prepareForReading((File)file);
                            TechClientFS techFS = new TechClientFS(SessionUploader.this.tc, "SG_Server");
                            LocalFS localFS = new LocalFS();
                            GFile sourceGFile = LocalFS.getFile(file);
                            GFile targetGFile = new GFile(targetFile.getPath(), targetFile.getName(), file.lastModified(), file.length(), targetFile.isDirectory(), file.isHidden());
                            new FSMirror().mirror(localFS, sourceGFile, techFS, targetGFile);
                            System.out.println("[SessionUploader] Upload complete. Deleting local copy.");
                            file.delete();
                            file = SplitChunkList.iterate(file);
                            targetFile = SplitChunkList.iterate(targetFile);
                        }
                        SessionUploader.this.tc.notifyServerOfUploadedVideo(startTime, this.id);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            SessionUploader.this.listener.done(this.id);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                LinkedList linkedList2 = SessionUploader.this.idsToUpload;
                synchronized (linkedList2) {
                    SessionUploader.this.idsToUpload.removeFirst();
                    SessionUploader.this.saveTo();
                }
                SessionUploader.this.currentItem = null;
            }
        }

        @Override
        public void transferred(long bytes) {
            this.totalUploaded += bytes;
            SessionUploader.this.listener.progress(this.id, this.totalUploaded, this.totalToUpload);
        }

        @Override
        public void totalSize(long size) {
            this.totalToUpload = size;
        }

        @Override
        public boolean cancelled() {
            return false;
        }
    }

    class UploadItem {
        String sessionID;
        File file;
        long startTime;

        UploadItem() {
        }

        public boolean equals(Object o) {
            return o instanceof UploadItem && ((UploadItem)o).sessionID.equals(this.sessionID);
        }
    }

    static interface UploaderListener {
        public void starting(String var1);

        public void progress(String var1, long var2, long var4);

        public void done(String var1);
    }
}

