/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.authentication;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClientListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapCheckBox;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class TwoTierCodeEntryGlassDialog
extends AbstractDialogPanel
implements ActionListener,
KeyListener {
    private JButton bdone;
    private JButton rerequest;
    private JButton switchuser;
    private boolean incorrectWarning;
    private String code;
    private JTextField field = new JTextField();
    private JWrapCheckBox rememberBox;
    private String emailAddress;
    private boolean allowRemember;
    private boolean remember;
    private boolean newUser;

    public TwoTierCodeEntryGlassDialog(RootPaneContainer frame, boolean incorrectWarning, String emailAddress, boolean allowRemember) {
        this.incorrectWarning = incorrectWarning;
        this.allowRemember = allowRemember;
        this.emailAddress = emailAddress;
        this.initUI();
        AbstractGlassDialog dialog = new AbstractGlassDialog(frame, 450, (AbstractDialogPanel)this);
        dialog.setTitle(Language.get("TWO_TIER_CODE_TITLE"));
        dialog.setShowDecoration(true);
        dialog.showDialog();
    }

    private void initUI() {
        String message = Language.get("TWO_TIER_CODE_TITLE_MSG1") + "    <B>" + this.emailAddress + "</B>. <BR><BR>" + Language.get("TWO_TIER_CODE_TITLE_MSG2");
        FixedWidthLabel desc = new FixedWidthLabel("<html>" + message + "</html>");
        desc.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)400));
        desc.setHorizontalAlignment(0);
        FixedWidthLabel warning = new FixedWidthLabel(Language.get("TWO_TIER_INVALID_CODE"));
        warning.setForeground(SHStyle.ERROR_TEXT_COLOR);
        warning.setHorizontalAlignment(0);
        this.rememberBox = new JWrapCheckBox(Language.get("ADMIN_TWO_TIER_DIALOG_REMEMBER"));
        this.rerequest = new JButton(Language.get("REREQUEST"));
        this.field.setHorizontalAlignment(2);
        ((AbstractDocument)this.field.getDocument()).setDocumentFilter(new UppercaseDocumentFilter());
        FixedWidthPanel contentPanel = new FixedWidthPanel();
        GbPanelWrapper panel = new GbPanelWrapper((Container)contentPanel);
        int Y = 0;
        panel.add((Component)desc, 0, Y++, 2, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 10, 0));
        if (this.incorrectWarning) {
            panel.add((Component)warning, 0, Y++, 5, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(10, 0, 10, 0));
        }
        panel.add((Component)this.field, 0, Y, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(10, 0, 10, 0));
        panel.add((Component)this.rerequest, 1, Y++, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(10, 0, 10, 0));
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.rerequest);
        SwingUtil.setHeight((JComponent)this.rerequest, (int)this.field.getPreferredSize().height);
        if (this.allowRemember) {
            panel.add((Component)this.rememberBox.getRootComponent(), 0, Y++, 2, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        }
        this.field.addKeyListener(this);
        FixedWidthPanel fixedWidthPanel = new FixedWidthPanel((JComponent)contentPanel);
        this.setContent((FixedWidthComponent)fixedWidthPanel);
        this.switchuser = this.addLeftButton(Language.get("SWITCH_USER"), false, this);
        this.bdone = this.addRightButton(Language.get("SUBMIT"), true, this);
        this.bdone.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.switchuser.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
        SHButtonUI.makeButtonBlue((JButton)this.bdone);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.field.getText().length() > 0) {
            this.bdone.setEnabled(true);
        } else {
            this.bdone.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.bdone.isEnabled()) {
                this.actionPerformed(this.bdone);
            }
        } else if (e.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void actionPerformed(Object o) {
        if (o == this.bdone) {
            this.newUser = false;
            this.code = this.field.getText();
            this.remember = this.rememberBox.getCheckBoxComponent().isSelected();
            this.dialogHandler.okPressed();
        } else if (o == this.switchuser) {
            this.code = null;
            this.remember = false;
            this.newUser = true;
            this.dialogHandler.closeDialog((JComponent)this.switchuser);
        } else if (o == this.rerequest) {
            this.newUser = false;
            this.code = null;
            this.remember = false;
            this.dialogHandler.closeDialog((JComponent)this.rerequest);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateEnabled();
    }

    public void requestFocus(Object source) {
        if (source.equals(this.field)) {
            this.field.requestFocusInWindow();
            this.field.selectAll();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public TechClientListener.TwoTierResponse getCode() throws SwitchUserException {
        if (this.newUser) {
            throw new SwitchUserException();
        }
        TechClientListener.TwoTierResponse response = new TechClientListener.TwoTierResponse();
        response.enteredCode = this.code;
        response.rememberMachine = this.remember;
        response.switchUser = this.newUser;
        return response;
    }

    public static void main(String[] args) throws IOException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(700, 500);
        frame.setVisible(true);
        Language.loadTranslations();
        TwoTierCodeEntryGlassDialog dialog = new TwoTierCodeEntryGlassDialog((RootPaneContainer)frame, false, "george.christelis@gmail.com", true);
        dialog = new TwoTierCodeEntryGlassDialog((RootPaneContainer)frame, true, "george.christelis@gmail.com", true);
        dialog = new TwoTierCodeEntryGlassDialog((RootPaneContainer)frame, true, "george.christelis@gmail.com", false);
        dialog = new TwoTierCodeEntryGlassDialog((RootPaneContainer)frame, false, "george.christelis@gmail.com", false);
    }

    public static class SwitchUserException
    extends Exception {
    }

    static class UppercaseDocumentFilter
    extends DocumentFilter {
        UppercaseDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, text.toUpperCase(), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            fb.replace(offset, length, text.toUpperCase(), attrs);
        }
    }
}

