/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.authentication;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.JWrapTextPaneLabel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class TOTPCodeEntryGlassDialog
extends AbstractDialogPanel
implements ActionListener,
KeyListener {
    private final String message;
    private JButton bdone;
    private JButton switchuser;
    private boolean incorrectWarning;
    private String code;
    private JTextField field;
    private JWrapCheckBox rememberBox;
    private boolean allowRemember;
    private boolean remember;
    private boolean newUser;
    private JWrapTextPaneLabel desc;

    public TOTPCodeEntryGlassDialog(RootPaneContainer frame, boolean incorrectWarning, boolean allowRemember) {
        this(frame, incorrectWarning, allowRemember, Language.get("TOTP_CODE_ENTRY_DESC"));
    }

    public TOTPCodeEntryGlassDialog(RootPaneContainer frame, boolean incorrectWarning, boolean allowRemember, String message) {
        this.incorrectWarning = incorrectWarning;
        this.allowRemember = allowRemember;
        this.message = message;
        this.initUI();
        AbstractGlassDialog dialog = new AbstractGlassDialog(frame, 450, (AbstractDialogPanel)this);
        dialog.setTitle(Language.get("TWO_TIER_CODE_TITLE"));
        dialog.setShowDecoration(true);
        dialog.showDialog();
    }

    private void initUI() {
        FixedWidthLabel desc = new FixedWidthLabel("<html>" + this.message);
        desc.setPreferredWidth(400);
        FixedWidthLabel warning = new FixedWidthLabel(Language.get("TWO_TIER_INVALID_CODE"));
        warning.setPreferredWidth(400);
        warning.setForeground(SHStyle.ERROR_TEXT_COLOR);
        warning.setHorizontalAlignment(0);
        this.rememberBox = new JWrapCheckBox(Language.get("ADMIN_TWO_TIER_DIALOG_REMEMBER"));
        this.field = TextField.getTextFieldForType((int)1);
        this.field.setHorizontalAlignment(2);
        SwingUtil.setWidth((JComponent)this.field, (int)SimpleHelpLookAndFeel.scale((int)150));
        FixedWidthPanel contentPanel = new FixedWidthPanel();
        GbPanelWrapper panel = new GbPanelWrapper((Container)contentPanel);
        int Y = 0;
        panel.add((Component)desc, 0, Y++, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 10, 0));
        if (this.incorrectWarning) {
            panel.add((Component)warning, 0, Y++, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(10, 0, 10, 0));
        }
        panel.add((Component)this.field, 0, Y++, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(10, 0, 10, 0));
        if (this.allowRemember) {
            panel.add((Component)this.rememberBox.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        }
        this.field.addKeyListener(this);
        FixedWidthPanel fixedWidthPanel = new FixedWidthPanel((JComponent)contentPanel);
        this.setContent((FixedWidthComponent)fixedWidthPanel);
        this.switchuser = this.addLeftButton(Language.get("SWITCH_USER"), false, this);
        this.bdone = this.addRightButton(Language.get("SUBMIT"), true, this);
        this.bdone.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.switchuser.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
        SHButtonUI.makeButtonBlue((JButton)this.bdone);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.field.getText().length() > 0) {
            this.bdone.setEnabled(true);
        } else {
            this.bdone.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.bdone.isEnabled()) {
                this.actionPerformed(this.bdone);
            }
        } else if (e.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void actionPerformed(Object o) {
        if (o == this.bdone) {
            this.newUser = false;
            this.code = this.field.getText();
            this.remember = this.rememberBox.getCheckBoxComponent().isSelected();
            this.dialogHandler.closeDialog((JComponent)this.bdone);
        } else if (o == this.switchuser) {
            this.code = null;
            this.remember = false;
            this.newUser = true;
            this.dialogHandler.closeDialog((JComponent)this.switchuser);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateEnabled();
    }

    public void requestFocus(Object source) {
        if (source.equals(this.field)) {
            this.field.requestFocusInWindow();
            this.field.selectAll();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) throws IOException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(700, 500);
        frame.setVisible(true);
        Language.loadTranslations();
        TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, false, true, "This is an example message which is realistic because we could get anything back from the RADIUS server. You should try to enter another code now please.");
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, false, true, "This is an example message which is realistic because we could get anything back from the RADIUS server. his is an example message which is realistic because we could get anything back from the RADIUS server. his is an example message which is realistic because we could get anything back from the RADIUS server.");
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, false, true, "This is an example message which is realistic because we could get anything back from the RADIUS server.");
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, false, true, "This.");
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, true, true);
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, true, false);
        dialog = new TOTPCodeEntryGlassDialog((RootPaneContainer)frame, false, false);
    }

    public TechClientListener.TwoTierResponse getCode() throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        if (this.newUser) {
            throw new TwoTierCodeEntryGlassDialog.SwitchUserException();
        }
        TechClientListener.TwoTierResponse response = new TechClientListener.TwoTierResponse();
        response.enteredCode = this.code;
        response.rememberMachine = this.remember;
        response.switchUser = this.newUser;
        return response;
    }
}

