/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;

public class TechConsoleRestrictionsPanel
extends BorderPanel
implements ActionListener,
ProfileAccountsConfig.ProfileAccountsReadyListener {
    private final ColorPropagatingGBPanel rootComponent;
    private AppProfile profile;
    private ProfileAccountsConfig pconfig;
    private TechClient client;
    private RootPaneContainer rpc;
    private JComboBox useSimplifiedUIBox;
    private JCheckBox allowFiles;
    private JCheckBox allowDiagnostics;
    private JCheckBox allowChat;
    private final ColorPropagatingGBPanel simplifiedUIPanel;
    private final ColorPropagatingGBPanel complexUIPanel;
    private boolean loadedConfig = false;
    private boolean loading = false;

    public TechConsoleRestrictionsPanel(RootPaneContainer rpc, TechClient client, final AppProfile profile, ProfileAccountsConfig config) {
        this.profile = profile;
        this.pconfig = config;
        this.client = client;
        this.rpc = rpc;
        config.addProfileAccountsReadyListener(this);
        this.useSimplifiedUIBox = new JComboBox<String>(new String[]{Language.get("GA_UI_SIMPLE"), Language.get("GA_UI_FULL")});
        this.allowFiles = new JCheckBox(Language.get("ADMIN_GROUP_CAN_FILE_TRANSFER"));
        this.allowChat = new JCheckBox(Language.get("GROUP_ACCESS_ALLOW_CHAT"));
        this.allowDiagnostics = new JCheckBox(Language.get("GROUP_ACCESS_ALLOW_DIAG"));
        this.rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 5));
        this.useSimplifiedUIBox.addActionListener(this);
        this.allowFiles.addActionListener(this);
        this.allowChat.addActionListener(this);
        this.allowDiagnostics.addActionListener(this);
        int N = 0;
        ColorPropagatingGBPanel uiPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 5));
        this.simplifiedUIPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 10, 3, 5));
        this.simplifiedUIPanel.add(this.allowFiles, 0, 0, 1, 1, 1, 0, 17, 0);
        this.simplifiedUIPanel.add(this.allowDiagnostics, 0, 1, 1, 1, 1, 0, 17, 0);
        this.simplifiedUIPanel.add(this.allowChat, 0, 2, 1, 1, 1, 0, 17, 0);
        this.complexUIPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 5));
        uiPanel.add(this.useSimplifiedUIBox, 0, 0, 1, 1, 1, 0, 17, 3);
        uiPanel.add((Component)((Object)this.simplifiedUIPanel), 0, 1, 1, 1, 1, 0, 17, 1);
        uiPanel.add((Component)((Object)this.complexUIPanel), 0, 2, 1, 1, 1, 0, 17, 1);
        JWrapLabel label = new JWrapLabel("<html>" + Language.get("JUMP_GROUP_DESC"));
        JButton jumpToGroupNow = new JButton(Language.get("SHOW_TECHNICIAN_GROUP"), ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16"));
        jumpToGroupNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TechConsoleRestrictionsPanel.this.pconfig.getOrCreateGroupForAppProfile(profile);
                TechConsoleRestrictionsPanel.this.jumpToGroup();
            }
        });
        uiPanel.add((Component)label, 0, 3, 1, 1, 1, 0, 17, 1);
        uiPanel.add(jumpToGroupNow, 1, 3, 1, 1, 0, 0, 17, 0);
        this.rootComponent.add((Component)((Object)uiPanel), 0, N++, 2, 1, 1, 1, 17, 1);
        this.addCenter((JComponent)((Object)this.rootComponent));
    }

    private void jumpToGroup() {
        TechUi.INSTANCE.selectGroupInAdministrationTab(this.pconfig.getOrCreateGroupForAppProfile(this.profile));
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.rootComponent != null) {
            this.rootComponent.setBackground(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfile() {
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        System.out.println("[Group Perms] Tech Group is " + tg.getName() + " / " + tg.getAssociatedAppProfileID());
        this.allowFiles.setSelected(tg.getPermissions().canUseFileTransfer());
        this.allowDiagnostics.setSelected(tg.getPermissions().canUseDiagnostics());
        this.allowChat.setSelected(tg.getPermissions().canUseChat());
        this.loading = true;
        try {
            Properties launchProperties = this.profile.getLaunchProperties();
            if (launchProperties != null) {
                String value = launchProperties.getProperty(GroupAccessKeyset.ENABLED);
                if (Boolean.parseBoolean(value)) {
                    this.useSimplifiedUIBox.setSelectedIndex(0);
                } else {
                    this.useSimplifiedUIBox.setSelectedIndex(1);
                }
                this.updateVisiblePanels();
            }
        }
        finally {
            this.loading = false;
        }
    }

    public void loadFromProfile(AppProfile appProfile) {
        this.profile = appProfile;
        if (this.loadedConfig) {
            this.loadProfile();
        }
    }

    @Override
    public void profileAccountsReady() {
        this.loadedConfig = true;
        if (this.profile != null) {
            this.loadFromProfile(this.profile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.loading) {
            return;
        }
        if (this.profile == null) {
            return;
        }
        if (this.pconfig == null) {
            return;
        }
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        if (tg == null) {
            return;
        }
        this.updateVisiblePanels();
        Properties launchProperties = this.profile.getLaunchProperties();
        if (launchProperties == null) {
            launchProperties = new Properties();
        }
        if (this.useSimplifiedUIBox.getSelectedIndex() == 0) {
            launchProperties.setProperty(GroupAccessKeyset.ENABLED, "true");
        } else {
            launchProperties.setProperty(GroupAccessKeyset.ENABLED, "false");
        }
        this.profile.setLaunchProperties(launchProperties);
        tg.getPermissions().setCanUseFileTransfer(this.allowFiles.isSelected());
        tg.getPermissions().setCanUseDiagnostics(this.allowDiagnostics.isSelected());
        tg.getPermissions().setCanUseChat(this.allowChat.isSelected());
        try {
            this.client.saveAppProfiles(new AppProfile[]{this.profile});
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.pconfig.saveAsync();
    }

    private void updateVisiblePanels() {
        this.simplifiedUIPanel.setVisible(this.useSimplifiedUIBox.getSelectedIndex() == 0);
        this.complexUIPanel.setVisible(this.useSimplifiedUIBox.getSelectedIndex() == 1);
    }
}

