/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.ProfileType;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.AppProfileUIs;
import com.aem.shelp.tech.appprofile.MassDeployPanel;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import com.aem.shelp.tech.appprofile.UIConstants;
import com.aem.shelp.tech.appprofile.ui.AbstractProfileUI;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.components.JEditableLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class ProfileDetailsPanel
implements ActionListener,
ProfileUIListener {
    private CardPanel cards = new CardPanel();
    private NoContentsInfoPanel rootComponent = new NoContentsInfoPanel(null, null, false, true);
    private JScrollPane scroller = new JScrollPane();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private GbPanel header = new GbPanel();
    private JEditableLabel title = new JEditableLabel(false);
    private GbPanel footer = new GbPanel(new ScaledInsets(0, 3, 0, 3));
    private JButton deleteProfile = new JButton(Language.get("REMOVE_APP_PROFILE"));
    private AppProfile app;
    private JPanel contentPanel = new JPanel(new GridLayout(1, 1));
    private JButton massButton = new JButton(Language.get("APP_PROFILE_MASS_DEPLOY"));
    private JButton downloadButton = new JButton(Language.get("APP_PROFILE_DOWNLOAD"));
    private JButton linkButton = new JButton(Language.get("APP_PROFILE_GET_LINK"));
    private Component defaultCard;
    private String profilesUrl;
    private ProfileUIListener uiListener;
    private RootPaneContainer rpc;
    private TechClient client;
    private GlassDialog close;
    AbstractProfileUI currentlyShowingProfileUI;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public ProfileDetailsPanel(RootPaneContainer rpc, TechClient client, ProfileUIListener uiListener) {
        this.rpc = rpc;
        this.uiListener = uiListener;
        this.client = client;
        this.profilesUrl = SHJWUtil.getUpdateURLProtocol() + "://" + client.getHost() + ":" + client.getPort() + "/app/";
        this.initUI();
    }

    public void setCloseDialog(GlassDialog dialog) {
        this.close = dialog;
    }

    private void initUI() {
        this.scroller.setBorder(SHBorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)this.header, "North");
        this.header.setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.PANEL_BACKGROUND_DARKEST));
        this.header.setLayout((LayoutManager)new GridLayout(1, 1));
        this.header.add((Component)this.title, 0, 0, 1, 1, 1, 1, 10, 0);
        this.title.setRightIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/pencil.svg,16"));
        this.title.addListener(new JEditableLabel.EditListener(){

            @Override
            public void editableLabelStartEdit() {
            }

            @Override
            public void editableLabelValueSet(String newValue) {
                ProfileDetailsPanel.this.uiListener.renameProfile(ProfileDetailsPanel.this.app, newValue);
            }
        });
        SwingUtil.setHeight((JComponent)this.header, (int)UIConstants.getHeaderHeight());
        this.title.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.title.setFont(SHStyle.largeFont);
        this.title.setHorizontalAlignment(0);
        this.footer.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5)));
        this.footer.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        SHButtonUI.makeButtonRed((JButton)this.deleteProfile);
        this.footer.add((Component)this.deleteProfile, 0, 0, 1, 1, 1, 1, 17, 0);
        this.footer.add((Component)new JLabel(), 1, 0, 1, 1, 1000, 1, 10, 2);
        if (Switches.SH_massDeploy) {
            this.footer.add((Component)this.massButton, 2, 0, 1, 1, 1, 1, 13, 0);
        }
        this.footer.add((Component)this.downloadButton, 3, 0, 1, 1, 1, 1, 13, 0);
        this.footer.add((Component)this.linkButton, 4, 0, 1, 1, 1, 1, 13, 0);
        this.deleteProfile.addActionListener(this);
        this.downloadButton.addActionListener(this);
        this.linkButton.addActionListener(this);
        this.massButton.addActionListener(this);
        this.mainPanel.add((Component)this.contentPanel, "Center");
        this.scroller.setViewportView(this.mainPanel);
        BorderPanel master = new BorderPanel();
        master.addCenter((JComponent)this.scroller);
        master.addSouth((JComponent)this.footer);
        this.defaultCard = master;
        this.cards.add(this.defaultCard);
        this.rootComponent.setContentsPanel(this.cards);
    }

    private void showDefault() {
        this.cards.showCard(this.defaultCard);
    }

    public void showAppProfileTypeExplainer(ProfileType type) {
        this.setAppProfile(null);
        this.rootComponent.setNoContentsBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        this.rootComponent.setTitle(type.getName() + " " + Language.get("APP"));
        this.rootComponent.setIcon(ImageLoader.getImageIcon((String)(type.getIconKey() + ",48")));
        String[] text = new String[type.getExplainerKeys().length];
        for (int i = 0; i < text.length; ++i) {
            text[i] = Language.get(type.getExplainerKeys()[i]);
        }
        this.rootComponent.setSubText(text);
    }

    public void setAppProfile(AppProfile app) {
        this.showDefault();
        if (app == null) {
            this.rootComponent.setHasContents(false);
            this.currentlyShowingProfileUI = null;
        } else {
            if (this.currentlyShowingProfileUI == null || !this.currentlyShowingProfileUI.isForAppType(app.getType())) {
                this.contentPanel.removeAll();
                this.currentlyShowingProfileUI = AppProfileUIs.initProfileUIFor(app, this, this.rpc, this.client);
                this.contentPanel.add(this.currentlyShowingProfileUI.getRootComponent());
                this.contentPanel.revalidate();
                this.rootComponent.setHasContents(true);
            } else {
                this.currentlyShowingProfileUI.loadFromProfile(app);
            }
            this.app = app;
            this.title.setText(app.getName());
            this.mainPanel.repaint();
        }
        this.updateMassButton(app);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteProfile) {
            if (SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("APP_PROFILE_REMOVE_MESSAGE"), (String)Language.get("APP_PROFILE_REMOVE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("REMOVE_APP_PROFILE"))) {
                this.deleteProfile.setEnabled(false);
                new DeleteProfilerRunner(this.app);
            }
        } else if (e.getSource() == this.massButton) {
            MassDeployPanel mdp = new MassDeployPanel(this.client, this.app, true);
            mdp.addCloseListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileDetailsPanel.this.showDefault();
                }
            });
            this.cards.showTemporaryCard((Component)((Object)mdp));
        } else if (e.getSource() == this.downloadButton) {
            try {
                System.out.println("[ProfileDetailsPanel] Downloading " + this.profilesUrl + this.app.getID());
                Browser.openURL((URL)new URL(this.profilesUrl + this.app.getID()));
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        } else if (e.getSource() == this.linkButton) {
            try {
                ClipboardUtil.setClipboardAsText(this.profilesUrl + this.app.getID());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    @Override
    public void showAppsOfType(ProfileType type) {
        this.uiListener.showAppsOfType(type);
    }

    @Override
    public void showApp(AppProfile app) {
        this.uiListener.showApp(app);
    }

    @Override
    public void deleteProfile(AppProfile app) {
        this.uiListener.deleteProfile(app);
    }

    @Override
    public void newProfile(ProfileType selectedProfileType) {
        this.uiListener.newProfile(selectedProfileType);
    }

    @Override
    public void save(AppProfile appProfile) {
        this.updateMassButton(appProfile);
        this.uiListener.save(appProfile);
    }

    @Override
    public void renameProfile(AppProfile app, String newValue) {
        this.uiListener.renameProfile(app, newValue);
    }

    @Override
    public String[][] getVisibleMachineGroups() {
        return this.uiListener.getVisibleMachineGroups();
    }

    private void updateMassButton(AppProfile appProfile) {
        try {
            if (appProfile.getLaunchProperties().getProperty("sg_silent_install").equalsIgnoreCase("true")) {
                this.massButton.setEnabled(true);
            } else {
                this.massButton.setEnabled(false);
            }
        }
        catch (Exception x) {
            this.massButton.setEnabled(false);
        }
    }

    class DeleteProfilerRunner
    extends Thread {
        public DeleteProfilerRunner(AppProfile app) {
            super("DeleteProfileRunner - " + app.getName());
            this.start();
        }

        @Override
        public void run() {
            try {
                ProfileDetailsPanel.this.uiListener.deleteProfile(ProfileDetailsPanel.this.app);
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfileDetailsPanel.this.deleteProfile.setEnabled(true);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

