/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server.contents;

import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.MachineUIMetadata;
import com.aem.shelp.tech.alerts.events.server.contents.ServerEventsGroupPanel;
import com.aem.shelp.tech.alerts.events.server.contents.ServerEventsTableColumns;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class ServerEventsTableRenderer
extends DefaultTableCellRenderer
implements ServerEventsTableColumns.ServerEventsColumnPainter {
    private ServerEvent alert;
    private ServerEventsGroupPanel tableGroupPanel;

    public ServerEventsTableRenderer(ServerEventsGroupPanel tableGroupPanel) {
        this.tableGroupPanel = tableGroupPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            label.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            label.setForeground(UIManager.getColor("Table.foreground"));
        }
        this.alert = (ServerEvent)value;
        if (this.alert == null) {
            label.setText(" ");
            label.setIcon(null);
        } else {
            if (this.alert.getName() != null) {
                label.setText(" " + this.alert.getName().getName());
            } else {
                label.setText(" ");
            }
            Object uiMetadata = this.alert.getUIMetadata();
            if (uiMetadata != null) {
                label.setIcon(((MachineUIMetadata)uiMetadata).getIcon());
            } else {
                label.setIcon(null);
            }
        }
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (ServerEventsTableColumns.getColumnsWidth() == -1) {
            return dim;
        }
        dim.width = this.getWidth() - ServerEventsTableColumns.getColumnsWidth();
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = super.getWidth();
        int height = super.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(prefSize.width, height);
        super.paint(g);
        this.setSize(width, height);
        g.setColor(this.getBackground());
        g.fillRect(prefSize.width, 0, width - prefSize.width, height);
        g.setColor(this.getForeground());
        g.setFont(AccessStyle.MACHINE_TABLE_FONT);
        ServerEventsTableColumns.callPaintMethods(g, width, height, this);
        this.tableGroupPanel.getGroupsList().justPainted(this.alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(Graphics g, String text, int width, int height, int centerX, int columnWidth) {
        if (text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int baseTextLine = height / 2 + fm.getDescent() + 1;
        Shape currentClip = g.getClip();
        Rectangle bounds = currentClip.getBounds();
        try {
            int x = width + centerX - columnWidth / 2;
            int y = 0;
            int w = columnWidth;
            int h = height;
            int x2 = x + w;
            int y2 = y + h;
            int newx = Math.max(x, bounds.x);
            int newy = Math.max(y, bounds.y);
            int newx2 = Math.min(bounds.x + bounds.width, x2);
            int newy2 = Math.min(bounds.y + bounds.height, y2);
            g.setClip(new Rectangle(newx, newy, newx2 - newx, newy2 - newy));
            g.drawString(text, width + centerX - columnWidth / 2, baseTextLine);
        }
        finally {
            g.setClip(currentClip);
        }
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
    }

    @Override
    public void paintAlertName(Graphics g, int width, int height) {
    }

    @Override
    public void paintPreviousTriggerTime(Graphics g, int width, int height) {
    }

    @Override
    public void paintDuration(Graphics g, int width, int height) {
    }
}

