/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alertlocs.MachineFilterAloc;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AlertIcons;
import com.aem.shelp.tech.alerts.alerts.AlertDetailsPanel;
import com.aem.shelp.tech.alerts.alerts.details.AlertMachinePickerPanel;
import com.aem.shelp.tech.alerts.alerts.details.AlertTriggersPanel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggersListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.donothing.DoNothing;
import utils.loggingframework.ui.MultipleSelectTargetComponent;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.components.AlertGradientPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JEditableLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.FadeOnHoverPanel;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class AlertConfigPanel
extends GbPanel {
    private LocatedAlert alert;
    private AlertDetailsPanel detailsPanel;
    protected SLPanel containerSliding = new SLPanel();
    private SLConfig[] viewConfigs;
    private JComponent[] viewPanels;
    private GbPanel summaryPanel;
    private JEditableLabel title = new JEditableLabel(true);
    private JLabel alertIconLabel;
    private AlertTriggersPanel alertTriggersPanel;
    private GbPanel contentMachines = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private AlertMachinePickerPanel machinePickerPanel;
    private MultipleSelectTargetComponent triggerActions;
    private MultipleSelectTargetComponent resetActions;
    private ArrayList<SummaryLabel> labelsList = new ArrayList();
    private JComponent[] configureButtons;
    private MouseListener summaryLabelMouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == AlertConfigPanel.this.triggerSummary) {
                AlertConfigPanel.this.switchToConfigureTriggersAndResets();
            } else if (e.getSource() == AlertConfigPanel.this.resetSummary) {
                AlertConfigPanel.this.switchToConfigureTriggersAndResets();
            } else if (e.getSource() == AlertConfigPanel.this.machinesSummary) {
                AlertConfigPanel.this.switchToConfigureMachines();
            } else if (e.getSource() == AlertConfigPanel.this.triggerActionsSummary) {
                AlertConfigPanel.this.switchToConfigureTriggerActions();
            } else if (e.getSource() == AlertConfigPanel.this.resetActionsSummary) {
                AlertConfigPanel.this.switchToConfigureResetActions();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((Component)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((Component)e.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    };
    private JComponent[] summaryLabels;
    private JLabel triggersTitle;
    private JLabel resetsTitle;
    private JLabel machinesTitle;
    private JLabel triggerActionTitle;
    private JLabel resetActionTitle;
    private AlertGradientPanel titleGradientPanel;
    private SLConfig currentConfig;
    private JLabel triggerSummary;
    private JLabel resetSummary;
    private JLabel machinesSummary;
    private ActionsSummaryPanel triggerActionsSummary;
    private ActionsSummaryPanel resetActionsSummary;
    private JComponent triggerButton;
    private JComponent resetButton;
    private JComponent resetActionsButton;
    private JComponent triggerActionsButton;
    private JComponent machinesButton;
    private MachineTreeModel machineModel;

    protected void initSlidingConfigs() {
        JComponent[] panels = this.getViewPanels();
        this.viewConfigs = new SLConfig[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            this.viewConfigs[i] = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, panels[i]);
        }
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.viewConfigs[0]);
        this.currentConfig = this.viewConfigs[0];
    }

    private JComponent[] getViewPanels() {
        if (this.viewPanels != null) {
            return this.viewPanels;
        }
        this.initSummaryPanel();
        this.initMachinesPanel();
        this.initTriggerActionsPanel();
        this.initResetActionsPanel();
        this.alertTriggersPanel = new AlertTriggersPanel(this.detailsPanel);
        JScrollPane summaryScoller = new JScrollPane((Component)this.summaryPanel);
        summaryScoller.setHorizontalScrollBarPolicy(31);
        summaryScoller.setBorder(SHBorderFactory.createEmptyBorder());
        this.viewPanels = new JComponent[]{summaryScoller, new BackContentPanel(this.alertTriggersPanel.getRootComponent(), Language.get("ALERT_TRIGGERS_TITLE"), Language.get("ALERT_TRIGGERS_DESC")), new BackContentPanel((JComponent)this.contentMachines, Language.get("ALERT_MACHINES_TITLE"), Language.get("MACHINE_PICKER_DESCRIPTION_ALERTS")), new BackContentPanel((JComponent)this.triggerActions.getRootComponent(), Language.get("ALERT_TRIGGER_ACTIONS_TITLE"), Language.get("ALERT_TRIGGER_ACTIONS_DESC")), new BackContentPanel((JComponent)this.resetActions.getRootComponent(), Language.get("ALERT_RESET_ACTIONS_TITLE"), Language.get("ALERT_RESET_ACTIONS_DESC"), true)};
        return this.viewPanels;
    }

    private void switchToNext(JComponent currentContentPanel) {
        if (currentContentPanel == this.alertTriggersPanel.getRootComponent()) {
            this.switchToConfigureMachines();
        } else if (currentContentPanel == this.contentMachines) {
            this.switchToConfigureTriggerActions();
        } else if (currentContentPanel == this.triggerActions.getRootComponent()) {
            this.switchToConfigureResetActions();
        } else if (currentContentPanel == this.resetActions.getRootComponent()) {
            this.switchToSummary();
        }
    }

    private void initTriggerActionsPanel() {
        this.triggerActions = new MultipleSelectTargetComponent(Language.DEFLANG, this.detailsPanel, (SwingStyleInterface)SHStyle.INSTANCE, true, null);
    }

    private void initResetActionsPanel() {
        this.resetActions = new MultipleSelectTargetComponent(Language.DEFLANG, this.detailsPanel, (SwingStyleInterface)SHStyle.INSTANCE, true, null);
    }

    private void initMachinesPanel() {
        this.contentMachines = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.machinePickerPanel = new AlertMachinePickerPanel(this.detailsPanel, this.machineModel);
        this.contentMachines.add((Component)this.machinePickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private JComponent setPanelBorder(JComponent comp) {
        comp.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)Color.LIGHT_GRAY), (Border)SHBorderFactory.createEmptyBorder((int)4, (int)5, (int)5, (int)5)));
        return comp;
    }

    private void setPanelLight(JComponent comp) {
        comp.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
    }

    private JLabel createTitleLabel(JLabel jl, boolean smaller) {
        if (smaller) {
            jl.setFont(SHStyle.normalFont);
            jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        } else {
            jl.setFont(SHStyle.mediumFont);
            jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
        }
        jl.setHorizontalAlignment(0);
        return jl;
    }

    private JLabel summaryLabel(String text, String icon) {
        SummaryLabel jl = new SummaryLabel();
        jl.setText(Language.get(text));
        jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        jl.setIcon(ImageLoader.getImageIcon((String)icon));
        this.labelsList.add(jl);
        return jl;
    }

    private JLabel summaryLabel(String text, String icon, String overlay) {
        SummaryLabel jl = new SummaryLabel();
        jl.setText(Language.get(text));
        jl.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        jl.setIcon(ImageLoader.getImageIcon((String)Icons.overlay(icon, overlay)));
        this.labelsList.add(jl);
        return jl;
    }

    public void reloadChanges(ArrayList<String> triggeredMachines) {
        if (triggeredMachines != null && triggeredMachines.size() > 0) {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/grey.svg,24"));
            this.titleGradientPanel.setWarningBackground(SHStyle.WARNING_GRADIENT_COLOR);
            if (OEMSwitches.DARK_THEME) {
                this.title.setForeground(Color.BLACK);
            }
        } else {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/blue-down.svg,24"));
            this.titleGradientPanel.setWarningBackground(null);
            if (OEMSwitches.DARK_THEME) {
                this.title.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
        this.repaint();
    }

    private void initSummaryPanel() {
        this.triggerSummary = new TruncatingLabel();
        this.resetSummary = new TruncatingLabel();
        this.machinesSummary = new TruncatingLabel();
        this.triggerActionsSummary = new ActionsSummaryPanel();
        this.resetActionsSummary = new ActionsSummaryPanel();
        this.labelsList = new ArrayList();
        this.titleGradientPanel = new AlertGradientPanel();
        GbPanel condp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        GbPanel machp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        GbPanel actp = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        this.titleGradientPanel.setOpaque(false);
        this.title.setOpaque(false);
        this.setPanelBorder((JComponent)condp);
        this.setPanelBorder((JComponent)machp);
        this.setPanelBorder((JComponent)actp);
        this.setPanelLight((JComponent)condp);
        this.setPanelLight((JComponent)actp);
        this.setPanelLight((JComponent)((Object)this.triggerActionsSummary));
        this.setPanelLight((JComponent)((Object)this.resetActionsSummary));
        this.triggerButton = new JButton(Language.get("ACP_SET_TRIGGER"));
        this.machinesButton = new JButton(Language.get("ACP_PICK_MACHINES"));
        this.triggerActionsButton = new JButton(Language.get("ACP_CREATE_TRIGGER_ACTIONS"));
        this.resetActionsButton = new JButton(Language.get("ACP_CREATE_RESET_ACTIONS"));
        for (JComponent button : this.configureButtons = new JComponent[]{this.triggerButton, this.machinesButton, this.triggerActionsButton, this.resetActionsButton}) {
            button.setBorder(SHBorderFactory.createEmptyBorder((int)4, (int)4, (int)4, (int)4));
            SwingUtil.setHeight((JComponent)button, (int)SimpleHelpLookAndFeel.scale((int)20));
            button.setFont(SHStyle.smallerFont);
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.simulateExit(e.getSource());
                    if (e.getSource() == AlertConfigPanel.this.triggerButton) {
                        AlertConfigPanel.this.switchToConfigureTriggersAndResets();
                    } else if (e.getSource() == AlertConfigPanel.this.resetButton) {
                        AlertConfigPanel.this.switchToConfigureTriggersAndResets();
                    } else if (e.getSource() == AlertConfigPanel.this.machinesButton) {
                        AlertConfigPanel.this.switchToConfigureMachines();
                    } else if (e.getSource() == AlertConfigPanel.this.triggerActionsButton) {
                        AlertConfigPanel.this.switchToConfigureTriggerActions();
                    } else if (e.getSource() == AlertConfigPanel.this.resetActionsButton) {
                        AlertConfigPanel.this.switchToConfigureResetActions();
                    }
                }

                private void simulateExit(Object source) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.triggerButton, this.machinesButton, this.triggerActionsButton, this.resetActionsButton});
        this.summaryLabels = new JComponent[]{this.triggerSummary, this.resetSummary, this.machinesSummary, this.triggerActionsSummary, this.resetActionsSummary};
        this.title.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)3, (int)3));
        this.alertIconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/alert-flags/blue-down.svg,24"));
        this.titleGradientPanel.add(this.alertIconLabel, 0, 0, 1, 1, 0, 0, 11, 2, (Insets)new ScaledInsets(4, 5, 0, 2));
        this.titleGradientPanel.add(this.title, 1, 0, 3, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.triggersTitle = this.summaryLabel("ALERTS_TRIGGER_CONDITIONS", Icons.ALERT_STATUS_TAB_BAD);
        this.resetsTitle = this.summaryLabel("ALERTS_RESET_CONDITIONS", Icons.ALERT_STATUS_TAB_BLUE);
        this.machinesTitle = this.summaryLabel("ALERTS_MACHINES_CONDITIONS", "images/svg/technology/screen.svg,16");
        this.triggerActionTitle = this.summaryLabel("ALERTS_TRIGGER_ACTIONS", "images/svg/users/runner.svg,16", Icons.ALERT_STATUS_TAB_BAD_TINY);
        this.resetActionTitle = this.summaryLabel("ALERTS_RESET_ACTIONS", "images/svg/users/runner.svg,16", Icons.ALERT_STATUS_TAB_BLUE_TINY);
        Border labelBorder = SHBorderFactory.createEmptyBorder((int)4, (int)0, (int)4, (int)0);
        for (JComponent label : this.summaryLabels) {
            label.setBorder(labelBorder);
            label.addMouseListener(this.summaryLabelMouseListener);
        }
        this.triggerActionTitle.setBorder(labelBorder);
        this.resetActionTitle.setBorder(labelBorder);
        int Y = 0;
        FadeOnHoverPanel fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_CONDITIONS_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_CONDITIONS_DESC")), true));
        fadep.setOpaque(false);
        condp.add((Component)((Object)fadep), 0, Y++, 3, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(7, 2, 10, 2));
        condp.add((Component)this.triggerButton, 2, Y, 1, 2, 0, 1, 13, 0);
        condp.add((Component)this.triggersTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        condp.add((Component)this.summaryLabels[0], 1, Y++, 1, 1, 1, 1, 17, 2);
        condp.add((Component)this.resetsTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        condp.add((Component)this.summaryLabels[1], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_MACHINES_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_MACHINES_DESC")), true));
        fadep.setOpaque(false);
        machp.add((Component)((Object)fadep), 0, Y++, 3, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(7, 2, 10, 2));
        machp.add((Component)this.machinesButton, 2, Y, 1, 1, 0, 1, 13, 0);
        machp.add((Component)this.machinesTitle, 0, Y, 1, 1, 0, 0, 17, 2);
        machp.add((Component)this.summaryLabels[2], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        fadep = new FadeOnHoverPanel();
        fadep.addBoth(this.createTitleLabel(new JLabel(Language.get("ALERT_ACTIONS_TITLE")), false), this.createTitleLabel(new JLabel(Language.get("ALERT_ACTIONS_DESC")), true));
        fadep.setOpaque(false);
        actp.add((Component)((Object)fadep), 0, Y++, 3, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(7, 2, 10, 2));
        actp.add((Component)this.triggerActionsButton, 2, Y, 1, 1, 0, 1, 12, 0);
        actp.add((Component)this.triggerActionTitle, 0, Y, 1, 1, 0, 0, 18, 2);
        actp.add((Component)this.summaryLabels[3], 1, Y++, 1, 1, 1, 1, 17, 2);
        actp.add((Component)this.resetActionsButton, 2, Y, 1, 1, 0, 1, 12, 0);
        actp.add((Component)this.resetActionTitle, 0, Y, 1, 1, 0, 0, 18, 2);
        actp.add((Component)this.summaryLabels[4], 1, Y++, 1, 1, 1, 1, 17, 2);
        Y = 0;
        this.summaryPanel = new GbPanel();
        this.summaryPanel.add((Component)((Object)this.titleGradientPanel), 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add((Component)condp, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add((Component)machp, 0, Y++, 1, 1, 1, 1, 11, 2);
        this.summaryPanel.add((Component)actp, 0, Y++, 1, 1, 0, 1, 11, 2);
        this.summaryPanel.add((Component)this.setPanelBorder(new JPanel()), 0, Y++, 1, 1, 0, 1000, 10, 1);
    }

    private int getSLConfigIndex(SLConfig config) {
        for (int i = 0; i < this.viewConfigs.length; ++i) {
            if (this.viewConfigs[i] != config) continue;
            return i;
        }
        return -1;
    }

    private void switchToNewView(SLConfig newConfig, Component myComponent) {
        if (this.currentConfig != newConfig) {
            SLSide mySide = this.getSLConfigIndex(newConfig) > this.getSLConfigIndex(this.currentConfig) ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(newConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.currentConfig = newConfig;
        }
    }

    public void setTechClient(TechClient client) {
        this.alertTriggersPanel.setTechClient(client);
        boolean canManage = client.getPermissions().canManageAlerts();
        for (JComponent label : this.configureButtons) {
            label.setVisible(canManage);
        }
        this.title.setIsEditable(canManage);
        if (canManage) {
            for (JComponent label : this.summaryLabels) {
                label.addMouseListener(this.summaryLabelMouseListener);
            }
        } else {
            for (JComponent label : this.summaryLabels) {
                label.removeMouseListener(this.summaryLabelMouseListener);
            }
        }
    }

    public void setMachineTreeModel(MachineTreeModel machines) {
        this.alertTriggersPanel.setMachineTreeModel(machines);
    }

    public AlertConfigPanel(AlertDetailsPanel detailsPanel, MachineTreeModel machineModel) {
        super(new ScaledInsets(0, 0, 0, 0));
        this.machineModel = machineModel;
        this.detailsPanel = detailsPanel;
        this.initUI();
        if (detailsPanel != null) {
            this.title.addListener(detailsPanel);
        }
        this.title.setFont(SHStyle.largeFont);
    }

    private void initUI() {
        this.initSlidingConfigs();
        int Y = 0;
        this.add(this.containerSliding, 0, Y++, 4, 1, 1, 1, 10, 1);
    }

    protected void switchToConfigureResetActions() {
        this.detailsPanel.setAllowSaving(false);
        this.switchToNewView(this.viewConfigs[4], this.viewPanels[4]);
    }

    protected void switchToConfigureTriggerActions() {
        this.detailsPanel.setAllowSaving(false);
        this.switchToNewView(this.viewConfigs[3], this.viewPanels[3]);
    }

    protected void switchToConfigureMachines() {
        this.detailsPanel.setAllowSaving(false);
        this.switchToNewView(this.viewConfigs[2], this.viewPanels[2]);
    }

    protected void switchToConfigureTriggersAndResets() {
        this.detailsPanel.setAllowSaving(false);
        this.switchToNewView(this.viewConfigs[1], this.viewPanels[1]);
    }

    protected void switchToSummary() {
        this.detailsPanel.setAllowSaving(true);
        this.switchToNewView(this.viewConfigs[0], this.viewPanels[0]);
    }

    public BasicAlert getConfiguredAlert() {
        BasicAlert ba = (BasicAlert)this.alert.getAlert();
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Pre conf alert: " + ba);
        }
        this.alertTriggersPanel.saveConfigurationTo(ba);
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Post conf alert: " + ba);
        }
        return ba;
    }

    public void saveConfiguredAlert() {
        AlertLocation aloc;
        this.alert.setAlert(this.getConfiguredAlert());
        LocatedAlert locatedAlert = this.alert;
        CombinedMachineFilter filter = this.machinePickerPanel.getMachineFilter();
        if (filter.showAllMachines()) {
            aloc = new AllMachinesAloc();
        } else {
            aloc = new MachineFilterAloc();
            if (filter.useSimpleFilter()) {
                ((MachineFilterAloc)aloc).setFilters(null, filter.getSimpleMachineFilter());
            } else {
                Filter[] filters = this.machinePickerPanel.getMachineFilter().getAdvancedFilters();
                MachineFilter[] mf = null;
                if (filters != null) {
                    mf = new MachineFilter[filters.length];
                    for (int i = 0; i < filters.length; ++i) {
                        mf[i] = (MachineFilter)filters[i];
                    }
                }
                ((MachineFilterAloc)aloc).setFilters(mf, null);
            }
        }
        locatedAlert.setLocation(aloc, null);
        locatedAlert.setTriggerTargets(this.triggerActions.getTargets().toArray(new AbstractTarget[0]));
        locatedAlert.setResetTargets(this.resetActions.getTargets().toArray(new AbstractTarget[0]));
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Saved alert: " + this.alert.getAlert());
        }
    }

    private ArrayList<TriggersListPanel.TriggerGroup> buildGroups(ArrayList<ArrayList<Alert>> all) {
        ArrayList<TriggersListPanel.TriggerGroup> groups = new ArrayList<TriggersListPanel.TriggerGroup>();
        ArrayList<ArrayList<Alert>> alerts = all;
        for (ArrayList<Alert> list : alerts) {
            TriggersListPanel.TriggerGroup tg = new TriggersListPanel.TriggerGroup();
            tg.triggers = new ArrayList();
            tg.triggers.addAll(list);
            groups.add(tg);
        }
        return groups;
    }

    public void initInfoPanelWith(LocatedAlert alert, ArrayList<String> triggeredMachines) {
        this.alert = alert;
        if (CentralDebugging.ALERT_ROUND_TRIPPING) {
            System.out.println("Loading alert: " + alert.getAlert());
        }
        if (triggeredMachines != null && triggeredMachines.size() > 0) {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/grey.svg,24"));
            this.titleGradientPanel.setWarningBackground(SHStyle.WARNING_GRADIENT_COLOR);
        } else {
            this.alertIconLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/blue-down.svg,24"));
            this.titleGradientPanel.setWarningBackground(null);
        }
        this.alertIconLabel.repaint();
        this.title.setText("<html>" + alert.getName().getName());
        BasicAlert ba = (BasicAlert)alert.getAlert();
        this.updateSummaries(ba);
        this.alertTriggersPanel.initInfoPanelWith(alert, triggeredMachines);
        this.triggerActions.setLogEventsToTarget(new LogEvent[]{new LocatedAlertLogEvent(null, null, true, null)});
        this.resetActions.setLogEventsToTarget(new LogEvent[]{new LocatedAlertLogEvent(null, null, true, null)});
        this.triggerActions.setTargets(new ArrayList<AbstractTarget>(Arrays.asList(alert.getTriggerTargets())));
        this.resetActions.setTargets(new ArrayList<AbstractTarget>(Arrays.asList(alert.getResetTargets())));
        AlertLocation aloc = alert.getLocation();
        CombinedMachineFilter filter = new CombinedMachineFilter();
        if (aloc instanceof AllMachinesAloc) {
            filter.setType(0);
        } else if (aloc instanceof MachineFilterAloc) {
            MachineFilterAloc mfilt = (MachineFilterAloc)aloc;
            Filter[] filtersAdvanced = mfilt.getFiltersAdvanced();
            if (filtersAdvanced != null) {
                filter.setType(2);
                filter.setAdvancedFilters(filtersAdvanced);
            } else {
                filter.setType(1);
                filter.setSimpleMachineFilter(mfilt.getFilterSimple());
            }
        } else {
            filter.setType(0);
        }
        this.machinePickerPanel.load(filter);
        this.repaint();
    }

    private void updateSummaries(BasicAlert ba) {
        if (ba.getTriggers().size() > 0) {
            this.triggerSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.triggerSummary.setText("<html><nobr>" + ba.getTriggersAsString(true));
            this.triggerSummary.setForeground(UIManager.getColor("textText"));
        } else {
            this.triggerSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.triggerSummary.setText(Language.get("ALERTS_NO_TRIGGER_SUMMARY"));
            this.triggerSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        }
        if (ba.getTriggers().size() > 0) {
            this.resetSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.resetSummary.setText("<html><nobr>" + ba.getResetsAsString(true));
            this.resetSummary.setForeground(UIManager.getColor("textText"));
        } else {
            this.resetSummary.setIcon(AlertIcons.getIcon(ba, 16));
            this.resetSummary.setText(Language.get("ALERTS_NO_RESET_SUMMARY"));
            this.resetSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        }
        this.machinesSummary.setText(this.alert.getLocation().getMachineSummary());
        this.triggerActionsSummary.setTexts(this.getActionSummary(this.alert.getTriggerTargets()));
        this.resetActionsSummary.setTexts(this.getActionSummary(this.alert.getResetTargets()));
    }

    private String[] getActionSummary(AbstractTarget[] resetTargets) {
        if (resetTargets == null) {
            return new String[0];
        }
        ArrayList<String> summaries = new ArrayList<String>();
        for (AbstractTarget t : resetTargets) {
            if (t instanceof DoNothing) continue;
            summaries.add(t.getTargetSummary());
        }
        return summaries.toArray(new String[0]);
    }

    class ActionsSummaryPanel
    extends ColorPropagatingPanel {
        private Border border;

        public ActionsSummaryPanel() {
            this.setLayout(new GridLayout(-1, 1));
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = Math.max(d.height, SimpleHelpLookAndFeel.scale((int)16));
            return d;
        }

        public void setTexts(String ... texts) {
            if (texts == null || texts.length == 0) {
                texts = new String[]{Language.get("NO_ACTIONS")};
                this.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
            } else {
                this.setForeground(UIManager.getColor("textText"));
            }
            this.setSize(texts.length);
            for (int i = 0; i < texts.length; ++i) {
                ((TruncatingLabel)this.getComponent(i)).setText(texts[i]);
            }
            this.revalidate();
            this.repaint();
        }

        public void setForeground(Color col) {
            super.setForeground(col);
            for (Component c : this.getComponents()) {
                c.setForeground(col);
            }
        }

        public void setBorder(Border border) {
            this.border = border;
            for (Component c : this.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                ((JComponent)c).setBorder(border);
            }
        }

        public void setSize(int count) {
            if (this.getComponentCount() == count) {
                return;
            }
            if (this.getComponentCount() < count) {
                while (this.getComponentCount() < count) {
                    TruncatingLabel truncatingLabel = new TruncatingLabel();
                    truncatingLabel.setBorder(this.border);
                    truncatingLabel.setForeground(this.getForeground());
                    this.add(truncatingLabel);
                }
            } else {
                while (this.getComponentCount() > count) {
                    this.remove(this.getComponentCount() - 1);
                }
            }
        }
    }

    public static class TruncatingLabel
    extends JLabel {
        public TruncatingLabel(String text, int alignment) {
            super(text, alignment);
        }

        public TruncatingLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 1;
            return d;
        }
    }

    class SummaryLabel
    extends JLabel {
        SummaryLabel() {
        }

        public Dimension getInternalSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            for (SummaryLabel jl : AlertConfigPanel.this.labelsList) {
                Dimension tmp = jl.getInternalSize();
                tmp.width += 10;
                if (tmp.width <= d.width) continue;
                d.width = tmp.width;
            }
            return d;
        }
    }

    class BackContentPanel
    extends JPanel
    implements ActionListener {
        private JComponent content;
        private JButton backButton;
        private JButton nextButton;
        private String description;
        private String title;
        private boolean isLast;

        public BackContentPanel(JComponent content, String title, String description) {
            this(content, title, description, false);
        }

        public BackContentPanel(JComponent content, String title, String description, boolean isLast) {
            super(new BorderLayout());
            this.isLast = isLast;
            this.description = description;
            this.content = content;
            this.title = title;
            this.initUI();
        }

        private void initUI() {
            this.nextButton = this.isLast ? new JButton(Language.get("DONE")) : new JButton(Language.get("NEXT"));
            this.backButton = new JButton(Language.get("ADMIN_SERVER_OVERVIEW"));
            this.nextButton.setFont(SHStyle.smallerFont);
            this.backButton.setFont(SHStyle.smallerFont);
            JLabel titleLabel = new JLabel(this.title);
            titleLabel.setFont(SHStyle.largeFont);
            GbPanel topPanel = new GbPanel();
            topPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            topPanel.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)5)));
            GbPanel titlePanel = new GbPanel();
            titlePanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            titlePanel.add((Component)titleLabel, 1, 0, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(10, 3, 3, 3));
            if (this.description != null) {
                JLabel descriptionLabel = new JLabel(this.description);
                descriptionLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                titlePanel.add((Component)descriptionLabel, 1, 1, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(1, 3, 5, 3));
            }
            topPanel.add((Component)this.backButton, 0, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(1, 3, 0, 3));
            topPanel.add((Component)titlePanel, 1, 0, 1, 1, 1, 0, 17, 3, (Insets)new ScaledInsets(0, 3, 0, 3));
            topPanel.add((Component)this.nextButton, 2, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(1, 3, 0, 3));
            this.add((Component)topPanel, "North");
            this.add((Component)this.content, "Center");
            this.backButton.addActionListener(this);
            this.nextButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicAlert ba = (BasicAlert)AlertConfigPanel.this.alert.getAlert();
            AlertConfigPanel.this.updateSummaries(ba);
            AlertConfigPanel.this.summaryPanel.repaint();
            if (e.getSource() == this.backButton) {
                AlertConfigPanel.this.switchToSummary();
            } else {
                AlertConfigPanel.this.switchToNext(this.content);
            }
        }
    }
}

