/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jdatepicker.DateModel;
import org.jdatepicker.JDatePicker;
import org.jdatepicker.constraints.DateSelectionConstraint;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.contents.FixedWidthGbPanel;
import utils.swing.images.ImageLoader;

public class TimeoutDialogPanel
extends FixedWidthGbPanel
implements ActionListener {
    private JCheckBox timeoutBox;
    private JDatePicker datePicker;

    public TimeoutDialogPanel(TechUser user) {
        super(new ScaledInsets(5, 5, 5, 5));
        this.initUI(user);
    }

    private void initUI(TechUser user) {
        this.timeoutBox = new JCheckBox(Language.get("TECH_TIMEOUT_BOX"));
        this.timeoutBox.addActionListener(this);
        long currentTime = user.getEnabledUntilTime();
        this.timeoutBox.setSelected(currentTime > 0L);
        Date date = currentTime <= 0L ? new Date() : new Date(currentTime);
        this.datePicker = new JDatePicker((ResourceBundle)Language.DEFLANG, ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), ImageLoader.getImageIcon((String)"images/svg/general/calendar.svg,16"), date);
        this.datePicker.setTextEditable(true);
        this.datePicker.setShowYearButtons(true);
        this.datePicker.addDateSelectionConstraint(new DateSelectionConstraint(){

            @Override
            public boolean isValidSelection(DateModel<?> model) {
                Calendar c = Calendar.getInstance();
                int y = c.get(1);
                int m = c.get(2);
                int d = c.get(5);
                if (model.getYear() < y) {
                    return false;
                }
                if (model.getYear() > y) {
                    return true;
                }
                if (model.getMonth() < m) {
                    return false;
                }
                if (model.getMonth() > m) {
                    return true;
                }
                return model.getDay() > d;
            }
        });
        JLabel expiryLabel = new JLabel(Language.get("TECH_TIMEOUT_EXPIRY"));
        this.add(this.timeoutBox, 0, 0, 2, 1, 1, 1, 17, 2);
        this.add(expiryLabel, 0, 1, 1, 1, 0, 1, 17, 2);
        this.add(this.datePicker, 1, 1, 1, 1, 1, 1, 17, 2);
        this.updateEnabled();
    }

    public boolean timeoutAccount() {
        return this.timeoutBox.isSelected();
    }

    public long getTimeoutAccountTime() {
        if (this.timeoutAccount()) {
            DateModel<?> model = this.datePicker.getModel();
            Date date = (Date)model.getValue();
            if (date == null) {
                return 0L;
            }
            return date.getTime();
        }
        return 0L;
    }

    private void updateEnabled() {
        this.datePicker.setEnabled(this.timeoutBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timeoutBox) {
            this.updateEnabled();
        }
    }
}

