/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.ServerManagement;
import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyHashPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.GroupMembership;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.technicians.GroupTable;
import com.aem.shelp.tech.admin.subsections.technicians.TechTable;
import com.aem.shelp.tech.admin.subsections.technicians.TimeoutDialogPanel;
import com.aem.shelp.tech.utils.filters.CombinedCustomerFiltersUI;
import com.aem.shelp.tech.utils.filters.CombinedMachineFiltersUI;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import com.aem.shelp.util.swing.EmptyBorderedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.string.HexData;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.avatar.AvatarPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminTechnicians
extends SubSection
implements ListSelectionListener,
ActionListener,
ValidationKeyListener.ValidationInterface {
    private final Random r = new Random(System.currentTimeMillis());
    public static AdminTechnicians INSTANCE;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JTabbedPane techTabs;
    private SaveSettingsListener saveSettingsListener;
    private AvatarPanel.AvatarChangeListener avatarChangeListener;
    private TechTable techTable;
    private final Object AVATAR_LOCK = new Object();
    private AvatarFetchThread avatarFetchThread = null;
    private NoContentsInfoPanel techInfoPanel;
    private AvatarPanel avatarPanel;
    private GroupTable groupsTable;
    private JTextField technicianNameField;
    private JTextField loginNameField;
    private JTextField emailField;
    private JLabel technicianNameLabel;
    private JLabel emailLabel;
    private JLabel loginNameLabel;
    private JButton setPasswordButton;
    private JButton resetAppAuthentication;
    private JButton deleteButton;
    private JButton deleteMultipleButton;
    private JButton setTimeoutButton;
    private TechUser selectedTech;
    private JCheckBox allowLocallyAuthenticatedLoginsBox;
    private JCheckBox accountIsEnabled;
    private CombinedCustomerFiltersUI customerFilters;
    private CombinedMachineFiltersUI machineFiltersUI;
    private boolean forceSave = false;
    private MachineTreeModel model;
    private JLabel summaryLabel;
    private TechGroup[] allGroups;
    private JLabel timeoutSummary;

    public AdminTechnicians() {
        INSTANCE = this;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
        this.machineFiltersUI.setMachineTreeModel(model);
    }

    @Override
    public boolean forceSave() {
        if (this.forceSave) {
            this.forceSave = false;
            return true;
        }
        return false;
    }

    @Override
    public void overrideBorderForSubSection() {
        this.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder());
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    public void updateTechnicianGroupMembership(GroupMembership member) {
        if (this.selectedTech != null) {
            if (member.isMember() && !this.selectedTech.isInGroup(member.getGroup())) {
                this.selectedTech.addGroup(member.getGroup());
            } else if (!member.isMember() && this.selectedTech.isInGroup(member.getGroup())) {
                this.selectedTech.removeGroup(member.getGroup());
            }
            if (member.isAdmin() && !this.selectedTech.canAdministerGroup(member.getGroup())) {
                this.selectedTech.addGroupToAdminister(member.getGroup());
            } else if (!member.isAdmin() && this.selectedTech.canAdministerGroup(member.getGroup())) {
                this.selectedTech.removeGroupToAdminister(member.getGroup());
            }
            this.contentChanged(this.checkIfValid());
            this.forceSave = true;
            this.saveListener.techChanged();
            this.techTable.getRootComponent().repaint();
        }
    }

    public void loadTechnicians(TechUser[] usersToAdminister, TechGroup[] newGroups) {
        ArrayList allUsers = new ArrayList();
        Collections.addAll(allUsers, usersToAdminister);
        Collections.sort(allUsers);
        this.techTable.setTechnicians(allUsers.toArray(new TechUser[0]));
        this.setGroups(newGroups);
    }

    public void forceAtLeastOneGroupSelected() {
        this.groupsTable.forceAtLeastOneGroupSelected();
    }

    @Override
    protected ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.selectedTech != null) {
            if (this.technicianNameField.getText().length() == 0) {
                list.add(this.technicianNameField);
            } else {
                this.technicianNameField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.loginNameField.getText().length() == 0) {
                list.add(this.loginNameField);
            } else {
                this.loginNameField.setBorder(this.defaultTextFieldBorder);
            }
        } else {
            this.technicianNameField.setBorder(this.defaultTextFieldBorder);
            this.loginNameField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    @Override
    public void checkEnabled() {
        this.setPasswordButton.setVisible(this.selectedTech != null && !this.selectedTech.isAnonymous());
        this.groupsTable.setEnabled(this.selectedTech != null && !this.selectedTech.isAnonymous());
        this.technicianNameField.setEnabled(this.selectedTech != null);
        this.loginNameField.setEnabled(this.selectedTech != null && !this.selectedTech.isAnonymous());
        this.setPasswordButton.setEnabled(this.selectedTech != null && this.selectedTech.allowLocallyAuthenticatedLogins());
        this.avatarPanel.setEnabled(this.selectedTech != null);
        this.resetAppAuthentication.setVisible(this.selectedTech != null && this.selectedTech.inGroupWithTOTPAuthentication());
        this.resetAppAuthentication.setEnabled(this.selectedTech != null && this.selectedTech.getTOTPKey() != null && !this.selectedTech.getTOTPKey().isNull());
        this.customerFilters.setEnabled(this.selectedTech != null);
        this.machineFiltersUI.setEnabled(this.selectedTech != null);
        this.emailField.setEnabled(this.selectedTech != null);
        this.allowLocallyAuthenticatedLoginsBox.setEnabled(this.selectedTech != null);
        this.accountIsEnabled.setEnabled(this.selectedTech != null);
    }

    private void initTechsTab(JPanel techsPanel) {
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)techsPanel);
        EmptyBorderedPanel techDetails = new EmptyBorderedPanel();
        techDetails.setLayout(new GridLayout(1, 1));
        this.techTabs = new JTabbedPane();
        techDetails.add(this.techTabs);
        EmptyBorderedPanel technicianInfo = new EmptyBorderedPanel();
        this.initTechInfo(technicianInfo);
        EmptyBorderedPanel customerFiltering = new EmptyBorderedPanel();
        this.initCustFilters(customerFiltering);
        EmptyBorderedPanel machineFiltering = new EmptyBorderedPanel();
        this.initMachFilters(machineFiltering);
        EmptyBorderedPanel groups = new EmptyBorderedPanel();
        this.initTechGroups(groups);
        this.techTabs.addTab(Language.get("ADMIN_TECH_INFO_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/preferences.svg,16"), technicianInfo);
        this.techTabs.addTab(Language.get("ADMIN_TECH_GROUPS"), ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16"), groups);
        if (ServerManagement.isServerSuite() || ServerManagement.isSimpleHelp()) {
            this.techTabs.addTab(Language.get("ADMIN_CUST_FILTERING_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/funnel-abstract-blue.svg,16"), customerFiltering);
        }
        if (ServerManagement.isServerSuite() || ServerManagement.isSimpleGateway()) {
            this.techTabs.addTab(Language.get("ADMIN_MACH_FILTERING_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/funnel-abstract-blue.svg,16"), machineFiltering);
        }
        EmptyBorderedPanel multipleSelect = new EmptyBorderedPanel();
        this.summaryLabel = new JLabel();
        this.summaryLabel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)5, (int)0));
        this.summaryLabel.setFont(SHStyle.largeFont);
        this.deleteMultipleButton = new JButton(Language.get("DELETE_TECHNICIANS"));
        SHButtonUI.makeButtonRed((JButton)this.deleteMultipleButton);
        GbPanel panel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
        panel.add((Component)this.summaryLabel, 0, 0, 1, 1, 1, 0, 17, 2);
        panel.add((Component)this.deleteMultipleButton, 0, 1, 1, 1, 1, 0, 17, 0);
        multipleSelect.setLayout(new BorderLayout());
        multipleSelect.add((Component)panel, "North");
        this.deleteMultipleButton.addActionListener(this);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add("SINGLE", techDetails);
        this.cardPanel.add("MULTIPLE", multipleSelect);
        this.cardLayout.show(this.cardPanel, "SINGLE");
        this.techInfoPanel = new NoContentsInfoPanel(Language.get("ADMIN_PANEL_SELECT_TECH"), ImageLoader.getImageIconDisabled((String)"images/svg/users/group.svg,48"), false);
        this.techInfoPanel.setContentsPanel(this.cardPanel);
        SHSplitPane leftSplit = new SHSplitPane(0);
        leftSplit.setDividerLocation(0.5);
        leftSplit.setLeftComponent(this.techTable.getRootComponent());
        leftSplit.setRightComponent(this.techInfoPanel);
        leftSplit.setBorder(null);
        leftSplit.setResizeWeight(0.0);
        leftSplit.setOneTouchExpandable(false);
        leftSplit.setContinuousLayout(true);
        wrapper.add((Component)leftSplit, 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private void initTechGroups(JPanel machineFiltering) {
        GridBagLayout gbl = new GridBagLayout();
        machineFiltering.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_GROUPS_DESC") + "</html>");
        this.groupsTable = new GroupTable(this);
        JPanel paddy = new JPanel();
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(3, 0, 0, 0), 0, 0));
        gbl.setConstraints(this.groupsTable.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 10, 1, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        machineFiltering.add(paddy);
        machineFiltering.add((Component)description);
        machineFiltering.add(this.groupsTable.getRootComponent());
    }

    private void initMachFilters(JPanel machineFiltering) {
        GridBagLayout gbl = new GridBagLayout();
        machineFiltering.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_MACH_FILTER_DESC") + "</html>");
        this.machineFiltersUI = new CombinedMachineFiltersUI(new SaveFilterListener(false), false);
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints((Component)this.machineFiltersUI.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, (Insets)new ScaledInsets(3, 0, 0, 0), 0, 0));
        machineFiltering.add((Component)description);
        machineFiltering.add((Component)this.machineFiltersUI.getRootComponent());
    }

    private void initCustFilters(JPanel customerFiltering) {
        GridBagLayout gbl = new GridBagLayout();
        customerFiltering.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_CUST_FILTER_DESC") + "</html>");
        this.customerFilters = new CombinedCustomerFiltersUI(new SaveFilterListener(true));
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints((Component)this.customerFilters.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, (Insets)new ScaledInsets(3, 0, 0, 0), 0, 0));
        customerFiltering.add((Component)description);
        customerFiltering.add((Component)this.customerFilters.getRootComponent());
    }

    private void initTechInfo(JPanel technicianInfoPanel) {
        GbPanelWrapper mainWrapper = new GbPanelWrapper((Container)technicianInfoPanel);
        JPanel shadedPanel = new JPanel();
        GbPanelWrapper technicianInfo = new GbPanelWrapper((Container)shadedPanel);
        this.avatarChangeListener = new AvatarPanel.AvatarChangeListener(){

            @Override
            public void avatarChanged(byte[] imageBytes) {
                AdminTechnicians.this.selectedTech.setAvatar(imageBytes);
                try {
                    AdminTechnicians.this.techClient.setAvatarImage(AdminTechnicians.this.selectedTech.getLogin(), imageBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.loginNameLabel = new JLabel(Language.get("ADMIN_LOGIN_NAME"));
        this.technicianNameLabel = new JLabel(Language.get("ADMIN_TECH_NAME"));
        this.emailLabel = new JLabel(Language.get("EMAIL_ADDRESS"));
        this.loginNameField = new JTextField();
        this.emailField = new JTextField();
        this.technicianNameField = new JTextField();
        this.setPasswordButton = new JButton(Language.get("ADMIN_PASSWORD"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.resetAppAuthentication = new JButton(Language.get("ADMIN_TOTP_RESET"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.avatarPanel = new AvatarPanel(100, 100, null, ImageLoader.getAsImage((String)"images/svg/users/technician.svg,128"), this.avatarChangeListener, new ImageIcon(ImageLoader.getAsImageDisabled((String)"images/svg/general/cancel.svg,16")));
        this.allowLocallyAuthenticatedLoginsBox = new JCheckBox(Language.get("ADMIN_TECH_ALLOW_LOCAL_LOGINS"));
        this.accountIsEnabled = new JCheckBox(Language.get("TECH_ACCOUNT_ENABLED"));
        this.setTimeoutButton = new JButton(Language.get("TECH_ACCOUNT_TIMEOUT"));
        this.timeoutSummary = new JLabel();
        this.timeoutSummary.setVisible(false);
        this.avatarPanel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3)));
        SwingUtil.setWidth((JComponent)this.loginNameField, (int)SimpleHelpLookAndFeel.scale((int)300));
        SwingUtil.setWidth((JComponent)this.emailField, (int)SimpleHelpLookAndFeel.scale((int)300));
        SwingUtil.setWidth((JComponent)this.technicianNameField, (int)SimpleHelpLookAndFeel.scale((int)300));
        this.setPasswordButton.addActionListener(this);
        this.resetAppAuthentication.addActionListener(this);
        this.loginNameField.addKeyListener(this.saveSettingsListener);
        this.emailField.addKeyListener(this.saveSettingsListener);
        this.technicianNameField.addKeyListener(this.saveSettingsListener);
        this.allowLocallyAuthenticatedLoginsBox.addActionListener(this.saveSettingsListener);
        this.accountIsEnabled.addActionListener(this.saveSettingsListener);
        this.setTimeoutButton.addActionListener(this.saveSettingsListener);
        int Y = 0;
        technicianInfo.add((Component)((Object)this.avatarPanel), 0, Y, 1, 5, 0, 0, 11, 0, (Insets)new ScaledInsets(10, 5, 0, 20));
        technicianInfo.add((Component)this.loginNameLabel, 1, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(10, 0, 0, 5));
        technicianInfo.add((Component)this.loginNameField, 2, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 5));
        technicianInfo.add((Component)this.setPasswordButton, 3, Y++, 2, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 5));
        technicianInfo.add((Component)this.technicianNameLabel, 1, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        technicianInfo.add((Component)this.technicianNameField, 2, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        technicianInfo.add((Component)this.resetAppAuthentication, 3, Y++, 2, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        technicianInfo.add((Component)this.emailLabel, 1, Y, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        technicianInfo.add((Component)this.emailField, 2, Y++, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        technicianInfo.add((Component)this.accountIsEnabled, 2, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
        technicianInfo.add((Component)this.setTimeoutButton, 3, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
        technicianInfo.add((Component)this.timeoutSummary, 2, Y++, 2, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(5, 24, 10, 0));
        technicianInfo.add((Component)this.allowLocallyAuthenticatedLoginsBox, 2, Y++, 3, 1, 3, 1, 17, 0, (Insets)new ScaledInsets(3, 0, 0, 0));
        SwingUtil.setHeight((JComponent)this.resetAppAuthentication, (int)this.loginNameField.getPreferredSize().height);
        SwingUtil.setHeight((JComponent)this.setPasswordButton, (int)this.loginNameField.getPreferredSize().height);
        this.deleteButton = new JButton(Language.get("DELETE_TECHNICIAN"));
        this.deleteButton.addActionListener(this);
        SHButtonUI.makeButtonRed((JButton)this.deleteButton);
        technicianInfo.add((Component)this.deleteButton, 2, Y++, 2, 1, 3, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
        JPanel paddy = new JPanel();
        mainWrapper.add((Component)shadedPanel, 0, 0, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        mainWrapper.add((Component)paddy, 0, 1, 1, 1, 1, 1000, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
    }

    public void createNewTechnician() {
        int id = ServerConfig.get().getTechnicianID();
        byte[] randomBytes = new byte[40];
        this.r.nextBytes(randomBytes);
        String randomP = HexData.byteArrayToHexString((byte[])randomBytes);
        TechUser tech = new TechUser(id, "New Technician", "newtechnician", LazyHashPassword.createWithNewPassword(randomP), "", false, true, true);
        if (this.groupsTable.isForceAtLeastOneGroupSelected()) {
            tech.addGroup(this.allGroups[0]);
        }
        this.techTable.addNewTech(tech);
        this.loginNameField.requestFocusInWindow();
        this.loginNameField.selectAll();
    }

    @Override
    protected void initUI() {
        this.saveSettingsListener = new SaveSettingsListener();
        this.techTable = new TechTable(this);
        this.initTechsTab(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_TECHS");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        ArrayList<TechUser> combinedUsers = config.getAllTechnicians(false);
        Collections.sort(combinedUsers);
        this.techTable.setTechnicians(combinedUsers.toArray(new TechUser[0]));
        this.setDetails(config.getDetails());
        this.setGroups(config.getAllTechGroups());
    }

    @Override
    public void saveComplete(ServerConfig config) {
        this.setGroups(config.getAllTechGroups());
    }

    @Override
    public void saveTo(ServerConfig config) {
        TechUser[] usersToSave;
        ArrayList<TechUser> techs = new ArrayList<TechUser>();
        ArrayList<TechUser> anonTechs = new ArrayList<TechUser>();
        for (TechUser user : usersToSave = this.techTable.getTechnicians()) {
            if (user.isAnonymous()) {
                anonTechs.add(user);
                continue;
            }
            techs.add(user);
        }
        config.setTechnicians(techs);
        config.setAnonymousTechnicians(anonTechs);
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    private void setDetails(CUIField[] details) {
        ArrayList<String> detailList = new ArrayList<String>();
        if (details != null) {
            for (CUIField field : details) {
                if (!(field instanceof AbstractField)) continue;
                detailList.add(field.getLabel());
            }
        }
        String[] result = detailList.toArray(new String[0]);
        this.customerFilters.setDetailKeys(result);
        this.machineFiltersUI.setDetailKeys(result);
    }

    private void setGroups(TechGroup[] groups) {
        this.allGroups = groups;
        this.updateGroupTable();
    }

    private void updateGroupTable() {
        ArrayList<GroupMembership> members = new ArrayList<GroupMembership>();
        for (TechGroup group : this.allGroups) {
            if (this.selectedTech == null) continue;
            boolean isMember = this.selectedTech.isInGroup(group);
            boolean isAdmin = this.selectedTech.isGroupAdminFor(group);
            GroupMembership member = new GroupMembership(group, isMember, isAdmin);
            members.add(member);
        }
        this.groupsTable.setGroups(members.toArray(new GroupMembership[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        TechUser[] selectedTechs = this.techTable.getSelectedTechnicians();
        if (selectedTechs == null) {
            this.selectedTech = null;
        } else if (selectedTechs.length == 1) {
            this.cardLayout.show(this.cardPanel, "SINGLE");
            this.selectedTech = selectedTechs[0];
            this.allowLocallyAuthenticatedLoginsBox.setVisible(!this.selectedTech.isAnonymous());
            this.technicianNameField.setText(this.selectedTech.getDefaultName());
            this.loginNameField.setText(this.selectedTech.getLogin());
            this.emailField.setText(this.selectedTech.getEmail());
            this.allowLocallyAuthenticatedLoginsBox.setSelected(this.selectedTech.allowLocallyAuthenticatedLogins());
            this.accountIsEnabled.setSelected(this.selectedTech.isAccountEnabled());
            this.customerFilters.setExistingFilters(this.selectedTech.getCustomerFilters());
            this.updateTimeoutSummary();
            CombinedMachineFilter machineFilters = this.selectedTech.getMachineFilters();
            SimpleMachineFilter simpleMachineFilter = machineFilters.getSimpleMachineFilter();
            if (simpleMachineFilter != null) {
                simpleMachineFilter.groundWith(this.model);
            }
            this.machineFiltersUI.setExistingFilters(machineFilters);
            if (this.selectedTech.getAvatar() != null) {
                this.avatarPanel.setAvatarImage(this.selectedTech.getAvatar());
            } else {
                this.avatarPanel.setAvatarLoading();
                Object object = this.AVATAR_LOCK;
                synchronized (object) {
                    if (this.avatarFetchThread != null) {
                        this.avatarFetchThread.die();
                    }
                    this.avatarFetchThread = new AvatarFetchThread(this.selectedTech);
                    this.avatarFetchThread.start();
                }
            }
        } else {
            this.cardLayout.show(this.cardPanel, "MULTIPLE");
            this.summaryLabel.setText(selectedTechs.length + " " + Language.get("ADMIN_TECHS"));
        }
        this.techInfoPanel.setHasContents(selectedTechs != null && selectedTechs.length > 0);
        this.checkEnabled();
        this.updateGroupTable();
    }

    private void updateTimeoutSummary() {
        if (this.selectedTech.getEnabledUntilTime() > 0L && !this.selectedTech.isAccountEnabled()) {
            if (this.selectedTech.getEnabledUntilTime() > System.currentTimeMillis()) {
                this.timeoutSummary.setText(Language.get("TECH_TIMEOUT_SUMMARY") + " " + DateFormat.getDateInstance(2).format(new Date(this.selectedTech.getEnabledUntilTime())));
            } else {
                this.timeoutSummary.setText(Language.get("TECH_TIMEOUT_SUMMARY_2") + " " + DateFormat.getDateInstance(2).format(new Date(this.selectedTech.getEnabledUntilTime())));
            }
            this.timeoutSummary.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
            this.timeoutSummary.setVisible(true);
        } else {
            this.timeoutSummary.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton || e.getSource() == this.deleteMultipleButton) {
            String msg;
            String title;
            TechUser[] users = this.techTable.getSelectedTechnicians();
            if (e.getSource() == this.deleteButton) {
                title = Language.get("DELETE_TECHNICIAN_TITLE");
                msg = Language.get("DELETE_TECHNICIAN_MSG", users[0].getLogin());
            } else {
                title = Language.get("DELETE_TECHNICIANS_TITLE");
                msg = Language.get("DELETE_TECHNICIANS_MSG", users.length + "");
            }
            if (SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)msg, (String)title, (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("REMOVE"))) {
                this.techTable.removeSelectedTechnicians();
                this.contentChanged(this.checkIfValid());
                this.saveListener.techChanged();
            }
        } else if (e.getSource().equals(this.setPasswordButton)) {
            PasswordDialog dialog = new PasswordDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), false, this.selectedTech.getDefaultName(), null, false);
            if (dialog.isOK()) {
                if (this.selectedTech.getPassword() == null) {
                    this.selectedTech.setPassword(LazyHashPassword.createWithNewPassword(new String(dialog.getSetPassword())));
                } else {
                    this.selectedTech.getPassword().setOriginalPassword(new String(dialog.getSetPassword()));
                }
                this.contentChanged(this.checkIfValid());
                this.forceSave = true;
                this.saveListener.techChanged();
            }
        } else if (e.getSource() == this.resetAppAuthentication) {
            this.selectedTech.setTOTPKey(null);
            this.contentChanged(this.checkIfValid());
            this.resetAppAuthentication.setEnabled(false);
            this.forceSave = true;
            this.saveListener.techChanged();
        }
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        TechUser user = new TechUser(1);
        user.setEnabledUntilTime(0L);
        TimeoutDialogPanel timeoutDialogPanel = new TimeoutDialogPanel(user);
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("TECH_TIMEOUT_OK"), Language.get("CANCEL"));
        dialogPanel.setTitle(Language.get("TECH_TIMEOUT_DESC"), false);
        dialogPanel.setContent((FixedWidthComponent)timeoutDialogPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(SwingUtil.getParentFrame((Component)frame), 500, (AbstractDialogPanel)dialogPanel);
        dialog.setTitle(Language.get("TECH_TIMEOUT_TITLE"));
        dialog.setDialogIconImage(ClientBranding.get().getLogo32(true).getImage());
        dialog.setShowDecoration(true);
        dialog.showDialog();
        System.out.println(timeoutDialogPanel.getTimeoutAccountTime());
    }

    private void setTimeout() {
        if (this.selectedTech != null) {
            TimeoutDialogPanel timeoutDialogPanel = new TimeoutDialogPanel(this.selectedTech);
            OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("TECH_TIMEOUT_OK"), Language.get("CANCEL"));
            dialogPanel.setTitle(Language.get("TECH_TIMEOUT_DESC"), false);
            dialogPanel.setContent((FixedWidthComponent)timeoutDialogPanel);
            AbstractGlassDialog dialog = new AbstractGlassDialog(SwingUtil.getParentFrame((Component)this.rootComponent), 500, (AbstractDialogPanel)dialogPanel);
            dialog.setTitle(Language.get("TECH_TIMEOUT_TITLE"));
            dialog.setDialogIconImage(ClientBranding.get().getLogo32(true).getImage());
            dialog.setShowDecoration(true);
            dialog.showDialog();
            if (dialogPanel.isOK()) {
                this.selectedTech.setEnabledUntilTime(timeoutDialogPanel.getTimeoutAccountTime());
                this.updateTimeoutSummary();
            }
        }
    }

    class SaveSettingsListener
    implements KeyListener,
    ActionListener {
        SaveSettingsListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKeyPress(e.getSource());
        }

        public void processKeyPress(Object source) {
            if (source.equals(AdminTechnicians.this.technicianNameField)) {
                AdminTechnicians.this.selectedTech.setDefaultName(AdminTechnicians.this.technicianNameField.getText());
            } else if (source.equals(AdminTechnicians.this.loginNameField)) {
                AdminTechnicians.this.selectedTech.setLogin(AdminTechnicians.this.loginNameField.getText());
            } else if (source.equals(AdminTechnicians.this.emailField)) {
                AdminTechnicians.this.selectedTech.setEmail(AdminTechnicians.this.emailField.getText());
            }
            AdminTechnicians.this.forceSave = true;
            AdminTechnicians.this.contentChanged(AdminTechnicians.this.checkIfValid());
            AdminTechnicians.this.techTable.getRootComponent().repaint();
            AdminTechnicians.this.saveListener.techChanged();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(AdminTechnicians.this.allowLocallyAuthenticatedLoginsBox)) {
                AdminTechnicians.this.selectedTech.setAllowLocallyAuthenicatedLogins(AdminTechnicians.this.allowLocallyAuthenticatedLoginsBox.isSelected());
            } else if (e.getSource().equals(AdminTechnicians.this.accountIsEnabled)) {
                if (!AdminTechnicians.this.selectedTech.isAccountEnabled()) {
                    AdminTechnicians.this.selectedTech.setEnabledUntilTime(0L);
                    AdminTechnicians.this.updateTimeoutSummary();
                }
                AdminTechnicians.this.selectedTech.setAccountEnabled(AdminTechnicians.this.accountIsEnabled.isSelected());
            } else if (e.getSource() == AdminTechnicians.this.setTimeoutButton) {
                AdminTechnicians.this.setTimeout();
            }
            AdminTechnicians.this.forceSave = true;
            AdminTechnicians.this.checkEnabled();
            AdminTechnicians.this.contentChanged(AdminTechnicians.this.checkIfValid());
            AdminTechnicians.this.techTable.getRootComponent().repaint();
            AdminTechnicians.this.saveListener.techChanged();
        }
    }

    class AvatarFetchThread
    extends Thread {
        private TechUser user;
        private boolean die;

        public AvatarFetchThread(TechUser user) {
            super("AvatarFetchThread");
            this.die = false;
            this.user = user;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            byte[] avatar;
            if (AdminTechnicians.this.techClient == null) {
                return;
            }
            try {
                avatar = AdminTechnicians.this.techClient.getAvatarImage(this.user.getLogin());
            }
            catch (Exception e) {
                System.out.println("[AvatarFetchThread] Unable to fetch avatar for user " + this.user.getLogin());
                e.printStackTrace();
                byte[] dummy = new byte[]{};
                AdminTechnicians.this.avatarPanel.setAvatarImage(dummy);
                return;
            }
            if (!this.die) {
                this.user.setAvatar(avatar);
                AdminTechnicians.this.avatarPanel.setAvatarImage(avatar);
            }
        }
    }

    class SaveFilterListener
    implements FilterChangeListener {
        private boolean isCustomer = false;

        public SaveFilterListener(boolean isCustomer) {
            this.isCustomer = isCustomer;
        }

        @Override
        public void filterChanged() {
            if (this.isCustomer) {
                Filter[] filters = AdminTechnicians.this.customerFilters.getFilters();
                CustomerFilter[] newFilters = new CustomerFilter[filters.length];
                for (int i = 0; i < newFilters.length; ++i) {
                    newFilters[i] = (CustomerFilter)filters[i];
                }
                AdminTechnicians.this.selectedTech.setCustomerFilters(newFilters);
            } else {
                AdminTechnicians.this.selectedTech.getMachineFilters().setTo(AdminTechnicians.this.machineFiltersUI.getMachineFilter());
            }
            AdminTechnicians.this.contentChanged(AdminTechnicians.this.checkIfValid());
            AdminTechnicians.this.forceSave = true;
            AdminTechnicians.this.saveListener.filtersChanged();
        }
    }
}

