/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.multiserver.MultiServerPanel;
import com.aem.shelp.tech.admin.multiserver.ServerEditInterface;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.authentication.RadiusProperties;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminRadius
extends SubSection
implements ValidationKeyListener.ValidationInterface,
ActionListener {
    private JCheckBox enableBox;
    private ArrayList<ServerConfig.RadiusConfig> radiusConfigs = new ArrayList();
    private RoundBorderPanel radiusConfiguration;
    private RadiusServerPanel serverPanel;
    private boolean forceSave = false;
    private JLabel desc;

    @Override
    protected void initUI() {
        this.initRadiusTab(this.rootComponent);
    }

    public void licenseChanged() {
        boolean radiusAllowed = false;
        if (AdminPanel.LOADED_LICENSES != null && AdminPanel.LOADED_LICENSES.allowsRADIUS()) {
            radiusAllowed = true;
        }
        if (radiusAllowed) {
            this.enableBox.setEnabled(true);
            this.desc.setEnabled(true);
        } else {
            this.enableBox.setEnabled(false);
            this.desc.setEnabled(false);
        }
    }

    private void initRadiusTab(JPanel radiusPanel) {
        this.serverPanel = new RadiusServerPanel();
        GbPanelWrapper mainRadius = new GbPanelWrapper((Container)radiusPanel);
        this.enableBox = new JCheckBox(Language.get("RADIUS_ENABLE"));
        boolean radiusAllowed = false;
        if (AdminPanel.LOADED_LICENSES != null && AdminPanel.LOADED_LICENSES.allowsRADIUS()) {
            radiusAllowed = true;
        }
        if (!radiusAllowed) {
            this.enableBox.setSelected(false);
            this.enableBox.setEnabled(false);
        }
        this.enableBox.addActionListener(this);
        this.enableBox.addActionListener(this.validateListener);
        this.radiusConfiguration = new RoundBorderPanel();
        this.radiusConfiguration.setLayout(new GridLayout(1, 1));
        this.radiusConfiguration.add(this.serverPanel.getRootComponent());
        this.serverPanel.getRootComponent().setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.radiusConfiguration.setVisible(false);
        int Y = 0;
        this.desc = new JLabel(Language.get("RADIUS_CONFIGURATION_DESC"));
        if (!radiusAllowed) {
            this.desc.setEnabled(false);
        }
        mainRadius.add((Component)this.desc, 0, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0));
        mainRadius.add((Component)this.enableBox, 0, Y++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        mainRadius.add((Component)this.radiusConfiguration, 0, Y++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 0, 3, 0));
    }

    @Override
    public String getTitle() {
        boolean radiusAllowed = false;
        if (AdminPanel.LOADED_LICENSES != null && AdminPanel.LOADED_LICENSES.allowsRADIUS()) {
            radiusAllowed = true;
        }
        if (!radiusAllowed) {
            return Language.get("ADMIN_TEST_RADIUS_TITLE") + " " + Language.get("ENTERPRISE_ONLY");
        }
        return Language.get("ADMIN_TEST_RADIUS_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.enableBox.setSelected(config.radiusEnable);
        this.radiusConfiguration.setVisible(config.radiusEnable);
        this.radiusConfigs.clear();
        if (config.radiusConfigs != null) {
            Collections.addAll(this.radiusConfigs, config.radiusConfigs);
        }
        this.serverPanel.loadAll(this.radiusConfigs);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.radiusEnable = this.enableBox.isSelected();
        config.radiusConfigs = this.radiusConfigs.toArray(new ServerConfig.RadiusConfig[0]);
    }

    @Override
    public void checkEnabled() {
    }

    public ArrayList checkAndMarkValid() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.enableBox) {
            this.radiusConfiguration.setVisible(this.enableBox.isSelected());
        }
    }

    @Override
    public boolean forceSave() {
        boolean state = this.forceSave;
        this.forceSave = false;
        return state;
    }

    public class RadiusServerPanel
    extends MultiServerPanel<ServerConfig.RadiusConfig> {
        @Override
        public ServerConfig.RadiusConfig newConfiguration() {
            return new ServerConfig.RadiusConfig();
        }

        @Override
        public JPanel getEditPanel(ServerConfig.RadiusConfig config, ServerEditInterface editInterface) {
            return new RadiusEditPanel(AdminRadius.this.techClient, config, editInterface);
        }

        @Override
        public String getNewButtonText() {
            return Language.get("NEW_RADIUS_SERVER");
        }

        @Override
        public void requestSave() {
            AdminRadius.this.forceSave = true;
            AdminRadius.this.saveListener.actionPerformed(null);
        }
    }

    public static class RadiusEditPanel
    extends GbPanel
    implements ActionListener,
    KeyListener {
        private final TechClient techClient;
        private final ServerEditInterface editInterface;
        private final ServerConfig.RadiusConfig config;
        private JLabel radiusAuthenticationLabel;
        private JComboBox radiusAuthenticationBox;
        private JLabel radiusHostnameLabel;
        private JTextField radiusHostnameField;
        private JLabel authPortLabel;
        private JTextField authPortField;
        private JLabel radiusSecretLabel;
        private JTextField radiusSecretField;
        private JButton testRadiusConnection;
        private PleaseWaitDialog pleaseWaitDialog;

        public RadiusEditPanel(TechClient client, ServerConfig.RadiusConfig config, ServerEditInterface editInterface) {
            super(new ScaledInsets(3, 3, 3, 3));
            this.techClient = client;
            this.editInterface = editInterface;
            this.config = config;
            this.initUI();
            this.load(config);
        }

        private void load(ServerConfig.RadiusConfig config) {
            this.radiusHostnameField.setText(config.radiusHostname);
            this.radiusSecretField.setText(config.radiusSecret);
            this.authPortField.setText(Integer.toString(config.radiusPort));
            this.radiusAuthenticationBox.setSelectedItem(config.radiusAuthProtocol);
            if (this.radiusAuthenticationBox.getSelectedIndex() == -1) {
                this.radiusAuthenticationBox.setSelectedIndex(0);
            }
            this.updateEnabled();
        }

        public void initUI() {
            this.testRadiusConnection = new JButton(Language.get("LDAP_TEST_CONNECTION"));
            this.testRadiusConnection.addActionListener(this);
            this.radiusAuthenticationLabel = new JLabel(Language.get("RADIUS_AUTHENTICATION"));
            this.radiusAuthenticationBox = new JComboBox<String>(RadiusProperties.ALL_AUTHENTICATION_MODES);
            this.radiusHostnameLabel = new JLabel(Language.get("RADIUS_HOSTNAME"));
            this.radiusHostnameField = new JTextField();
            this.radiusSecretLabel = new JLabel(Language.get("RADIUS_SECRET"));
            this.radiusSecretField = new JTextField();
            this.authPortLabel = new JLabel(Language.get("RADIUS_AUTH_PORT"));
            this.authPortField = new JTextField();
            this.authPortField.setDocument(new DigitDocument(false));
            SwingUtil.setWidth((JComponent)this.radiusHostnameField, (int)SimpleHelpLookAndFeel.scale((int)200));
            SwingUtil.setWidth((JComponent)this.authPortField, (int)SimpleHelpLookAndFeel.scale((int)60));
            SwingUtil.setWidth((JComponent)this.radiusSecretField, (int)SimpleHelpLookAndFeel.scale((int)200));
            this.radiusAuthenticationBox.setSelectedIndex(0);
            this.radiusHostnameField.addKeyListener(this);
            this.radiusAuthenticationBox.addActionListener(this);
            this.authPortField.addKeyListener(this);
            this.radiusSecretField.addKeyListener(this);
            int Y = 0;
            this.add(this.radiusAuthenticationLabel, 0, Y, 1, 1, 0, 0, 13, 0);
            this.add(this.radiusAuthenticationBox, 1, Y, 1, 1, 0, 0, 17, 0);
            this.add(this.testRadiusConnection, 2, Y, 2, 2, 1, 1, 12, 0);
            this.add(this.radiusHostnameLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
            this.add(this.radiusHostnameField, 1, Y, 1, 1, 0, 0, 17, 0);
            this.add(this.authPortLabel, 2, Y, 1, 1, 0, 0, 13, 0);
            this.add(this.authPortField, 3, Y, 1, 1, 0, 0, 17, 0);
            this.add(this.radiusSecretLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
            this.add(this.radiusSecretField, 1, Y, 1, 1, 0, 0, 17, 0);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.updateEnabled();
            this.save();
        }

        private void save() {
            this.config.radiusHostname = this.radiusHostnameField.getText();
            this.config.radiusSecret = this.radiusSecretField.getText();
            this.config.radiusAuthProtocol = String.valueOf(this.radiusAuthenticationBox.getSelectedItem());
            try {
                this.config.radiusPort = Integer.parseInt(this.authPortField.getText());
            }
            catch (NumberFormatException e) {
                this.config.radiusPort = 1812;
            }
        }

        private void updateEnabled() {
            boolean invalid = this.radiusAuthenticationBox.getSelectedIndex() == -1 || this.radiusHostnameField.getText().length() == 0 || this.authPortField.getText().length() == 0 || this.radiusSecretField.getText().length() == 0;
            this.testRadiusConnection.setEnabled(!invalid);
            this.editInterface.setEnabled(!invalid);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                if (e.getSource().equals(this.testRadiusConnection)) {
                    try {
                        this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)((Object)this)), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_RADIUS"));
                        new TestRadiusThread(SwingUtil.getRootPaneContainer((Component)((Object)this)), this.techClient, this.pleaseWaitDialog, this.radiusHostnameField.getText(), this.authPortField.getText(), String.valueOf(this.radiusAuthenticationBox.getSelectedItem()), this.radiusSecretField.getText());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (this.pleaseWaitDialog == null) break block3;
                        this.pleaseWaitDialog.setVisible(false);
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    public static class TestRadiusThread
    extends Thread {
        private final String hostname;
        private final String port;
        private final String authentication;
        private final String secret;
        private final PleaseWaitDialog pleaseWaitDialog;
        private final TechClient techClient;
        private final RootPaneContainer rpc;

        public TestRadiusThread(RootPaneContainer rpc, TechClient techClient, PleaseWaitDialog pleaseWaitDialog, String hostname, String port, String authentication, String secret) {
            super("TestRadiusThread");
            this.hostname = hostname;
            this.port = port;
            this.authentication = authentication;
            this.secret = secret;
            this.pleaseWaitDialog = pleaseWaitDialog;
            this.techClient = techClient;
            this.rpc = rpc;
            this.start();
        }

        @Override
        public void run() {
            try {
                boolean auth = this.techClient.testRadiusConnectSoServer(this.hostname, Integer.parseInt(this.port), this.authentication, this.secret);
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)this.rpc, (String)Language.get("RADIUS_SERVER_CONNECT_OK"), (String)Language.get("ADMIN_TEST_RADIUS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)this.rpc, (String)(Language.get("ADMIN_LDAP_ERR_MSG") + ": " + t.getMessage()), (String)Language.get("ADMIN_TEST_RADIUS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

