/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.profiles.model.AppProfile;
import com.aem.sdesktop.client.gui.FPSSlider;
import com.aem.sgateway.common.SGServiceNameUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.AuthenticationPanel;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.technicians.GroupPermissionsUI;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.tech.utils.filters.CombinedCustomerFiltersUI;
import com.aem.shelp.tech.utils.filters.CombinedMachineFiltersUI;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import com.aem.shelp.util.swing.EmptyBorderedPanel;
import com.aem.shelp.util.swing.IconedAbstractListUI;
import com.aem.shelp.util.swing.InactivityTimeoutPanel;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.JComboBoxFixer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.JWrapLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminGroups
extends SubSection
implements ListSelectionListener {
    public static AdminGroups INSTANCE = null;
    private final AdminPanel adminPanel;
    private ValidationListener validationListener;
    private GroupList groupList;
    private JButton addVariableButton;
    private CombinedCustomerFiltersUI groupCustomerFilters;
    private CombinedMachineFiltersUI groupMachineFilters;
    private AuthenticationPanel groupAuthPanel;
    private JTextField groupNameField;
    private JLabel groupNameLabel;
    private boolean loading = false;
    private JLabel groupHostnameLabel;
    private MessageTextField groupHostname;
    private JLabel sgServiceLabel;
    private MessageTextField sgServiceField;
    private JCheckBox allowAnonymousLoginsCheckBox;
    private JWrapCheckBox shSessionLimitCheckBox;
    private JWrapCheckBox sgSessionLimitCheckBox;
    private JWrapCheckBox sessionTimeoutCheckBox;
    private InactivityTimeoutPanel inactivityTimeoutPanel;
    private JLabel groupMaxShSessions;
    private JLabel userMaxShSessions;
    private JLabel groupMaxSgSessions;
    private JLabel userMaxSgSessions;
    private JTextField groupMaxShSessionsT;
    private JTextField userMaxShSessionsT;
    private JTextField groupMaxSgSessionsT;
    private JTextField userMaxSgSessionsT;
    private JLabel groupLimitFileTransferLabel;
    private JTextField groupLimitFileTransferTextField;
    private JComboBox groupLimitUnitBox;
    private JWrapCheckBox fileTransferLimitCheckBox;
    private JWrapCheckBox speedLimitCheckBox;
    private JTextField sessionLimitTextField;
    private JLabel sessionLimitLabel;
    private JLabel sessionLimitUnits;
    private JWrapCheckBox fpsLimitCheckBox;
    private FPSSlider fpsSlider;
    private GroupPermissionsUI permissionsUI;
    private TechGroup selectedGroup;
    private CUIField[] details;
    private MachineTreeModel model;
    private boolean forceSave = false;
    JTabbedPane groupTabs;
    JPanel customerFiltering;
    JPanel machineFiltering;
    private NoContentsInfoPanel groupInfoPanel;
    private GbPanel groupSessions;
    boolean filteringOn = false;

    public AdminGroups(AdminPanel adminPanel) {
        INSTANCE = this;
        this.adminPanel = adminPanel;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
        this.groupMachineFilters.setMachineTreeModel(model);
        this.permissionsUI.setMachineTreeModel(model);
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        this.groupAuthPanel.setTechClient(techClient);
        this.permissionsUI.setTechClient(techClient);
    }

    @Override
    public boolean forceSave() {
        if (this.forceSave) {
            this.forceSave = false;
            return true;
        }
        return false;
    }

    @Override
    public void overrideBorderForSubSection() {
        this.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder());
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    public void selectGroup(TechGroup group) {
        this.groupList.setSelectedElement(group);
    }

    public void removeGroupAssociatedWith(AppProfile app, boolean saveConfig) {
        System.out.println("[AdminGroups] Removing group associated with " + app.getID());
        TechGroup removeGroup = null;
        for (TechGroup group : this.groupList.getSimpleList()) {
            if (group.getAssociatedAppProfileID() == null || !group.getAssociatedAppProfileID().equals(app.getID())) continue;
            System.out.println("[AdminGroups] Found group " + group);
            removeGroup = group;
            break;
        }
        if (removeGroup != null) {
            this.groupList.getSimpleList().remove(removeGroup);
            if (saveConfig) {
                this.saveListener.requestImmediateSave();
            }
        }
    }

    private JPopupMenu getAddVariableMenu(String[] customerDetails) {
        JPopupMenu variableAddressMenu = new JPopupMenu();
        JComboBoxFixer.fix((JPopupMenu)variableAddressMenu);
        String[] names = SGServiceNameUtil.getAllVariableNames(customerDetails);
        String[] ids = SGServiceNameUtil.getAllVariableIDs(customerDetails);
        for (int i = 0; i < names.length; ++i) {
            JMenuItem item = new JMenuItem(new InsertVariableAction(names[i], ids[i]));
            variableAddressMenu.add(item);
        }
        return variableAddressMenu;
    }

    @Override
    protected void initUI() {
        this.groupList = new GroupList(Language.DEFLANG, new TechGroup[0]);
        this.groupList.addListSelectionListener(this);
        this.initGroupsTab(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_TECH_GROUPS");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        Object[] groups = config.getAllTechGroups();
        if (groups != null) {
            Arrays.sort(groups);
        }
        this.setDetails(config.getDetails());
        this.groupList.setObjects(groups);
        this.groupHostname.setMessageText(config.hostname);
        this.groupAuthPanel.setConfiguredServers(config.ldapEnable, config.radiusEnable, config.emailSettingsEnabled);
        if (this.selectedGroup != null) {
            this.loadSelection();
        }
    }

    private void setDetails(CUIField[] details) {
        this.details = details;
        ArrayList<String> detailList = new ArrayList<String>();
        if (details != null) {
            for (CUIField field : details) {
                if (!(field instanceof AbstractField)) continue;
                detailList.add(field.getLabel());
            }
        }
        String[] result = detailList.toArray(new String[0]);
        this.groupCustomerFilters.setDetailKeys(result);
        this.groupMachineFilters.setDetailKeys(result);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.setGroups(this.groupList.getObjects(new TechGroup[0]));
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    private void initGroupsTab(JPanel groupsPanel) {
        this.validationListener = new ValidationListener();
        groupsPanel.setLayout(new BorderLayout());
        JPanel groupDetails = new JPanel();
        groupDetails.setLayout(new GridLayout(1, 1));
        this.groupTabs = new JTabbedPane();
        groupDetails.add(this.groupTabs);
        EmptyBorderedPanel groupInfo = new EmptyBorderedPanel();
        this.initGroupInfo(groupInfo);
        JPanel groupPermissions = new JPanel();
        this.initGroupPermissions(groupPermissions);
        this.groupSessions = new GbPanel();
        this.initGroupSessions(this.groupSessions);
        this.customerFiltering = new EmptyBorderedPanel();
        this.initGroupPanelCustomer(this.customerFiltering);
        this.machineFiltering = new EmptyBorderedPanel();
        this.initGroupPanelMachines(this.machineFiltering);
        JPanel authenticationPanel = new JPanel();
        this.initGroupAuthenticationPanel(authenticationPanel);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_INFO_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/preferences.svg,16"), groupInfo);
        JScrollPane sp = new JScrollPane(groupPermissions);
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        JScrollPane authPane = new JScrollPane(authenticationPanel);
        authPane.setBorder(SHBorderFactory.createEmptyBorder());
        JScrollPane sessionLimitPane = new JScrollPane((Component)this.groupSessions);
        sessionLimitPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_PERMISSIONS_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/preferences.svg,16"), sp);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_SESSIONS_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/help.svg,16"), sessionLimitPane);
        this.groupTabs.addTab(Language.get("ADMIN_GROUP_AUTH_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"), authPane);
        this.addFilteringTabs();
        Dimension dim = this.groupList.getPreferredSize();
        dim.width = SimpleHelpLookAndFeel.scale((int)170);
        this.groupList.setPreferredSize(dim);
        this.groupList.setMinimumSize(dim);
        this.groupList.setMaximumSize(dim);
        this.groupList.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)0));
        this.groupList.setElementListBorder(SHBorderFactory.createEmptyBorder());
        this.groupList.setScrollPaneBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.LIGHT_GRAY_HORIZONTAL_LINE));
        this.groupList.setRowHeight(SHStyle.ROW_HEIGHT);
        this.groupInfoPanel = new NoContentsInfoPanel(Language.get("ADMIN_PANEL_SELECT_GROUP"), ImageLoader.getImageIconDisabled((String)"images/svg/users/group.svg,48"), false);
        this.groupInfoPanel.setContentsPanel(groupDetails);
        SHSplitPane leftSplit = new SHSplitPane();
        leftSplit.setDividerLocation(0.25);
        leftSplit.setLeftComponent((Component)((Object)this.groupList));
        leftSplit.setRightComponent(this.groupInfoPanel);
        leftSplit.setBorder(null);
        leftSplit.setResizeWeight(0.0);
        leftSplit.setOneTouchExpandable(false);
        leftSplit.setContinuousLayout(true);
        groupsPanel.add((Component)leftSplit, "Center");
    }

    private void removeFilteringTabs() {
        if (this.filteringOn) {
            this.filteringOn = false;
            this.groupTabs.remove(this.customerFiltering);
            this.groupTabs.remove(this.machineFiltering);
        }
    }

    private void addFilteringTabs() {
        if (!this.filteringOn) {
            this.filteringOn = true;
            this.groupTabs.addTab(Language.get("ADMIN_CUST_FILTERING_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/funnel-abstract-blue.svg,16"), this.customerFiltering);
            this.groupTabs.addTab(Language.get("ADMIN_MACH_FILTERING_TAB"), ImageLoader.getImageIcon((String)"images/svg/general/funnel-abstract-blue.svg,16"), this.machineFiltering);
        }
    }

    public void reloadTwoTierEmailDefaults() {
        this.groupAuthPanel.reloadEmailAuthenticationDefaults();
    }

    private void initAdvancedPanel(JPanel advancedPanel) {
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)advancedPanel);
        JWrapLabel networkTitle = new JWrapLabel("<html>" + Language.get("TECH_UI_SESSION_PROPERTIES"));
        networkTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        networkTitle.setFont(SHStyle.largeFont);
        int Y = 0;
        wrapper.add((Component)networkTitle, 0, Y++, 2, 1, 1, 0, 18, 1, (Insets)new ScaledInsets(5, 15, 0, 0));
    }

    private void initGroupAuthenticationPanel(JPanel authenticationPanel) {
        GridBagLayout gbl = new GridBagLayout();
        authenticationPanel.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_GROUP_AUTH_DESC") + "</html>");
        this.groupAuthPanel = new AuthenticationPanel(){

            @Override
            public void save() {
                if (AdminGroups.this.selectedGroup == null) {
                    return;
                }
                AdminGroups.this.selectedGroup.setPassword(this.usePassword());
                if (this.usePassword()) {
                    AdminGroups.this.selectedGroup.setPassword(this.password);
                } else {
                    AdminGroups.this.selectedGroup.setPassword(null);
                }
                AdminGroups.this.selectedGroup.setLDAP(this.useLDAP());
                if (this.useLDAP()) {
                    this.saveLDAPSettings(AdminGroups.this.selectedGroup.getLDAPProperties());
                }
                AdminGroups.this.selectedGroup.setMultiTierEmail(this.useTwoTier());
                AdminGroups.this.selectedGroup.setTwoTierCodeLength(this.multiTierConfig.getEmailCodeLength());
                AdminGroups.this.selectedGroup.setTwoTierEmail(this.multiTierConfig.getEmailSubject(), this.multiTierConfig.getEmailBody());
                AdminGroups.this.selectedGroup.setMultiTierRememberMachine(this.multiTierConfig.rememberBox.isSelected());
                AdminGroups.this.selectedGroup.setRadius(this.useRadius());
                AdminGroups.this.selectedGroup.setMultiTierApp(this.useAppAuthentication());
                AdminGroups.this.forceSave = true;
                AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
                AdminGroups.this.saveListener.techGroupChanged();
            }

            @Override
            public void switchToRadiusServerConfig() {
                AdminGroups.this.adminPanel.switchToLoginSecuritySection();
            }

            @Override
            public void switchToLDAPServerConfig() {
                AdminGroups.this.adminPanel.switchToLoginSecuritySection();
            }

            @Override
            public void switchToEmailServerConfig() {
                AdminGroups.this.adminPanel.switchToEmailSection();
            }
        };
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 5), 0, 0));
        gbl.setConstraints((Component)this.groupAuthPanel.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        authenticationPanel.add((Component)description);
        authenticationPanel.add((Component)this.groupAuthPanel.getRootComponent());
    }

    private void initGroupPanelCustomer(JPanel generalPanel) {
        GridBagLayout gbl = new GridBagLayout();
        generalPanel.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_CUST_FILTER_DESC") + "</html>");
        this.groupCustomerFilters = new CombinedCustomerFiltersUI(new SaveFilterListener(true));
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints((Component)this.groupCustomerFilters.getRootComponent(), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 1, (Insets)new ScaledInsets(3, 0, 0, 0), 0, 0));
        generalPanel.add((Component)description);
        generalPanel.add((Component)this.groupCustomerFilters.getRootComponent());
    }

    private void initGroupPanelMachines(JPanel generalPanelMachines) {
        GridBagLayout gbl = new GridBagLayout();
        generalPanelMachines.setLayout(gbl);
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("ADMIN_MACH_FILTER_DESC") + "</html>");
        this.groupMachineFilters = new CombinedMachineFiltersUI(new SaveFilterListener(false), false);
        int Y = 0;
        gbl.setConstraints((Component)description, new GridBagConstraints(0, Y++, 1, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 0), 0, 0));
        gbl.setConstraints((Component)this.groupMachineFilters.getRootComponent(), new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 1, (Insets)new ScaledInsets(3, 0, 0, 0), 0, 0));
        generalPanelMachines.add((Component)description);
        generalPanelMachines.add((Component)this.groupMachineFilters.getRootComponent());
    }

    @Override
    public void setRequestSaveListener(AdminSection.RequestSaveListener listener) {
        super.setRequestSaveListener(listener);
        this.permissionsUI.setRequestSaveListener(listener);
    }

    private void initGroupPermissions(JPanel groupPermissions) {
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)groupPermissions);
        this.permissionsUI = new GroupPermissionsUI(this.validationListener);
        wrapper.add((Component)this.permissionsUI.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private void initGroupInfo(JPanel gInfo) {
        GbPanelWrapper groupInfo = new GbPanelWrapper((Container)gInfo);
        this.groupNameLabel = new JLabel(Language.get("ADMIN_GROUP_NAME"));
        this.groupNameField = new JTextField();
        JWrapLabel anonDescription = new JWrapLabel("<html>" + Language.get("ADMIN_GROUP_ANON_DESC") + "</html>");
        anonDescription.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.allowAnonymousLoginsCheckBox = new JCheckBox(Language.get("ADMIN_GROUP_ANON_LOGINS"));
        this.allowAnonymousLoginsCheckBox.setVerticalAlignment(1);
        this.allowAnonymousLoginsCheckBox.setBorder(SHBorderFactory.createEmptyBorder());
        this.groupHostnameLabel = new JLabel(Language.get("ADMIN_GROUP_HOSTNAME"));
        this.groupHostname = new MessageTextField(null, null);
        this.sgServiceLabel = new JLabel(Language.get("ADMIN_GROUP_SGSERVICE_NAME"));
        this.sgServiceField = new MessageTextField(null, null);
        this.sgServiceField.setMessageText(Language.get("CUSTOMER") + "/${CustomerDetails}");
        JPanel paddy = new JPanel();
        SwingUtil.setWidth((JComponent)this.groupNameField, (int)SimpleHelpLookAndFeel.scale((int)230));
        SwingUtil.setWidth((JComponent)this.groupHostname, (int)SimpleHelpLookAndFeel.scale((int)230));
        SwingUtil.setWidth((JComponent)this.sgServiceField, (int)SimpleHelpLookAndFeel.scale((int)230));
        this.groupNameField.addKeyListener(this.validationListener);
        this.groupHostname.addKeyListener((KeyListener)this.validationListener);
        this.sgServiceField.addKeyListener((KeyListener)this.validationListener);
        this.allowAnonymousLoginsCheckBox.addActionListener(this.validationListener);
        this.addVariableButton = new JButton("+");
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.addVariableButton);
        SwingUtil.setHeight((JComponent)this.addVariableButton, (int)this.sgServiceField.getPreferredSize().height);
        GbPanel panel = new GbPanel();
        panel.add((Component)this.sgServiceField, 0, 0, 1, 1, 0, 1, 13, 0);
        panel.add((Component)this.addVariableButton, 1, 0, 1, 1, 0, 1, 13, 0);
        this.addVariableButton.addActionListener(new AddVariableActionListener());
        int Y = 0;
        groupInfo.add((Component)this.groupNameLabel, 0, Y, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(20, 30, 0, 0));
        groupInfo.add((Component)this.groupNameField, 1, Y++, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(20, 5, 0, 0));
        groupInfo.add((Component)this.allowAnonymousLoginsCheckBox, 1, Y, 1, 1, 0, 0, 18, 3, (Insets)new ScaledInsets(15, 5, 0, 0));
        groupInfo.add((Component)anonDescription, 2, Y++, 1, 1, 100, 0, 18, 2, (Insets)new ScaledInsets(15, 0, 0, 0));
        groupInfo.add((Component)this.groupHostnameLabel, 0, Y, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(20, 30, 0, 0));
        groupInfo.add((Component)this.groupHostname, 1, Y++, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(20, 5, 0, 0));
        groupInfo.add((Component)this.sgServiceLabel, 0, Y, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(20, 30, 0, 0));
        groupInfo.add((Component)panel, 1, Y++, 2, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(20, 5, 0, 0));
        groupInfo.add((Component)paddy, 0, Y++, 2, 1, 3, 100, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
    }

    private void initGroupSessions(GbPanel groupPanel) {
        SHStrippedContentPanel contentPanel = new SHStrippedContentPanel(groupPanel);
        this.shSessionLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICT_SH_SESSIONS"));
        this.groupMaxShSessions = new JLabel(Language.get("ADMIN_GROUP_MAX_SH_SESSIONS"));
        this.groupMaxShSessionsT = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        this.userMaxShSessions = new JLabel(Language.get("ADMIN_USER_MAX_SH_SESSIONS"));
        this.userMaxShSessionsT = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        this.inactivityTimeoutPanel = new InactivityTimeoutPanel();
        this.sessionTimeoutCheckBox = new JWrapCheckBox(Language.get("TERMINATE_TITLE"));
        this.sgSessionLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICT_SG_SESSIONS"));
        this.groupMaxSgSessions = new JLabel(Language.get("ADMIN_GROUP_MAX_SG_SESSIONS"));
        this.groupMaxSgSessionsT = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        this.userMaxSgSessions = new JLabel(Language.get("ADMIN_USER_MAX_SG_SESSIONS"));
        this.userMaxSgSessionsT = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        this.fileTransferLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_RESTRICTION_FTP_SIZE"));
        this.groupLimitFileTransferLabel = new JLabel(Language.get("ADMIN_RESTRICTION_FTP_SIZE_LABEL"));
        this.groupLimitFileTransferTextField = new JTextField();
        this.groupLimitFileTransferTextField.setDocument(new DigitDocument());
        this.groupLimitUnitBox = new JComboBox<String>(new String[]{Language.get("BYTES"), Language.get("KBYTES"), Language.get("MBYTES")});
        this.sessionLimitLabel = new JLabel(Language.get("ADMIN_SESSION_LIMIT_LABEL"));
        this.sessionLimitUnits = new JLabel(Language.get("KBPS"));
        this.speedLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_GROUP_LIMIT_SPEED_BOX"));
        this.sessionLimitTextField = new JTextField();
        this.sessionLimitTextField.setDocument(new DigitDocument());
        this.fpsLimitCheckBox = new JWrapCheckBox(Language.get("ADMIN_GROUP_LIMIT_FPS_BOX"));
        this.fpsSlider = new FPSSlider();
        JPanel paddy = new JPanel();
        SwingUtil.setWidth((JComponent)this.groupMaxShSessionsT, (int)SimpleHelpLookAndFeel.scale((int)75));
        SwingUtil.setWidth((JComponent)this.userMaxShSessionsT, (int)SimpleHelpLookAndFeel.scale((int)75));
        SwingUtil.setWidth((JComponent)this.groupMaxSgSessionsT, (int)SimpleHelpLookAndFeel.scale((int)75));
        SwingUtil.setWidth((JComponent)this.userMaxSgSessionsT, (int)SimpleHelpLookAndFeel.scale((int)75));
        SwingUtil.setWidth((JComponent)this.groupLimitFileTransferTextField, (int)SimpleHelpLookAndFeel.scale((int)125));
        SwingUtil.setWidth((JComponent)this.sessionLimitTextField, (int)SimpleHelpLookAndFeel.scale((int)100));
        this.inactivityTimeoutPanel.addKeyListener(this.validationListener);
        this.shSessionLimitCheckBox.addActionListener(this.validationListener);
        this.sgSessionLimitCheckBox.addActionListener(this.validationListener);
        this.sessionTimeoutCheckBox.addActionListener(this.validationListener);
        this.fileTransferLimitCheckBox.addActionListener(this.validationListener);
        this.speedLimitCheckBox.addActionListener(this.validationListener);
        this.fpsLimitCheckBox.addActionListener(this.validationListener);
        this.groupLimitUnitBox.addActionListener(this.validationListener);
        this.groupMaxShSessionsT.addKeyListener(this.validationListener);
        this.userMaxShSessionsT.addKeyListener(this.validationListener);
        this.groupMaxSgSessionsT.addKeyListener(this.validationListener);
        this.userMaxSgSessionsT.addKeyListener(this.validationListener);
        this.groupLimitFileTransferTextField.addKeyListener(this.validationListener);
        this.sessionLimitTextField.addKeyListener(this.validationListener);
        this.fpsSlider.addChangeListener(this.validationListener);
        ColorPropagatingGBPanel panel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        int Y = 0;
        panel.add(this.shSessionLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        panel.add(this.groupMaxShSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        panel.add(this.groupMaxShSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        panel.add(this.userMaxShSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        panel.add(this.userMaxShSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        contentPanel.addContent((JComponent)((Object)panel), null);
        ColorPropagatingGBPanel groupInfo = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        Y = 0;
        groupInfo.add(this.sgSessionLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        groupInfo.add(this.groupMaxSgSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.groupMaxSgSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        groupInfo.add(this.userMaxSgSessions, 0, Y, 1, 1, 0, 0, 13, 0);
        groupInfo.add(this.userMaxSgSessionsT, 1, Y++, 1, 1, 1, 0, 17, 0);
        contentPanel.addContent((JComponent)((Object)groupInfo), null);
        groupInfo = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        Y = 0;
        groupInfo.add(this.sessionTimeoutCheckBox.getRootComponent(), 0, Y++, 1, 1, 1, 0, 17, 2);
        groupInfo.add((Component)this.inactivityTimeoutPanel.getRootComponent(), 0, Y, 1, 1, 1, 0, 17, 2);
        contentPanel.addContent((JComponent)((Object)groupInfo), null);
        groupInfo = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        Y = 0;
        groupInfo.add(this.fileTransferLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        GbPanel fileLimitPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        fileLimitPanel.add((Component)this.groupLimitFileTransferLabel, 0, 0, 1, 1, 0, 0, 13, 2);
        fileLimitPanel.add((Component)this.groupLimitFileTransferTextField, 1, 0, 1, 1, 0, 0, 13, 2);
        fileLimitPanel.add((Component)this.groupLimitUnitBox, 2, 0, 1, 1, 1, 1, 17, 0);
        groupInfo.add((Component)fileLimitPanel, 0, Y++, 2, 1, 0, 0, 13, 2);
        contentPanel.addContent((JComponent)((Object)groupInfo), null);
        groupInfo = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        Y = 0;
        groupInfo.add(this.speedLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        ColorPropagatingGBPanel sessionLimitPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        sessionLimitPanel.add(this.sessionLimitLabel, 0, 0, 1, 1, 0, 0, 13, 2);
        sessionLimitPanel.add(this.sessionLimitTextField, 1, 0, 1, 1, 0, 0, 13, 2);
        sessionLimitPanel.add(this.sessionLimitUnits, 2, 0, 1, 1, 1, 1, 17, 0);
        groupInfo.add((Component)((Object)sessionLimitPanel), 0, Y++, 2, 1, 0, 0, 13, 2);
        contentPanel.addContent((JComponent)((Object)groupInfo), null);
        groupInfo = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        Y = 0;
        groupInfo.add(this.fpsLimitCheckBox.getRootComponent(), 0, Y++, 4, 1, 1, 0, 17, 2);
        ColorPropagatingGBPanel fpsLimitPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        fpsLimitPanel.add((Component)this.fpsSlider.getRootComponent(), 0, 0, 1, 1, 1, 0, 17, 0);
        groupInfo.add((Component)((Object)fpsLimitPanel), 0, Y++, 4, 1, 0, 0, 17, 2);
        contentPanel.addContent((JComponent)((Object)groupInfo), null);
        contentPanel.addVerticalFiller();
        contentPanel.setBackgroundColours();
    }

    @Override
    public void checkEnabled() {
        this.groupAuthPanel.getRootComponent().setEnabled(this.selectedGroup != null);
        if (this.selectedGroup != null) {
            this.groupNameField.setEnabled(this.selectedGroup != null);
        }
        this.groupHostname.setEnabled(this.selectedGroup != null);
        this.sgServiceField.setEnabled(this.selectedGroup != null);
        this.addVariableButton.setEnabled(this.selectedGroup != null);
        this.permissionsUI.checkEnabled(this.selectedGroup);
        this.allowAnonymousLoginsCheckBox.setEnabled(this.selectedGroup != null);
        this.groupCustomerFilters.setEnabled(this.selectedGroup != null);
        this.groupMachineFilters.setEnabled(this.selectedGroup != null);
        this.shSessionLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.sgSessionLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.fileTransferLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.speedLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.fpsLimitCheckBox.setEnabled(this.selectedGroup != null);
        this.sessionTimeoutCheckBox.setEnabled(this.selectedGroup != null);
        this.groupLimitFileTransferLabel.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.groupLimitFileTransferTextField.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.groupLimitUnitBox.setEnabled(this.selectedGroup != null && this.fileTransferLimitCheckBox.isSelected());
        this.inactivityTimeoutPanel.setEnabled(this.selectedGroup != null && this.sessionTimeoutCheckBox.isSelected());
        this.groupMaxShSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.userMaxShSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.groupMaxShSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.userMaxShSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isShConcurrencyLimited());
        this.groupMaxSgSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.userMaxSgSessions.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.groupMaxSgSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        this.userMaxSgSessionsT.setEnabled(this.selectedGroup != null && this.selectedGroup.isSgConcurrencyLimited());
        if (this.selectedGroup != null) {
            this.shSessionLimitCheckBox.setEnabled(this.selectedGroup.getAssociatedAppProfileID() == null);
        }
        this.sessionLimitTextField.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.sessionLimitLabel.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.sessionLimitUnits.setEnabled(this.selectedGroup != null && this.selectedGroup.isSessionLimited());
        this.fpsSlider.setEnabled(this.selectedGroup != null && this.selectedGroup.isFPSLimited());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.groupList.getList())) {
            this.loadSelection();
            this.checkEnabled();
            this.contentChanged(this.checkIfValid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSelection() {
        block30: {
            this.saveListener.disableSaves();
            this.loading = true;
            try {
                this.selectedGroup = (TechGroup)this.groupList.getList().getSelectedValue();
                this.groupInfoPanel.setHasContents(this.selectedGroup != null);
                if (this.selectedGroup == null) break block30;
                System.out.println("[AdminGroups] Selected group " + this.selectedGroup + " (" + this.selectedGroup.getAssociatedAppProfileID() + ")");
                try {
                    if (this.selectedGroup.getAssociatedAppProfileID() != null) {
                        System.out.println("[AdminGroups] Removing filtering tabs");
                        this.removeFilteringTabs();
                        this.groupNameField.setVisible(false);
                        this.groupNameLabel.setVisible(false);
                    } else {
                        System.out.println("[AdminGroups] Adding filtering tabs");
                        this.addFilteringTabs();
                        this.groupNameField.setVisible(true);
                        this.groupNameLabel.setVisible(true);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                this.groupNameField.setText(this.selectedGroup.getName());
                if (this.selectedGroup.getHostname() != null && this.selectedGroup.getHostname().length() > 0) {
                    this.groupHostname.setText(this.selectedGroup.getHostname());
                } else {
                    this.groupHostname.clear();
                }
                if (this.selectedGroup.getDefaultSGServiceName() != null && this.selectedGroup.getDefaultSGServiceName().length() > 0) {
                    this.sgServiceField.setText(this.selectedGroup.getDefaultSGServiceName());
                } else {
                    this.sgServiceField.clear();
                }
                this.permissionsUI.load(this.selectedGroup);
                this.allowAnonymousLoginsCheckBox.setSelected(this.selectedGroup.allowAnonymousLogins());
                this.groupAuthPanel.setPasswordName(this.selectedGroup.getName());
                this.groupAuthPanel.setUseLDAP(this.selectedGroup.isLDAP());
                this.groupAuthPanel.setLDAPProperties(this.selectedGroup.getLDAPProperties());
                this.groupAuthPanel.setUseRadius(this.selectedGroup.isRadius());
                this.groupAuthPanel.setUseAppAuthentication(this.selectedGroup.isMultiTierApp());
                this.groupAuthPanel.setUseEmailAuthentication(this.selectedGroup.isMultiTierEmail());
                this.groupAuthPanel.multiTierConfig.setTwoTierSettings(this.selectedGroup.getTwoTierCodeLength(), this.selectedGroup.getTwoTierSubject(), this.selectedGroup.getTwoTierBody());
                this.groupAuthPanel.multiTierConfig.setRememberMachine(this.selectedGroup.getMultiTierRememberMachine());
                this.groupAuthPanel.setUsePassword(this.selectedGroup.isPassword());
                this.groupAuthPanel.password = this.selectedGroup.getPassword();
                this.groupAuthPanel.getRootComponent().setEnabled(this.groupAuthPanel.getRootComponent().isEnabled());
                this.groupAuthPanel.getRootComponent().repaint();
                this.groupCustomerFilters.setExistingFilters(this.selectedGroup.getCustomerFilters());
                SimpleMachineFilter machineFiltersSimple = this.selectedGroup.getMachineFilters().getSimpleMachineFilter();
                if (machineFiltersSimple != null) {
                    machineFiltersSimple.groundWith(this.model);
                }
                this.groupMachineFilters.setExistingFilters(this.selectedGroup.getMachineFilters());
                this.shSessionLimitCheckBox.setSelected(this.selectedGroup.isShConcurrencyLimited());
                if (this.selectedGroup.isShConcurrencyLimited()) {
                    if (this.selectedGroup.getMaxShGroupConcurrency() == -1) {
                        this.groupMaxShSessionsT.setText(null);
                    } else {
                        this.groupMaxShSessionsT.setText("" + this.selectedGroup.getMaxShGroupConcurrency());
                    }
                    if (this.selectedGroup.getMaxShUserConcurrency() == -1) {
                        this.userMaxShSessionsT.setText(null);
                    } else {
                        this.userMaxShSessionsT.setText("" + this.selectedGroup.getMaxShUserConcurrency());
                    }
                } else {
                    this.groupMaxShSessionsT.setText("");
                    this.userMaxShSessionsT.setText("");
                }
                this.sgSessionLimitCheckBox.setSelected(this.selectedGroup.isSgConcurrencyLimited());
                if (this.selectedGroup.isSgConcurrencyLimited()) {
                    if (this.selectedGroup.getMaxSgGroupConcurrency() == -1) {
                        this.groupMaxSgSessionsT.setText(null);
                    } else {
                        this.groupMaxSgSessionsT.setText("" + this.selectedGroup.getMaxSgGroupConcurrency());
                    }
                    if (this.selectedGroup.getMaxSgUserConcurrency() == -1) {
                        this.userMaxSgSessionsT.setText(null);
                    } else {
                        this.userMaxSgSessionsT.setText("" + this.selectedGroup.getMaxSgUserConcurrency());
                    }
                } else {
                    this.groupMaxSgSessionsT.setText("");
                    this.userMaxSgSessionsT.setText("");
                }
                this.sessionTimeoutCheckBox.setSelected(this.selectedGroup.getInactivityTimeout() > 0L);
                this.inactivityTimeoutPanel.setTimeout(this.selectedGroup.getInactivityTimeout());
                this.fileTransferLimitCheckBox.setSelected(this.selectedGroup.isMaxFileTransferSizeLimited());
                if (this.selectedGroup.isMaxFileTransferSizeLimited()) {
                    long maxFileSize = this.selectedGroup.getMaxFileTransferSize();
                    if (maxFileSize % 0x100000L == 0L) {
                        this.groupLimitUnitBox.setSelectedIndex(2);
                        maxFileSize /= 0x100000L;
                    } else if (maxFileSize % 1024L == 0L) {
                        this.groupLimitUnitBox.setSelectedIndex(1);
                        maxFileSize /= 1024L;
                    } else {
                        this.groupLimitUnitBox.setSelectedIndex(0);
                    }
                    this.groupLimitFileTransferTextField.setText(String.valueOf(maxFileSize));
                } else {
                    this.groupLimitFileTransferTextField.setText("");
                }
                this.speedLimitCheckBox.setSelected(this.selectedGroup.isSessionLimited());
                this.sessionLimitTextField.setText(this.selectedGroup.getSessionLimitKbps() + "");
                this.fpsLimitCheckBox.setSelected(this.selectedGroup.isFPSLimited());
                this.fpsSlider.setAppropriateDelay(this.selectedGroup.getFPSDelay());
                this.groupSessions.repaint();
            }
            finally {
                this.loading = false;
                this.saveListener.enableSaves();
            }
        }
    }

    @Override
    public void saveComplete(ServerConfig config) {
        this.groupAuthPanel.setConfiguredServers(config.ldapEnable, config.radiusEnable, config.emailSettingsEnabled);
    }

    @Override
    protected ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.selectedGroup != null) {
            int tmp;
            if (this.groupNameField.getText().length() == 0) {
                list.add(this.groupNameField);
            } else {
                this.groupNameField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.selectedGroup.isSessionLimited()) {
                try {
                    if (this.sessionLimitTextField.getText().length() > 0 && (tmp = Integer.parseInt(this.sessionLimitTextField.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative not allowed");
                    }
                    this.sessionLimitTextField.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.sessionLimitTextField);
                }
            }
            if (this.selectedGroup.isShConcurrencyLimited()) {
                try {
                    if (this.groupMaxShSessionsT.getText().length() > 0 && (tmp = Integer.parseInt(this.groupMaxShSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.groupMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.groupMaxShSessionsT);
                }
                try {
                    int tmp2;
                    if (this.userMaxShSessionsT.getText().length() > 0 && (tmp2 = Integer.parseInt(this.userMaxShSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.userMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.userMaxShSessionsT);
                }
                if (this.userMaxShSessionsT.getText().length() == 0 && this.groupMaxShSessionsT.getText().length() == 0) {
                    list.add(this.userMaxShSessionsT);
                    list.add(this.groupMaxShSessionsT);
                }
            } else {
                this.groupMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
                this.userMaxShSessionsT.setBorder(this.defaultTextFieldBorder);
            }
            if (this.selectedGroup.isSgConcurrencyLimited()) {
                try {
                    int tmp3;
                    if (this.groupMaxSgSessionsT.getText().length() > 0 && (tmp3 = Integer.parseInt(this.groupMaxSgSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.groupMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.groupMaxSgSessionsT);
                }
                try {
                    int tmp4;
                    if (this.userMaxSgSessionsT.getText().length() > 0 && (tmp4 = Integer.parseInt(this.userMaxSgSessionsT.getText().trim())) < 0) {
                        throw new NumberFormatException("Negative numbers not allowed");
                    }
                    this.userMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                }
                catch (NumberFormatException x) {
                    list.add(this.userMaxSgSessionsT);
                }
                if (this.userMaxSgSessionsT.getText().length() == 0 && this.groupMaxSgSessionsT.getText().length() == 0) {
                    list.add(this.userMaxSgSessionsT);
                    list.add(this.groupMaxSgSessionsT);
                }
            } else {
                this.groupMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
                this.userMaxSgSessionsT.setBorder(this.defaultTextFieldBorder);
            }
        } else {
            this.groupNameField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    class GroupList
    extends IconedAbstractListUI<TechGroup> {
        public GroupList(ResourceBundle lang, TechGroup[] initialList) {
            super(lang, initialList, false, true);
        }

        @Override
        protected boolean isHorizontal() {
            return false;
        }

        @Override
        protected Icon getIconForObject(TechGroup element) {
            return ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16");
        }

        @Override
        protected TechGroup getNewObject() {
            int id = ServerConfig.get().getTechnicianGroupID();
            TechGroup group = new TechGroup(id, "New Group");
            group.setTwoTierEmail(Templates.twoTierActivationSubject, Templates.twoTierActivationContent);
            return group;
        }

        @Override
        protected boolean elementRemoved(TechGroup group) {
            if (group.getAssociatedAppProfileID() != null) {
                return !TechUi.INSTANCE.removeProfileByID(group.getAssociatedAppProfileID());
            }
            return true;
        }

        private Icon getIconFor(TechGroup group, boolean small) {
            if (small) {
                if (group.getAssociatedAppProfileID() != null) {
                    return ImageLoader.getImageIcon((String)"images/svg/logos/simplehelp-blue.svg,16");
                }
                return ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16");
            }
            if (group.getAssociatedAppProfileID() != null) {
                return ImageLoader.getImageIcon((String)"images/svg/logos/simplehelp-blue.svg,48");
            }
            return ImageLoader.getImageIcon((String)"images/svg/users/group.svg,48");
        }

        @Override
        public boolean confirmDelete(TechGroup groupToDelete) {
            return SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminGroups.this.rootComponent), (String)(Language.get("DELETE_GROUP_M", groupToDelete.toString()) + (groupToDelete.getAssociatedAppProfileID() != null ? "<BR><BR>" + Language.get("DELETE_GROUP_M_2") : "")), (String)Language.get("DELETE_GROUP_T"), (Icon)ImageLoader.getOverlayedIcon((Icon)this.getIconFor(groupToDelete, false), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16")), (String)Language.get("DELETE"));
        }

        @Override
        protected void listChanged() {
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.saveListener.techGroupChanged();
        }

        @Override
        protected void elementAdded(TechGroup newObject) {
            AdminGroups.this.groupTabs.setSelectedIndex(0);
            AdminGroups.this.groupNameField.requestFocusInWindow();
            AdminGroups.this.groupNameField.selectAll();
        }

        @Override
        protected ListCellRenderer getCellRenderer() {
            return new TechGroupRenderer();
        }

        class TechGroupRenderer
        extends DefaultListCellRenderer {
            TechGroupRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                TechGroup group = (TechGroup)value;
                label.setIcon(GroupList.this.getIconFor(group, true));
                return label;
            }
        }
    }

    class SaveFilterListener
    implements FilterChangeListener {
        private boolean isCustomer = false;

        public SaveFilterListener(boolean isCustomer) {
            this.isCustomer = isCustomer;
        }

        @Override
        public void filterChanged() {
            if (this.isCustomer) {
                Filter[] filters = AdminGroups.this.groupCustomerFilters.getFilters();
                CustomerFilter[] newFilters = new CustomerFilter[filters.length];
                for (int i = 0; i < newFilters.length; ++i) {
                    newFilters[i] = (CustomerFilter)filters[i];
                }
                AdminGroups.this.selectedGroup.setCustomerFilters(newFilters);
            } else {
                AdminGroups.this.selectedGroup.getMachineFilters().setTo(AdminGroups.this.groupMachineFilters.getMachineFilter());
            }
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.forceSave = true;
            AdminGroups.this.saveListener.filtersChanged();
        }
    }

    class ValidationListener
    implements KeyListener,
    ActionListener,
    ChangeListener {
        ValidationListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKeyPress(e.getSource());
        }

        public void processKeyPress(Object source) {
            if (source.equals(AdminGroups.this.groupNameField)) {
                AdminGroups.this.selectedGroup.setName(AdminGroups.this.groupNameField.getText());
                AdminGroups.this.groupList.repaint();
            } else if (source.equals(AdminGroups.this.groupHostname)) {
                AdminGroups.this.selectedGroup.setHostname(AdminGroups.this.groupHostname.getText());
            } else if (source.equals(AdminGroups.this.sgServiceField)) {
                AdminGroups.this.selectedGroup.setDefaultSGServiceName(AdminGroups.this.sgServiceField.getText());
            } else if (source.equals(AdminGroups.this.groupLimitFileTransferTextField)) {
                this.setGroupFileTransferLimit();
            } else if (source.equals(AdminGroups.this.groupMaxShSessionsT) || source.equals(AdminGroups.this.userMaxShSessionsT) || source.equals(AdminGroups.this.groupMaxSgSessionsT) || source.equals(AdminGroups.this.userMaxSgSessionsT)) {
                this.saveLimitSettings();
            } else if (source.equals(AdminGroups.this.sessionLimitTextField)) {
                this.setSessionSpeed();
            } else if (AdminGroups.this.inactivityTimeoutPanel.getTextField() == source) {
                this.saveLimitSettings();
            } else {
                AdminGroups.this.permissionsUI.handleKeyPress(AdminGroups.this.selectedGroup, source);
            }
            AdminGroups.this.forceSave = true;
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.saveListener.techGroupChanged();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void saveLimitSettings() {
            block21: {
                block20: {
                    if (AdminGroups.this.shSessionLimitCheckBox.isSelected()) {
                        try {
                            if (AdminGroups.this.groupMaxShSessionsT.getText().trim().length() == 0) {
                                AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(0);
                            } else {
                                AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(Integer.parseInt(AdminGroups.this.groupMaxShSessionsT.getText().trim()));
                            }
                        }
                        catch (NumberFormatException x) {
                            AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(100);
                            AdminGroups.this.groupMaxShSessionsT.setText(AdminGroups.this.selectedGroup.getMaxShGroupConcurrency() + "");
                        }
                        try {
                            if (AdminGroups.this.userMaxShSessionsT.getText().trim().length() == 0) {
                                AdminGroups.this.selectedGroup.setMaxShUserConcurrency(0);
                                break block20;
                            }
                            AdminGroups.this.selectedGroup.setMaxShUserConcurrency(Integer.parseInt(AdminGroups.this.userMaxShSessionsT.getText().trim()));
                        }
                        catch (NumberFormatException x) {
                            AdminGroups.this.selectedGroup.setMaxShUserConcurrency(10);
                            AdminGroups.this.userMaxShSessionsT.setText(AdminGroups.this.selectedGroup.getMaxShUserConcurrency() + "");
                        }
                    } else {
                        AdminGroups.this.selectedGroup.setMaxShGroupConcurrency(-1);
                        AdminGroups.this.selectedGroup.setMaxShUserConcurrency(-1);
                    }
                }
                if (AdminGroups.this.sessionTimeoutCheckBox.isSelected()) {
                    AdminGroups.this.selectedGroup.setInactivityTimeout(AdminGroups.this.inactivityTimeoutPanel.getTimeout());
                } else {
                    AdminGroups.this.selectedGroup.setInactivityTimeout(-1L * AdminGroups.this.inactivityTimeoutPanel.getTimeout());
                }
                if (AdminGroups.this.sgSessionLimitCheckBox.isSelected()) {
                    try {
                        if (AdminGroups.this.groupMaxSgSessionsT.getText().trim().length() == 0) {
                            AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(0);
                        } else {
                            AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(Integer.parseInt(AdminGroups.this.groupMaxSgSessionsT.getText().trim()));
                        }
                    }
                    catch (NumberFormatException x) {
                        AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(100);
                        AdminGroups.this.groupMaxSgSessionsT.setText(AdminGroups.this.selectedGroup.getMaxSgGroupConcurrency() + "");
                    }
                    try {
                        if (AdminGroups.this.userMaxSgSessionsT.getText().trim().length() == 0) {
                            AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(0);
                            break block21;
                        }
                        AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(Integer.parseInt(AdminGroups.this.userMaxSgSessionsT.getText().trim()));
                    }
                    catch (NumberFormatException x) {
                        AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(10);
                        AdminGroups.this.userMaxSgSessionsT.setText(AdminGroups.this.selectedGroup.getMaxSgUserConcurrency() + "");
                    }
                } else {
                    AdminGroups.this.selectedGroup.setMaxSgGroupConcurrency(-1);
                    AdminGroups.this.selectedGroup.setMaxSgUserConcurrency(-1);
                }
            }
        }

        public void setFPSLimit() {
            if (AdminGroups.this.fpsLimitCheckBox.isSelected()) {
                AdminGroups.this.selectedGroup.setFPSLimited(true);
                long delay = AdminGroups.this.fpsSlider.getAppropriateDelay();
                AdminGroups.this.selectedGroup.setFPSDelay(delay);
            } else {
                AdminGroups.this.selectedGroup.setFPSLimited(false);
            }
        }

        public void setSessionSpeed() {
            if (AdminGroups.this.speedLimitCheckBox.isSelected()) {
                AdminGroups.this.selectedGroup.setSessionLimited(true);
                if (AdminGroups.this.sessionLimitTextField.getText().length() > 0) {
                    try {
                        AdminGroups.this.selectedGroup.setSessionLimitKbps(Integer.parseInt(AdminGroups.this.sessionLimitTextField.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                AdminGroups.this.selectedGroup.setSessionLimited(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean requestSave = true;
            if (!AdminGroups.this.loading && e.getSource() == AdminGroups.this.groupLimitUnitBox) {
                this.setGroupFileTransferLimit();
            } else if (e.getSource().equals(AdminGroups.this.allowAnonymousLoginsCheckBox)) {
                AdminGroups.this.selectedGroup.setAllowAnonymousLogins(AdminGroups.this.allowAnonymousLoginsCheckBox.isSelected());
            } else if (e.getSource().equals(AdminGroups.this.shSessionLimitCheckBox.getCheckBoxComponent())) {
                this.saveLimitSettings();
            } else if (e.getSource() == AdminGroups.this.fileTransferLimitCheckBox.getCheckBoxComponent()) {
                this.setGroupFileTransferLimit();
            } else if (e.getSource().equals(AdminGroups.this.sgSessionLimitCheckBox.getCheckBoxComponent())) {
                this.saveLimitSettings();
            } else if (e.getSource().equals(AdminGroups.this.speedLimitCheckBox.getCheckBoxComponent())) {
                this.setSessionSpeed();
            } else if (e.getSource().equals(AdminGroups.this.fpsLimitCheckBox.getCheckBoxComponent())) {
                this.setFPSLimit();
            } else if (AdminGroups.this.inactivityTimeoutPanel.eventIsFromPanel(e) || e.getSource() == AdminGroups.this.sessionTimeoutCheckBox.getCheckBoxComponent()) {
                this.saveLimitSettings();
            } else {
                requestSave = AdminGroups.this.permissionsUI.actionPerformed(AdminGroups.this.selectedGroup, e);
            }
            if (requestSave) {
                AdminGroups.this.forceSave = true;
            }
            AdminGroups.this.checkEnabled();
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            if (requestSave) {
                AdminGroups.this.saveListener.techGroupChanged();
            }
        }

        private void setGroupFileTransferLimit() {
            if (AdminGroups.this.fileTransferLimitCheckBox.isSelected()) {
                long size = -1L;
                try {
                    size = Long.parseLong(AdminGroups.this.groupLimitFileTransferTextField.getText());
                    switch (AdminGroups.this.groupLimitUnitBox.getSelectedIndex()) {
                        case 1: {
                            size *= 1024L;
                            break;
                        }
                        case 2: {
                            size *= 0x100000L;
                            break;
                        }
                    }
                    AdminGroups.this.selectedGroup.setMaxFileTransferSize(size);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                AdminGroups.this.selectedGroup.setMaxFileTransferSize(-1L);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setFPSLimit();
            AdminGroups.this.forceSave = true;
            AdminGroups.this.contentChanged(AdminGroups.this.checkIfValid());
            AdminGroups.this.saveListener.techGroupChanged();
        }
    }

    class InsertVariableAction
    extends AbstractAction {
        private String id;

        public InsertVariableAction(String name, String id) {
            super(name);
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedVariable = "${" + this.id + "}";
            int pos = AdminGroups.this.sgServiceField.getCaretPosition();
            AdminGroups.this.sgServiceField.setText(AdminGroups.this.sgServiceField.getText().substring(0, pos) + selectedVariable + AdminGroups.this.sgServiceField.getText().substring(pos));
            AdminGroups.this.sgServiceField.setCaretPosition(pos + selectedVariable.length());
            AdminGroups.this.validationListener.processKeyPress(AdminGroups.this.sgServiceField);
        }
    }

    class AddVariableActionListener
    implements ActionListener {
        AddVariableActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] keys;
            if (AdminGroups.this.details != null) {
                keys = new String[AdminGroups.this.details.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = AdminGroups.this.details[i].getLabel();
                }
            } else {
                keys = new String[]{};
            }
            JPopupMenu menu = AdminGroups.this.getAddVariableMenu(keys);
            Rectangle bounds = AdminGroups.this.addVariableButton.getBounds();
            menu.show(AdminGroups.this.addVariableButton, -1, bounds.y + bounds.height);
        }
    }
}

