/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.simulation.steps;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStepConfigPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import utils.files.FileUtil;
import utils.message.Message;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class SessionsStep
implements SimulationStep {
    private static final int FPS_1 = 1000;
    private static final int FPS_7 = 142;
    private static final int FPS_22 = 45;
    private static final int FPS_MAX = 0;
    int count = 1;
    double mins = 1.0;
    double quitMins = 5.0;
    String match = "";
    int coldepth = 16;
    int fpsdelay = 45;
    int ttype = -1;
    int screenActivity;
    byte[] imageData;
    private static final int VERSION = 1;

    public int getPercentScreenChangePerSecond() {
        return this.screenActivity;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public int getColdepth() {
        return this.coldepth;
    }

    public int getFpsDelay() {
        return this.fpsdelay;
    }

    public int getTransportType() {
        return this.ttype;
    }

    public int getCount() {
        return this.count;
    }

    public double getQuitMins() {
        return this.quitMins;
    }

    public double getMins() {
        return this.mins;
    }

    public String getMatch() {
        return this.match;
    }

    @Override
    public String getTypeOverlayKeyNoSize() {
        return null;
    }

    @Override
    public String getTypeIconKeyNoSize() {
        return "images/svg/technology/screen.svg";
    }

    @Override
    public String getTypeNameKey() {
        return "STEP_SESSIONS_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "STEP_SESSIONS_DESC";
    }

    @Override
    public SimulationStepConfigPanel getTypeConfigurationPanel() {
        return new SimulationStepConfigPanel<SessionsStep>(this){
            JTextField countf;
            JTextField minsf;
            JTextField quitf;
            MessageTextField matchf;
            JComboBox colors;
            JComboBox updates;
            JComboBox types;
            JComboBox activity;
            JButton screen;

            @Override
            public JComponent getComponent() {
                GbPanel panel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
                int Y = 0;
                JLabel countl = new JLabel(Language.get("STEP_SESSIONS_COUNT"));
                panel.add((Component)countl, 0, Y, 1, 1, 100, 100, 13, 0);
                this.countf = new JTextField(8);
                panel.add((Component)this.countf, 1, Y, 1, 1, 100, 100, 17, 0);
                JLabel minsl = new JLabel(Language.get("STEP_SESSIONS_MINS"));
                panel.add((Component)minsl, 0, ++Y, 1, 1, 100, 100, 13, 0);
                this.minsf = new JTextField(8);
                panel.add((Component)this.minsf, 1, Y, 1, 1, 100, 100, 17, 0);
                JLabel quitl = new JLabel(Language.get("SESSION_STEP_QUIT"));
                panel.add((Component)quitl, 0, ++Y, 1, 1, 100, 100, 13, 0);
                this.quitf = new JTextField(8);
                panel.add((Component)this.quitf, 1, Y, 1, 1, 100, 100, 17, 0);
                JLabel matchl = new JLabel(Language.get("STEP_SESSIONS_MATCH"));
                panel.add((Component)matchl, 0, ++Y, 1, 1, 100, 100, 13, 0);
                this.matchf = new MessageTextField(20, Language.get("STEP_SESSIONS_EXAMPLE"), null){};
                panel.add((Component)this.matchf, 1, Y, 1, 1, 100, 100, 17, 2);
                JLabel activityl = new JLabel(Language.get("STEP_ACTIVITY"));
                panel.add((Component)activityl, 0, ++Y, 1, 1, 100, 100, 13, 0);
                this.activity = new JComboBox();
                this.activity.addItem(Language.get("STEP_ACTIVITY_1"));
                this.activity.addItem(Language.get("STEP_ACTIVITY_2"));
                this.activity.addItem(Language.get("STEP_ACTIVITY_3"));
                this.activity.addItem(Language.get("STEP_ACTIVITY_4"));
                this.activity.addItem(Language.get("STEP_ACTIVITY_5"));
                panel.add((Component)this.activity, 1, Y, 1, 1, 100, 100, 17, 0);
                JLabel screenl = new JLabel(Language.get("STEP_SESSIONS_SCREEN"));
                panel.add((Component)screenl, 0, ++Y, 1, 1, 100, 100, 13, 0);
                this.screen = new JButton();
                panel.add((Component)this.screen, 1, Y, 1, 1, 100, 100, 17, 0);
                ++Y;
                this.colors = new JComboBox();
                this.updates = new JComboBox();
                this.types = new JComboBox();
                this.colors.addItem(Language.get("COL_LOW"));
                this.colors.addItem(Language.get("COL_MEDIUM"));
                this.colors.addItem(Language.get("COL_HIGH"));
                this.colors.addItem(Language.get("COL_FULL"));
                this.updates.addItem(Language.get("UPDATES_MINIMAL"));
                this.updates.addItem(Language.get("UPDATES_LOW"));
                this.updates.addItem(Language.get("UPDATES_HIGH"));
                this.updates.addItem(Language.get("UPDATES_MAX"));
                this.types.addItem(Language.get("CONNTYPE_ANY"));
                this.types.addItem(Language.get("CONNTYPE_HTTP"));
                this.types.addItem(Language.get("CONNTYPE_TCP"));
                this.types.addItem(Language.get("CONNTYPE_SUDP"));
                this.types.addItem(Language.get("CONNTYPE_DTCP"));
                this.types.addItem(Language.get("CONNTYPE_DUDP"));
                this.colors.setSelectedIndex(3);
                this.updates.setSelectedIndex(3);
                this.types.setSelectedIndex(1);
                JLabel l_colors = new JLabel(Language.get("COLOR_FIDELITY"));
                JLabel l_updates = new JLabel(Language.get("UPDATE_RATE"));
                JLabel l_types = new JLabel(Language.get("CONNECTION_TYPE"));
                panel.add((Component)l_colors, 0, Y, 1, 1, 100, 100, 13, 0);
                panel.add((Component)this.colors, 1, Y, 1, 1, 100, 100, 17, 0);
                panel.add((Component)l_updates, 0, ++Y, 1, 1, 100, 100, 13, 0);
                panel.add((Component)this.updates, 1, Y, 1, 1, 100, 100, 17, 0);
                panel.add((Component)l_types, 0, ++Y, 1, 1, 100, 100, 13, 0);
                panel.add((Component)this.types, 1, Y, 1, 1, 100, 100, 17, 0);
                panel.add((Component)new JPanel(), 1, ++Y, 1, 1, 10000, 10000, 10, 1);
                SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.activity, this.colors, this.updates, this.types});
                this.countf.setText(SessionsStep.this.count + "");
                this.minsf.setText(SessionsStep.this.mins + "");
                this.quitf.setText(SessionsStep.this.quitMins + "");
                this.matchf.setText(SessionsStep.this.match);
                if (SessionsStep.this.screenActivity == 0) {
                    this.activity.setSelectedIndex(2);
                } else if (SessionsStep.this.screenActivity <= 2) {
                    this.activity.setSelectedIndex(0);
                } else if (SessionsStep.this.screenActivity <= 5) {
                    this.activity.setSelectedIndex(1);
                } else if (SessionsStep.this.screenActivity <= 20) {
                    this.activity.setSelectedIndex(2);
                } else if (SessionsStep.this.screenActivity <= 40) {
                    this.activity.setSelectedIndex(3);
                } else if (SessionsStep.this.screenActivity <= 80) {
                    this.activity.setSelectedIndex(4);
                }
                this.screen.setIcon(SessionsStep.this.loadScreen(SessionsStep.this.imageData));
                GbPanel parent = panel;
                this.screen.addActionListener(new ActionListener((JComponent)parent){
                    final /* synthetic */ JComponent val$parent;
                    {
                        this.val$parent = jComponent;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File chosen = SafeJFileChooser.pickFile((Component)this.val$parent);
                        if (chosen != null) {
                            try {
                                SessionsStep.this.imageData = FileUtil.readFile((File)chosen);
                                screen.setIcon(SessionsStep.this.loadScreen(SessionsStep.this.imageData));
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                    }
                });
                if (SessionsStep.this.coldepth > 254) {
                    this.colors.setSelectedIndex(3);
                } else if (SessionsStep.this.coldepth > 9) {
                    this.colors.setSelectedIndex(2);
                } else if (SessionsStep.this.coldepth > 5) {
                    this.colors.setSelectedIndex(1);
                } else {
                    this.colors.setSelectedIndex(0);
                }
                if (SessionsStep.this.fpsdelay >= 1000) {
                    this.updates.setSelectedIndex(0);
                } else if (SessionsStep.this.fpsdelay < 5) {
                    this.updates.setSelectedIndex(3);
                } else if (SessionsStep.this.fpsdelay >= 142) {
                    this.updates.setSelectedIndex(1);
                } else {
                    this.updates.setSelectedIndex(2);
                }
                if (SessionsStep.this.ttype == -1) {
                    this.types.setSelectedIndex(0);
                } else if (SessionsStep.this.ttype == 4) {
                    this.types.setSelectedIndex(1);
                } else if (SessionsStep.this.ttype == 2) {
                    this.types.setSelectedIndex(2);
                } else if (SessionsStep.this.ttype == 1) {
                    this.types.setSelectedIndex(3);
                } else if (SessionsStep.this.ttype == 0) {
                    this.types.setSelectedIndex(4);
                } else if (SessionsStep.this.ttype == 5) {
                    this.types.setSelectedIndex(5);
                } else {
                    this.types.setSelectedIndex(0);
                }
                return panel;
            }

            @Override
            public void finishAndSave() {
                try {
                    int index;
                    SessionsStep.this.count = Integer.parseInt(this.countf.getText().trim());
                    SessionsStep.this.mins = Double.parseDouble(this.minsf.getText().trim());
                    SessionsStep.this.quitMins = Double.parseDouble(this.quitf.getText().trim());
                    SessionsStep.this.match = this.matchf.getText().trim();
                    if (!SessionsStep.this.match.startsWith("*")) {
                        SessionsStep.this.match = "*" + SessionsStep.this.match;
                    }
                    if (!SessionsStep.this.match.endsWith("*")) {
                        SessionsStep.this.match = SessionsStep.this.match + "*";
                    }
                    if ((index = this.activity.getSelectedIndex()) == 0) {
                        SessionsStep.this.screenActivity = 2;
                    } else if (index == 1) {
                        SessionsStep.this.screenActivity = 5;
                    } else if (index == 2) {
                        SessionsStep.this.screenActivity = 20;
                    } else if (index == 3) {
                        SessionsStep.this.screenActivity = 40;
                    } else if (index == 4) {
                        SessionsStep.this.screenActivity = 80;
                    }
                    index = this.colors.getSelectedIndex();
                    SessionsStep.this.coldepth = 16;
                    if (index == 0) {
                        SessionsStep.this.coldepth = 5;
                    } else if (index == 1) {
                        SessionsStep.this.coldepth = 9;
                    } else if (index == 2) {
                        SessionsStep.this.coldepth = 16;
                    } else if (index == 3) {
                        SessionsStep.this.coldepth = 255;
                    }
                    index = this.updates.getSelectedIndex();
                    SessionsStep.this.fpsdelay = 45;
                    if (index == 0) {
                        SessionsStep.this.fpsdelay = 1000;
                    } else if (index == 1) {
                        SessionsStep.this.fpsdelay = 142;
                    } else if (index == 2) {
                        SessionsStep.this.fpsdelay = 45;
                    } else if (index == 3) {
                        SessionsStep.this.fpsdelay = 0;
                    }
                    SessionsStep.this.ttype = 2;
                    index = this.types.getSelectedIndex();
                    if (index == 0) {
                        SessionsStep.this.ttype = -1;
                    } else if (index == 1) {
                        SessionsStep.this.ttype = 4;
                    } else if (index == 2) {
                        SessionsStep.this.ttype = 2;
                    } else if (index == 3) {
                        SessionsStep.this.ttype = 1;
                    } else if (index == 4) {
                        SessionsStep.this.ttype = 0;
                    } else if (index == 5) {
                        SessionsStep.this.ttype = 5;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
    }

    public Icon loadScreen(byte[] imageData) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            BufferedImage bimg = ImageHelper.scaleDownToFitInside((BufferedImage)ImageHelper.toBufferedImageARGB((Image)image), (int)192, (int)48);
            return new ImageIcon(bimg);
        }
        catch (Exception x) {
            return ImageLoader.getImageIcon((String)"images/svg/computing/file-upload.svg,48");
        }
    }

    @Override
    public String getSummary() {
        if (this.match.trim().length() > 0) {
            return Language.get("STEP_SESSIONS_SUMMARY_SPECIFIC", this.count, this.match);
        }
        return Language.get("STEP_SESSIONS_SUMMARY_ALL", this.count);
    }

    @Override
    public Message toMessage() {
        Message m = new Message(2);
        m.append(1);
        m.append(this.count);
        m.append(this.mins);
        m.append(this.match);
        m.append(this.quitMins);
        m.append(this.coldepth);
        m.append(this.fpsdelay);
        m.append(this.ttype);
        m.append(this.imageData);
        m.append(this.screenActivity);
        return m;
    }

    public static SessionsStep fromMessage(Message m) {
        SessionsStep ws = new SessionsStep();
        int version = m.getNextInt();
        ws.count = m.getNextInt();
        ws.mins = m.getNextDouble();
        ws.match = m.getNextString();
        ws.quitMins = m.getNextDouble();
        ws.coldepth = m.getNextInt();
        ws.fpsdelay = m.getNextInt();
        ws.ttype = m.getNextInt();
        ws.imageData = m.getNextByteArray();
        ws.screenActivity = m.getNextInt();
        return ws;
    }

    public static void main(String[] args) {
        SessionsStep step = new SessionsStep();
        step.count = -100;
        step.mins = -101.0;
        step.quitMins = -102.0;
        step.coldepth = -103;
        step.fpsdelay = -104;
        step.ttype = -105;
        step.screenActivity = -106;
        step.match = "*matchy matchertons*";
        step = SessionsStep.fromMessage(step.toMessage());
        System.out.println(step.count);
        System.out.println(step.mins);
        System.out.println(step.quitMins);
        System.out.println(step.coldepth);
        System.out.println(step.fpsdelay);
        System.out.println(step.ttype);
        System.out.println(step.screenActivity);
        System.out.println(step.match);
    }
}

