/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.simulation;

import bcutil.BCUtil;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.steps.SessionsStep;
import com.aem.shelp.tech.admin.subsections.simulation.steps.WaitStep;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import utils.message.Message;

public class Simulation {
    public static String DIR = "simulations";
    public static final int STEP_WAIT = 1;
    public static final int STEP_SESSIONS = 2;
    public static final String PROP_SIM_STEP = "Simulation.Step";
    public static final String MARK_SIM_FAILED = "MARK_SIM_FAILED";
    public static final String MARK_SIM_RUNNING = "MARK_SIM_RUNNING";
    public static final String MARK_SIM_COMPLETE = "MARK_SIM_COMPLETE";
    public static final String MARK_SIM_NOTE = "MARK_SIM_NOTE";
    public static final String MARK_SIM_BANDWIDTH_SENT = "MARK_SIM_BANDWIDTH_SENT";
    public static final String MARK_SIM_BANDWIDTH_RECEIVED = "MARK_SIM_BANDWIDTH_RECEIVED";
    static ArrayList<SimulationStep> ALL_STEPS = new ArrayList();
    long id = BCUtil.getNextAbsID();
    String name = "New Simulation";
    DefaultListModel<SimulationStep> list = new DefaultListModel();

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefaultListModel<SimulationStep> getList() {
        return this.list;
    }

    public String toString() {
        return this.getName();
    }

    public static long getIdFromSerialisedSimulation(Message m) {
        return m.getAsLong(0);
    }

    public Message toMessage() {
        Object[] elems;
        Message sim = new Message();
        sim.append(this.id);
        Message meta = new Message();
        meta.append(this.name);
        sim.append(meta);
        for (Object o : elems = this.list.toArray()) {
            sim.append(((SimulationStep)o).toMessage());
        }
        return sim;
    }

    public static SimulationStep stepFromMessage(Message step) {
        int type = step.getType();
        if (type == 1) {
            return WaitStep.fromMessage(step);
        }
        if (type == 2) {
            return SessionsStep.fromMessage(step);
        }
        return null;
    }

    public static Simulation fromMessage(Message message) {
        Simulation sim = new Simulation();
        message.resetIndex();
        sim.id = message.getNextLong();
        Message meta = message.getNextMessage();
        sim.name = meta.getNextString();
        while (message.hasNext()) {
            Message step = message.getNextMessage();
            SimulationStep simStep = Simulation.stepFromMessage(step);
            if (simStep == null) continue;
            sim.getList().addElement(simStep);
        }
        return sim;
    }

    static {
        ALL_STEPS.add(new WaitStep());
        ALL_STEPS.add(new SessionsStep());
    }
}

