/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.simulation;

import aurelienribon.slidinglayout.SLSide;
import com.aem.StyleUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.simulation.EditListAction;
import com.aem.shelp.tech.admin.subsections.simulation.ListAction;
import com.aem.shelp.tech.admin.subsections.simulation.Simulation;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationRun;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStepConfigPanel;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.SaverUtil;
import utils.swing.SwingUtil;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.animated.slider.ChoiceItem;
import utils.swing.components.animated.slider.SlidingChoiceList;
import utils.swing.components.animated.slider.SlidingChoiceListener;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.jlist.DragDropReorderList;
import utils.swing.layout.AnimCardPanel;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.VariableLinePanel;

public class AdminSimulation
extends SubSection
implements ValidationKeyListener.ValidationInterface,
SaverUtil.SaveListener {
    private final Border listRendererBorder = SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5);
    private final OnDemandThreadPool savePool = new OnDemandThreadPool("AdminSimulationSaver", 1, 1, 5);
    private AnimCardPanel cardPanel;
    private SHSplitPane pane;
    private JList<Simulation> simulationsList;
    private DefaultListModel<Simulation> simulationsListModel;
    private JButton simAdd;
    private JButton simRemove;
    private JButton simRun;
    private JButton stepAdd;
    private JButton stepRemove;
    private static final Object running_LOCK = new Object();
    private final HashMap<Long, SimulationRun> running = new HashMap();
    private AnimCardPanel simPanel;
    private Simulation currentSimulation;
    private JLabel currentTitle;

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    @Override
    protected void initUI() {
        this.rootComponent.setLayout(new BorderLayout());
        this.cardPanel = new AnimCardPanel();
        this.rootComponent.add("Center", this.cardPanel);
        this.simulationsListModel = new DefaultListModel();
        this.simulationsList = new JList<Simulation>(this.simulationsListModel);
        this.simulationsList.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)29));
        this.simulationsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JComponent) {
                    ((JComponent)c).setBorder(AdminSimulation.this.listRendererBorder);
                }
                this.setIcon(ImageLoader.getImageIcon((String)"images/svg/computing/design-color_code-editor.svg,24"));
                return c;
            }
        });
        this.simulationsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Simulation sim;
                boolean isRunning = false;
                if (AdminSimulation.this.simulationsList.getSelectedIndices().length == 1) {
                    sim = (Simulation)AdminSimulation.this.simulationsList.getSelectedValue();
                    isRunning = AdminSimulation.this.isRunning(sim);
                }
                if (isRunning) {
                    AdminSimulation.this.stepAdd.setEnabled(false);
                    AdminSimulation.this.simRun.setEnabled(false);
                    AdminSimulation.this.simRemove.setEnabled(false);
                    AdminSimulation.this.stepRemove.setEnabled(false);
                } else if (AdminSimulation.this.simulationsList.getSelectedIndices().length == 0) {
                    AdminSimulation.this.currentSimulation = null;
                    AdminSimulation.this.stepAdd.setEnabled(false);
                    AdminSimulation.this.simRun.setEnabled(false);
                    AdminSimulation.this.simRemove.setEnabled(false);
                } else {
                    AdminSimulation.this.stepAdd.setEnabled(true);
                    AdminSimulation.this.simRun.setEnabled(AdminSimulation.this.simulationsList.getSelectedIndices().length == 1);
                    AdminSimulation.this.simRemove.setEnabled(true);
                }
                if (AdminSimulation.this.simulationsList.getSelectedIndex() < 0) {
                    AdminSimulation.this.showEmpty();
                } else {
                    sim = (Simulation)AdminSimulation.this.simulationsListModel.get(AdminSimulation.this.simulationsList.getSelectedIndex());
                    AdminSimulation.this.showSimulation(sim);
                }
            }
        });
        EditListAction edit = new EditListAction(){

            @Override
            protected void applyValueToModel(String value, ListModel model, int row) {
                DefaultListModel dlm = (DefaultListModel)model;
                Simulation sim = (Simulation)dlm.get(row);
                System.out.println("[AdminSimulation] Simulation renamed: " + value);
                sim.setName(value);
                if (AdminSimulation.this.currentTitle != null) {
                    AdminSimulation.this.currentTitle.setText(value);
                }
                AdminSimulation.this.saveSimulation(sim);
            }
        };
        new ListAction(this.simulationsList, edit);
        this.simPanel = new AnimCardPanel();
        this.pane = new SHSplitPane();
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.pane.setDividerLocation(0.25);
        BorderPanel bp = new BorderPanel();
        BorderPanel buttons = new BorderPanel();
        VariableLinePanel lp = new VariableLinePanel(1, true, false);
        VariableLinePanel wp = new VariableLinePanel(1, false, true);
        buttons.addCenter((JComponent)lp);
        buttons.addWest((JComponent)wp);
        StyleUtil.makeButtonPanel(lp);
        StyleUtil.makeButtonPanel(wp);
        this.simAdd = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        this.simRemove = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
        this.simAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Simulation sim = new Simulation();
                AdminSimulation.this.simulationsListModel.addElement(sim);
                AdminSimulation.this.showSimulation(sim);
            }
        });
        lp.add((Component)this.simAdd);
        this.simRemove.addActionListener(new TrashAction());
        wp.add((Component)this.simRemove);
        JScrollPane sp = new JScrollPane(this.simulationsList);
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        bp.addNorth((JComponent)buttons);
        bp.addCenter((JComponent)sp);
        this.pane.setLeftComponent((Component)bp);
        bp = new BorderPanel();
        buttons = new BorderPanel();
        lp = new VariableLinePanel(1, false, true);
        VariableLinePanel ep = new VariableLinePanel(1, true, false);
        buttons.addCenter((JComponent)lp);
        buttons.addEast((JComponent)ep);
        StyleUtil.makeButtonPanel(lp);
        StyleUtil.makeButtonPanel(ep);
        this.simRun = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/play.svg,16"));
        this.stepAdd = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        this.stepRemove = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
        this.simRun.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Simulation sim = (Simulation)AdminSimulation.this.simulationsList.getSelectedValue();
                if (sim != null) {
                    SimulationRun run = new SimulationRun(AdminSimulation.this, sim);
                    AdminSimulation.this.stepAdd.setEnabled(false);
                    AdminSimulation.this.simRun.setEnabled(false);
                    AdminSimulation.this.stepRemove.setEnabled(false);
                    Object object = running_LOCK;
                    synchronized (object) {
                        AdminSimulation.this.running.put(sim.getId(), run);
                    }
                    AdminSimulation.this.showSimulation(sim);
                }
            }
        });
        this.stepAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<ChoiceItem> list = new ArrayList<ChoiceItem>();
                for (SimulationStep step : Simulation.ALL_STEPS) {
                    list.add(AdminSimulation.this.getChoiceItem(step));
                }
                SlidingChoiceList choiceList = new SlidingChoiceList(list);
                choiceList.setSlidingChoiceListener(new SlidingChoiceListener(){

                    @Override
                    public void transitionedTo(ChoiceItem item) {
                        SimulationStep step = (SimulationStep)item.getUserObject();
                        AdminSimulation.this.currentSimulation.getList().addElement(step);
                        AdminSimulation.this.showCancelAddButton(step);
                        AdminSimulation.this.configureStep(step);
                    }
                });
                AdminSimulation.this.showCancelConfigureButton();
                AdminSimulation.this.simPanel.showCard(choiceList.getRootComponent(), SLSide.RIGHT);
            }
        });
        lp.add((Component)this.stepAdd);
        lp.add((Component)this.simRun);
        ep.add((Component)this.stepRemove);
        bp.addNorth((JComponent)buttons);
        bp.addCenter((JComponent)this.simPanel);
        this.pane.setRightComponent((Component)bp);
        this.cardPanel.showInstantCard(this.pane);
        this.simRemove.setEnabled(false);
        this.stepAdd.setEnabled(false);
        this.simRun.setEnabled(false);
        this.stepRemove.setEnabled(false);
        this.showEmpty();
    }

    @Override
    public void performSave() {
    }

    private void configureStep(SimulationStep step) {
        BorderPanel bp = new BorderPanel();
        VariableLinePanel buttons = new VariableLinePanel(1, true, false);
        StyleUtil.makeButtonPanel(buttons);
        JButton finished = new JButton(Language.get("FINISH"));
        buttons.add((Component)finished);
        final SimulationStepConfigPanel panel = step.getTypeConfigurationPanel();
        finished.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.finishAndSave();
                AdminSimulation.this.showSimulation(AdminSimulation.this.currentSimulation, SLSide.LEFT);
                AdminSimulation.this.saveSimulation(AdminSimulation.this.currentSimulation);
            }
        });
        bp.addSouth((JComponent)buttons);
        bp.addCenter((JComponent)((Object)panel));
        this.simPanel.showCard((JComponent)bp, SLSide.RIGHT);
    }

    private void showTrashButton(Simulation sim, SimulationList list) {
        SwingUtil.removeAllActionListeners((JButton)this.stepRemove);
        this.stepRemove.addActionListener(new StepTrashAction(sim, list));
        this.stepRemove.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
        this.stepRemove.setEnabled(list.getSelectedCount() > 0);
    }

    private void showCancelAddButton(final SimulationStep step) {
        SwingUtil.removeAllActionListeners((JButton)this.stepRemove);
        this.stepRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminSimulation.this.currentSimulation.getList().removeElement(step);
                AdminSimulation.this.showSimulation(AdminSimulation.this.currentSimulation);
            }
        });
        this.stepRemove.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.stepRemove.setEnabled(true);
    }

    private void showCancelConfigureButton() {
        SwingUtil.removeAllActionListeners((JButton)this.stepRemove);
        this.stepRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminSimulation.this.showSimulation(AdminSimulation.this.currentSimulation);
            }
        });
        this.stepRemove.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.stepRemove.setEnabled(true);
    }

    private ChoiceItem getChoiceItem(SimulationStep step) {
        Icon icon = step.getTypeOverlayKeyNoSize() != null ? ImageLoader.getImageIcon((String)Icons.overlay(step.getTypeIconKeyNoSize() + ",48", step.getTypeOverlayKeyNoSize() + ",24")) : ImageLoader.getImageIcon((String)(step.getTypeIconKeyNoSize() + ",48"));
        ChoiceItem cc = new ChoiceItem(Language.get(step.getTypeNameKey()), Language.get(step.getTypeDescKey()), null, icon, (JComponent)((Object)step.getTypeConfigurationPanel()));
        cc.setUserObject(step);
        return cc;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SIMULATION_TAB");
    }

    public void licenseChanged() {
        if (AdminPanel.LOADED_LICENSES.isVersion2Enterprise() || TrialUtils.amTriallingEnt()) {
            this.cardPanel.showInstantCard(this.pane);
        } else {
            JPanel flow = new JPanel();
            flow.setLayout((LayoutManager)new ScaledFlowLayout(1));
            VariableLinePanel lines = new VariableLinePanel(0, true, true);
            flow.add((Component)lines);
            JLabel noent = new JLabel(Language.get("ENTERPRISE_NO"), 0);
            JButton more = new JButton(Language.get("MORE_DETAILS"));
            more.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrialUtils.entUpgradeRequestPopup(SwingUtil.getRootPaneContainer((Component)AdminSimulation.this.rootComponent), AdminSimulation.this.rootComponent, AdminSimulation.this.techClient);
                }
            });
            lines.add((Component)noent);
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new ScaledFlowLayout());
            panel.add(more);
            lines.add((Component)panel);
            this.cardPanel.showInstantCard(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning(Simulation sim) {
        if (sim == null) {
            return false;
        }
        Object object = running_LOCK;
        synchronized (object) {
            SimulationRun run = this.running.get(sim.getId());
            return run != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedRunning(final Simulation sim) {
        System.out.println("[AdminSimulation] Simulation finished - " + sim);
        if (sim == null) {
            return;
        }
        Object object = running_LOCK;
        synchronized (object) {
            this.running.remove(sim.getId());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sim == AdminSimulation.this.currentSimulation) {
                    AdminSimulation.this.stepAdd.setEnabled(true);
                    AdminSimulation.this.simRun.setEnabled(true);
                    AdminSimulation.this.stepRemove.setEnabled(true);
                }
                AdminSimulation.this.showSimulation(sim);
            }
        });
    }

    private void showSimulation(Simulation sim) {
        this.showSimulation(sim, SLSide.RIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSimulation(Simulation sim, SLSide side) {
        boolean doTransition = sim != this.currentSimulation;
        this.currentSimulation = sim;
        if (sim == null) {
            this.showEmpty();
        } else if (this.isRunning(sim)) {
            Object object = running_LOCK;
            synchronized (object) {
                SimulationRun run = this.running.get(sim.getId());
                this.simPanel.showCard(run.getPanel(), side);
            }
        } else {
            System.out.println("[AdminSimulation] Showing simulation: " + sim);
            SimulationList simulationList = new SimulationList(sim);
            this.showTrashButton(sim, simulationList);
            BorderPanel titledPanel = new BorderPanel();
            this.currentTitle = new JLabel();
            titledPanel.addNorth(StyleUtil.makeTitlePanel("images/svg/computing/design-color_code-editor.svg", sim.getName(), this.currentTitle));
            titledPanel.addCenter((JComponent)((Object)simulationList));
            if (doTransition) {
                this.simPanel.showCard((JComponent)titledPanel, side);
            } else {
                this.simPanel.showInstantCard((JComponent)titledPanel);
            }
        }
    }

    private void showEmpty() {
        NoContentsInfoPanel nop = new NoContentsInfoPanel(Language.get("NO_SIMULATIONS"), ImageLoader.getImageIconDisabled((String)"images/svg/computing/design-color_code-editor.svg,48"), false);
        nop.setContentsPanel(new JPanel());
        nop.setHasContents(false);
        this.simPanel.showInstantCard(nop);
    }

    private void loadNow() {
        try {
            System.out.println("[AdminSimulation] Fetching all simulations");
            ArrayList<Simulation> list = this.techClient.getAllSimulations();
            System.out.println("[AdminSimulation] Fetched " + list.size() + " simulations");
            this.simulationsListModel = new DefaultListModel();
            for (Simulation sim : list) {
                this.simulationsListModel.addElement(sim);
            }
            this.simulationsList.setModel(this.simulationsListModel);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public void checkEnabled() {
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        this.loadNow();
    }

    private void saveSimulation(final Simulation sim) {
        this.savePool.runAsync(new Runnable(){

            @Override
            public void run() {
                System.out.println("[AdminSimulation] Saving Simulation: " + sim.getName());
                try {
                    AdminSimulation.this.techClient.saveSimulation(sim);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
    }

    class SimulationList
    extends BorderPanel {
        final Simulation listSim;
        JList list;

        public SimulationList(Simulation sim) {
            this.listSim = sim;
            this.initUI();
        }

        public int getSelectedCount() {
            return this.list.getSelectedIndices().length;
        }

        public void deleteSelected() {
            List values = this.list.getSelectedValuesList();
            for (Object value : values) {
                this.listSim.getList().removeElement(value);
            }
        }

        private void initUI() {
            final JButton edit = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
            final DragDropReorderList list = new DragDropReorderList(this.listSim.getList()){

                @Override
                public void reorderRequested(int index, int targetIndex) {
                    if (index == targetIndex) {
                        return;
                    }
                    SimulationStep step = SimulationList.this.listSim.getList().get(index);
                    SimulationList.this.listSim.getList().remove(index);
                    if (index < targetIndex) {
                        --targetIndex;
                    }
                    SimulationList.this.listSim.getList().insertElementAt(step, targetIndex);
                    AdminSimulation.this.saveSimulation(SimulationList.this.listSim);
                }
            };
            list.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)29));
            this.list = list;
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (list.getSelectedIndices().length == 0) {
                        AdminSimulation.this.stepRemove.setEnabled(false);
                    } else {
                        AdminSimulation.this.stepRemove.setEnabled(true);
                    }
                }
            });
            final Action action = new Action(){

                @Override
                public Object getValue(String key) {
                    return null;
                }

                @Override
                public void putValue(String key, Object value) {
                }

                @Override
                public void setEnabled(boolean b) {
                }

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimulationStep step = (SimulationStep)list.getSelectedValue();
                    AdminSimulation.this.showCancelConfigureButton();
                    AdminSimulation.this.configureStep(step);
                }
            };
            new ListAction(list, action);
            list.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    int width = list.getWidth();
                    if (e.getX() > width - (edit.getWidth() + 5)) {
                        action.actionPerformed(null);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            final VariableLinePanel editp = new VariableLinePanel(0, true, true);
            editp.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5));
            editp.add((Component)edit);
            list.setCellRenderer(new DefaultListCellRenderer(){
                final BorderPanel bp = new BorderPanel();

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    SimulationStep step = (SimulationStep)value;
                    Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    editp.setBackground(c.getBackground());
                    editp.setOpaque(true);
                    Icon icon = step.getTypeOverlayKeyNoSize() != null ? ImageLoader.getImageIcon((String)Icons.overlay(step.getTypeIconKeyNoSize() + ",24", step.getTypeOverlayKeyNoSize() + ",16")) : ImageLoader.getImageIcon((String)(step.getTypeIconKeyNoSize() + ",24"));
                    this.setIcon(icon);
                    this.setText(step.getSummary());
                    this.bp.removeAll();
                    this.bp.addCenter((JComponent)this);
                    if (isSelected || cellHasFocus) {
                        this.bp.addEast((JComponent)editp);
                    }
                    if (c instanceof JComponent) {
                        ((JComponent)c).setBorder(AdminSimulation.this.listRendererBorder);
                    }
                    return this.bp;
                }
            });
            JScrollPane pane = new JScrollPane(list);
            pane.setBorder(SHBorderFactory.createEmptyBorder());
            this.addCenter(pane);
        }
    }

    class StepTrashAction
    implements ActionListener {
        final Simulation sim;
        final SimulationList list;

        public StepTrashAction(Simulation sim, SimulationList list) {
            this.sim = sim;
            this.list = list;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isOK = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminSimulation.this.rootComponent), (String)Language.get("SIM_DELETE_STEP_MSG"), (String)Language.get("SIM_DELETE_STEP"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,48"), (String)Language.get("DELETE"), (String)Language.get("CANCEL"));
            if (!isOK) {
                return;
            }
            this.list.deleteSelected();
            AdminSimulation.this.saveSimulation(this.sim);
        }
    }

    class TrashAction
    implements ActionListener {
        TrashAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AdminSimulation.this.currentSimulation == null) {
                return;
            }
            boolean isOK = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminSimulation.this.rootComponent), (String)Language.get("SIM_DELETE_ENTIRE_MSG", "'" + AdminSimulation.this.currentSimulation.getName() + "'"), (String)Language.get("SIM_DELETE_ENTIRE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,48"), (String)Language.get("DELETE"), (String)Language.get("CANCEL"));
            if (!isOK) {
                return;
            }
            AdminSimulation.this.simulationsListModel.removeElement(AdminSimulation.this.currentSimulation);
            Simulation sim = (Simulation)AdminSimulation.this.simulationsList.getSelectedValue();
            AdminSimulation.this.showSimulation(sim);
        }
    }
}

