/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.serversettings.IgnoreKeyListenerTextField;
import com.aem.shelp.util.swing.ExampleLabel;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminPorts
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private IgnoreKeyListenerTextField portField;
    private IgnoreKeyListenerTextField ipPortsField;
    private IgnoreKeyListenerTextField vncField;
    private JRadioButton portsOnly;
    private JRadioButton ipPortCombos;
    private JCheckBox vncPort;
    private JButton portsApply;
    private JButton ipApply;
    private JButton vncApply;
    private JWrapLabel ipWarningLabel;
    private ValidationKeyListener validationListener;
    private ActionListener testPortListeners = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminPorts.this.portsApply.setEnabled(false);
            AdminPorts.this.ipApply.setEnabled(false);
            new TestPortsThread();
        }
    };
    private ServerConfig config;

    @Override
    protected void initUI() {
        this.validationListener = new ValidationKeyListener(this);
        this.portsApply = new JButton(Language.get("APPLY"));
        this.ipApply = new JButton(Language.get("APPLY"));
        this.vncApply = new JButton(Language.get("APPLY"));
        ActionListener save = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminPorts.this.saveListener.requestImmediateSave();
            }
        };
        this.portsApply.addActionListener(save);
        this.ipApply.addActionListener(save);
        this.vncApply.addActionListener(save);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_SERVER_DESC") + "</html>");
        this.portsOnly = new JRadioButton(Language.get("SPECIFY_PORTS_ONLY"));
        this.ipPortCombos = new JRadioButton(Language.get("SPECIFY_PORTS_AND_IPS"));
        this.vncPort = new JCheckBox(Language.get("ADMIN_MOBILE_VNC_PORT"));
        this.vncField = new IgnoreKeyListenerTextField();
        this.vncField.setDocument(new DigitDocument(false, false));
        this.portField = new IgnoreKeyListenerTextField();
        this.portField.setDocument(new DigitDocument(true));
        this.ipPortsField = new IgnoreKeyListenerTextField();
        this.ipWarningLabel = new JWrapLabel();
        this.ipWarningLabel.setVerticalTextPosition(1);
        this.ipWarningLabel.setIconTextGap(8);
        this.showIPWarning(false);
        SwingUtil.setWidth((JComponent)this.ipPortsField, (int)SimpleHelpLookAndFeel.scale((int)300));
        SwingUtil.setWidth((JComponent)this.portField, (int)SimpleHelpLookAndFeel.scale((int)100));
        SwingUtil.setWidth((JComponent)this.vncField, (int)SimpleHelpLookAndFeel.scale((int)100));
        this.ipPortsField.addKeyListener(this.validationListener);
        this.portField.addKeyListener(this.validationListener);
        this.vncField.addKeyListener(this.validationListener);
        int YY = 0;
        GridBagLayout gbl2 = new GridBagLayout();
        this.rootComponent.setLayout(gbl2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.portsOnly);
        bg.add(this.ipPortCombos);
        SwingUtil.setHeight((JComponent)this.ipApply, (int)this.ipPortsField.getHeight());
        SwingUtil.setHeight((JComponent)this.portsApply, (int)this.portField.getHeight());
        SwingUtil.setHeight((JComponent)this.vncApply, (int)this.vncField.getHeight());
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.ipApply);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.portsApply);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.vncApply);
        ExampleLabel portsExampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": 80, 443");
        ExampleLabel ipPortExampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": 2.2.2.2:80, 4.4.4.4:443");
        ExampleLabel vncExampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": 222");
        GbPanel portsPanel = new GbPanel();
        portsPanel.add((Component)this.portField, 0, 0, 1, 1, 0, 1, 17, 2);
        portsPanel.add((Component)this.portsApply, 1, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        portsPanel.add((Component)portsExampleLabel, 2, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        GbPanel ipPortsPanel = new GbPanel();
        ipPortsPanel.add((Component)this.ipPortsField, 0, 0, 1, 1, 0, 1, 17, 2);
        ipPortsPanel.add((Component)this.ipApply, 1, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        ipPortsPanel.add((Component)ipPortExampleLabel, 2, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        ipPortsPanel.add((Component)this.ipWarningLabel, 0, 1, 3, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
        GbPanel vncPortPanel = new GbPanel();
        vncPortPanel.add((Component)this.vncField, 0, 0, 1, 1, 0, 1, 17, 2);
        vncPortPanel.add((Component)this.vncApply, 1, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        vncPortPanel.add((Component)vncExampleLabel, 2, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
        this.portsOnly.addActionListener(new PortOrIpsListener());
        this.ipPortCombos.addActionListener(new PortOrIpsListener());
        this.vncPort.addActionListener(new VncPortListener());
        gbl2.setConstraints((Component)descriptionLabel, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 10, 1, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        gbl2.setConstraints(this.portsOnly, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        gbl2.setConstraints((Component)portsPanel, new GridBagConstraints(0, YY++, 1, 1, 100.0, 1.0, 17, 2, (Insets)new ScaledInsets(2, 25, 0, 0), 100, 0));
        gbl2.setConstraints(this.ipPortCombos, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        gbl2.setConstraints((Component)ipPortsPanel, new GridBagConstraints(0, YY++, 1, 1, 100.0, 1.0, 17, 2, (Insets)new ScaledInsets(2, 25, 5, 0), 100, 0));
        gbl2.setConstraints(this.vncPort, new GridBagConstraints(0, YY++, 3, 1, 1.0, 100.0, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        gbl2.setConstraints((Component)vncPortPanel, new GridBagConstraints(0, YY++, 1, 1, 100.0, 1.0, 17, 2, (Insets)new ScaledInsets(2, 25, 5, 0), 100, 0));
        this.rootComponent.add(this.portsOnly);
        this.rootComponent.add(this.ipPortCombos);
        this.rootComponent.add((Component)ipPortsPanel);
        this.rootComponent.add((Component)portsPanel);
        this.rootComponent.add(this.vncPort);
        this.rootComponent.add((Component)vncPortPanel);
    }

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.ipPortCombos.isSelected()) {
            this.showIPWarning(true);
        } else {
            this.showIPWarning(false);
        }
        if (this.portsOnly.isSelected() && (this.portField.getText().length() == 0 || !AdminPorts.isValidPortField(this.portField.getText(), true))) {
            list.add(this.portField);
        } else {
            this.portField.setBorder(this.defaultTextFieldBorder);
        }
        if (this.ipPortCombos.isSelected() && !this.isValidIpPortsField(this.ipPortsField.getText())) {
            list.add(this.ipPortsField);
        } else {
            this.ipPortsField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    private void showIPWarning(boolean showit) {
        if (showit) {
            this.ipWarningLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
            this.ipWarningLabel.setText("<HTML>" + Language.get("SPECIFY_PORTS_AND_IPS_WARNING") + "</HTML>");
        } else {
            this.ipWarningLabel.setIcon(null);
            this.ipWarningLabel.setText(" ");
        }
        this.ipWarningLabel.setVisible(showit);
    }

    private boolean isValidIpPortsField(String ipText) {
        char[] ips;
        if (ipText.trim().length() == 0) {
            return false;
        }
        for (char ip : ips = ipText.toCharArray()) {
            if (Character.isDigit(ip) || ip == '.' || ip == ':' || ip == ',') continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SERVER_CONFIG");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.config = config;
        StringBuilder buffer = new StringBuilder();
        if (config.portList != null) {
            for (int i = 0; i < config.portList.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(config.portList[i]);
            }
        }
        this.portField.setText(buffer.toString());
        StringBuilder ipbuf = new StringBuilder();
        if (config.ipPortPairsList != null) {
            for (int i = 0; i < config.ipPortPairsList.length; ++i) {
                if (i > 0) {
                    ipbuf.append(",");
                }
                ipbuf.append(config.ipPortPairsList[i]);
            }
        }
        this.ipPortsField.setText(ipbuf.toString());
        if (this.ipPortsField.getText().length() > 0) {
            this.portsOnly.setSelected(false);
            this.ipPortCombos.setSelected(true);
        } else {
            this.ipPortCombos.setSelected(false);
            this.portsOnly.setSelected(true);
        }
        if (config.sshdPort < 0) {
            this.vncPort.setSelected(false);
            this.vncField.setText("" + -config.sshdPort);
        } else {
            this.vncPort.setSelected(true);
            this.vncField.setText(config.sshdPort + "");
        }
        this.vncPort.setEnabled(config.enabledMobileAccess);
        this.vncField.setEnabled(config.enabledMobileAccess);
        this.vncApply.setEnabled(config.enabledMobileAccess);
        this.updatePortOrIpsEnabled();
        this.updateVncEnabled();
    }

    private void updatePortOrIpsEnabled() {
        this.portField.setEnabled(this.portsOnly.isSelected());
        this.ipPortsField.setEnabled(this.ipPortCombos.isSelected());
        this.portsApply.setEnabled(this.portsOnly.isSelected());
        this.ipApply.setEnabled(this.ipPortCombos.isSelected());
    }

    private void updateVncEnabled() {
        if (this.vncPort.isEnabled()) {
            this.vncField.setEnabled(this.vncPort.isSelected());
            this.vncApply.setEnabled(this.vncPort.isSelected());
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        String[] parsedPorts;
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (String parsedPort : parsedPorts = this.portField.getText().split(",")) {
            try {
                ports.add(Integer.parseInt(parsedPort));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        config.portList = new int[ports.size()];
        for (int i = 0; i < ports.size(); ++i) {
            config.portList[i] = (Integer)ports.get(i);
        }
        if (this.ipPortCombos.isSelected()) {
            String[] allips = this.ipPortsField.getText().split(",");
            config.ipPortPairsList = allips;
            if (allips.length == 1 && allips[0].trim().length() == 0) {
                config.ipPortPairsList = null;
            }
        } else {
            config.ipPortPairsList = null;
        }
        if (config.enabledMobileAccess) {
            try {
                config.sshdPort = this.vncPort.isSelected() ? Integer.parseInt(this.vncField.getText()) : -Math.abs(Integer.parseInt(this.vncField.getText()));
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        config.recreateIpAndPortLists();
    }

    @Override
    public void switchedTo() {
        this.vncPort.setEnabled(this.config.enabledMobileAccess);
        this.vncField.setEnabled(this.config.enabledMobileAccess);
        this.vncApply.setEnabled(this.config.enabledMobileAccess);
        this.updateVncEnabled();
    }

    @Override
    public void checkEnabled() {
    }

    private class PortOrIpsListener
    implements ActionListener {
        private PortOrIpsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminPorts.this.updatePortOrIpsEnabled();
            AdminPorts.this.contentChanged(AdminPorts.this.checkIfValid());
        }
    }

    private class VncPortListener
    implements ActionListener {
        private VncPortListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminPorts.this.updateVncEnabled();
            AdminPorts.this.contentChanged(AdminPorts.this.checkIfValid());
        }
    }

    class TestPortsThread
    extends Thread {
        TestPortsThread() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdminPorts.this.portsApply.setEnabled(true);
                    AdminPorts.this.ipApply.setEnabled(true);
                }
            });
        }
    }
}

