/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.WindowsFirewallUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminStatusTest
extends SubSection {
    public static AdminStatusTest INSTANCE;
    private JLabel publiclyAvailableTitle;
    private JLabel publiclyAvailableDesc;
    private JLabel publiclyAvailableFlag;
    private JCheckBox automaticallyOpenPort;
    private JLabel publicIPAddressTitle;
    private JLabel publicIPAddressDesc;
    private JLabel publicIPAddressFlag;
    private JLabel firewallTitle;
    private JLabel firewallDesc;
    private JLabel firewallFlag;
    private JLabel stdPortsTitle;
    private JLabel stdPortsDesc;
    private JLabel stdPortsFlag;
    private ArrowedProgressBar bar1;
    private ArrowedProgressBar bar2;
    private ArrowedProgressBar bar3;
    private ArrowedProgressBar bar4;
    private JButton checkServerStatusButton;
    private boolean serverIsWindows;
    private boolean usingPort80And443 = false;

    public AdminStatusTest() {
        INSTANCE = this;
    }

    @Override
    protected void initUI() {
        int Y = 0;
        this.bar1 = new ArrowedProgressBar();
        this.bar2 = new ArrowedProgressBar();
        this.bar3 = new ArrowedProgressBar();
        this.bar4 = new ArrowedProgressBar();
        GbPanelWrapper availabilityWrapper = new GbPanelWrapper((Container)this.rootComponent);
        this.checkServerStatusButton = new JButton(Language.get("ADMIN_OVERVIEW_CHECK_ALL"));
        this.checkServerStatusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminStatusTest.this.checkServerStatusButton.setEnabled(false);
                new RunTestThread().start();
            }
        });
        this.publiclyAvailableFlag = new JLabel(ImageLoader.getImageIconDisabled((String)Icons.FLAG_YELLOW));
        this.publiclyAvailableTitle = new JLabel(Language.get("ADMIN_OVERVIEW_PUBLIC_TITLE"));
        this.publiclyAvailableDesc = new JWrapLabel(Language.get("ADMIN_OVERVIEW_PUBLIC_DESC"));
        this.automaticallyOpenPort = new JCheckBox(Language.get("ADMIN_OVERVIEW_OPEN_PORT"));
        this.automaticallyOpenPort.setEnabled(false);
        this.automaticallyOpenPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminStatusTest.this.automaticallyOpenPort.setEnabled(false);
                new PortMapperThread().start();
            }
        });
        this.publicIPAddressFlag = new JLabel(ImageLoader.getImageIconDisabled((String)Icons.FLAG_YELLOW));
        this.publicIPAddressTitle = new JLabel(Language.get("ADMIN_OVERVIEW_IP_TITLE"));
        this.publicIPAddressDesc = new JWrapLabel(Language.get("ADMIN_OVERVIEW_IP_DESC"));
        this.firewallFlag = new JLabel(ImageLoader.getImageIconDisabled((String)Icons.FLAG_YELLOW));
        this.firewallTitle = new JLabel(Language.get("ADMIN_OVERVIEW_FIREWALL_TITLE"));
        this.firewallDesc = new JWrapLabel(Language.get("ADMIN_OVERVIEW_FIREWALL_DESC"));
        this.firewallFlag.setVisible(false);
        this.firewallTitle.setVisible(false);
        this.firewallDesc.setVisible(false);
        this.bar3.setVisible(false);
        this.stdPortsFlag = new JLabel(ImageLoader.getImageIconDisabled((String)Icons.FLAG_YELLOW));
        this.stdPortsTitle = new JLabel(Language.get("ADMIN_OVERVIEW_PORTS_TITLE"));
        this.stdPortsDesc = new JWrapLabel(Language.get("ADMIN_OVERVIEW_PORTS_DESC"));
        this.publiclyAvailableDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.publicIPAddressDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.firewallDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.stdPortsDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.bar1.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.bar2.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.bar3.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.bar4.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        Y = 0;
        availabilityWrapper.add((Component)this.checkServerStatusButton, 2, Y++, 2, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 10, 10, 10));
        availabilityWrapper.add((Component)this.bar1.getRootComponent(), 0, Y, 1, 2, 0, 0, 13, 0, (Insets)new ScaledInsets(10, 10, 10, 10));
        availabilityWrapper.add((Component)this.publiclyAvailableFlag, 1, Y, 1, 2, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 10, 3, 10));
        availabilityWrapper.add((Component)this.publiclyAvailableTitle, 2, Y++, 1, 1, 0, 0, 16, 0, (Insets)new ScaledInsets(10, 10, 0, 10));
        availabilityWrapper.add((Component)this.publiclyAvailableDesc, 2, Y++, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(3, 10, 0, 10));
        availabilityWrapper.add((Component)this.automaticallyOpenPort, 2, Y++, 1, 1, 0, 0, 18, 0, (Insets)new ScaledInsets(0, 10, 10, 10));
        availabilityWrapper.add((Component)this.bar2.getRootComponent(), 0, Y, 1, 2, 0, 0, 10, 0, (Insets)new ScaledInsets(10, 10, 15, 10));
        availabilityWrapper.add((Component)this.publicIPAddressFlag, 1, Y, 1, 2, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 10, 15, 10));
        availabilityWrapper.add((Component)this.publicIPAddressTitle, 2, Y++, 1, 1, 0, 0, 16, 0, (Insets)new ScaledInsets(10, 10, 0, 10));
        availabilityWrapper.add((Component)this.publicIPAddressDesc, 2, Y++, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(3, 10, 10, 10));
        availabilityWrapper.add((Component)this.bar3.getRootComponent(), 0, Y, 1, 2, 0, 0, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        availabilityWrapper.add((Component)this.firewallFlag, 1, Y, 1, 2, 0, 0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        availabilityWrapper.add((Component)this.firewallTitle, 2, Y++, 1, 1, 0, 0, 16, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        availabilityWrapper.add((Component)this.firewallDesc, 2, Y++, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.bar3.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)15, (int)10));
        this.firewallFlag.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)15, (int)10));
        this.firewallTitle.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)0, (int)10));
        this.firewallDesc.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)10, (int)10, (int)10));
        availabilityWrapper.add((Component)this.bar4.getRootComponent(), 0, Y, 1, 2, 0, 0, 10, 0, (Insets)new ScaledInsets(10, 10, 15, 10));
        availabilityWrapper.add((Component)this.stdPortsFlag, 1, Y, 1, 2, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 10, 15, 10));
        availabilityWrapper.add((Component)this.stdPortsTitle, 2, Y++, 1, 1, 0, 0, 16, 0, (Insets)new ScaledInsets(10, 10, 0, 10));
        availabilityWrapper.add((Component)this.stdPortsDesc, 2, Y++, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(3, 10, 10, 10));
    }

    private void setLabelsGrey() {
        this.publiclyAvailableFlag.setIcon(ImageLoader.getImageIcon((String)Icons.FLAG_GREY));
        this.publicIPAddressFlag.setIcon(ImageLoader.getImageIcon((String)Icons.FLAG_GREY));
        this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)Icons.FLAG_GREY));
        this.publiclyAvailableDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.publicIPAddressDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.firewallDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
    }

    @Override
    public String getTitle() {
        return Language.get("SERVER_STATUS_TEST_3");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        int[] portList = config.portList;
        String[] comboList = config.ipPortPairsList;
        boolean using80 = false;
        boolean using443 = false;
        if (comboList == null) {
            if (portList != null) {
                for (int i : portList) {
                    if (i == 80) {
                        using80 = true;
                        continue;
                    }
                    if (i != 443) continue;
                    using443 = true;
                }
            }
        } else {
            for (String s : comboList) {
                if (s.endsWith(":80")) {
                    using80 = true;
                    continue;
                }
                if (!s.endsWith(":443")) continue;
                using443 = true;
            }
        }
        this.usingPort80And443 = using80 && using443;
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    public void setServerOSIsWindows(boolean serverIsWindows) {
        this.serverIsWindows = serverIsWindows;
        this.firewallTitle.setVisible(serverIsWindows);
        this.firewallDesc.setVisible(serverIsWindows);
        this.firewallFlag.setVisible(serverIsWindows);
        this.bar3.setVisible(serverIsWindows);
        this.rootComponent.repaint();
    }

    class PortMapperThread
    extends Thread {
        public PortMapperThread() {
            super("PortMapperThread");
        }

        @Override
        public void run() {
            try {
                AdminStatusTest.this.automaticallyOpenPort.setEnabled(false);
                AdminStatusTest.this.checkServerStatusButton.setEnabled(false);
                AdminStatusTest.this.setLabelsGrey();
                try {
                    AdminStatusTest.this.bar1.on();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (AdminStatusTest.this.automaticallyOpenPort.isSelected()) {
                    AdminStatusTest.this.techClient.requestPortMapping();
                } else {
                    AdminStatusTest.this.techClient.removePortMapping();
                }
                new RunTestThread().start();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class RunTestThread
    extends Thread {
        RunTestThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AdminStatusTest.this.bar1.on();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (AdminStatusTest.this.techClient.isPortMapped()) {
                    AdminStatusTest.this.automaticallyOpenPort.setSelected(true);
                } else {
                    AdminStatusTest.this.automaticallyOpenPort.setSelected(false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                boolean available = false;
                try {
                    available = AdminStatusTest.this.techClient.webserviceIsPublic();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    AdminStatusTest.this.bar1.off();
                }
                AdminStatusTest.this.publiclyAvailableDesc.setForeground(AdminStatusTest.this.publiclyAvailableFlag.getForeground());
                if (available) {
                    AdminStatusTest.this.publiclyAvailableFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                    AdminStatusTest.this.publiclyAvailableDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_PUBLIC_YES") + "</HTML>");
                } else {
                    AdminStatusTest.this.publiclyAvailableFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/red.svg,32"));
                    AdminStatusTest.this.publiclyAvailableDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_PUBLIC_NO") + "</HTML>");
                }
                String publicIP = null;
                try {
                    AdminStatusTest.this.bar2.on();
                    publicIP = AdminStatusTest.this.techClient.webserviceGetPublicIP();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    AdminStatusTest.this.bar2.off();
                }
                AdminStatusTest.this.publicIPAddressDesc.setForeground(AdminStatusTest.this.publiclyAvailableFlag.getForeground());
                if (publicIP != null && publicIP.length() > 0) {
                    AdminStatusTest.this.publicIPAddressFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                    AdminStatusTest.this.publicIPAddressDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_IP_YES") + ": " + publicIP + "</HTML>");
                } else {
                    AdminStatusTest.this.publicIPAddressFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/red.svg,32"));
                    AdminStatusTest.this.publicIPAddressDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_IP_NO") + "</HTML>");
                }
                if (AdminStatusTest.this.serverIsWindows) {
                    WindowsFirewallUtil.FirewallStatus status = null;
                    try {
                        AdminStatusTest.this.bar3.on();
                        status = AdminStatusTest.this.techClient.getFirewallStatus();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        AdminStatusTest.this.bar3.off();
                    }
                    AdminStatusTest.this.firewallDesc.setForeground(AdminStatusTest.this.publiclyAvailableFlag.getForeground());
                    if (status == null || !status.isWindows) {
                        AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)Icons.FLAG_YELLOW));
                        AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_UNKNOWN") + "</HTML>");
                    } else if (status.isRunning == 0) {
                        AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                        AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_OK") + "</HTML>");
                    } else {
                        int[] openPortList = status.getOpenPortList();
                        String[] unblockedIPs = status.getUnblockedIPList();
                        if (status.shIsExcepted == 1) {
                            AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                            AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_EXCEPTION") + "</HTML>");
                        } else if (openPortList.length > 0) {
                            StringBuffer buffer = new StringBuffer();
                            for (int i = 0; i < openPortList.length; ++i) {
                                if (i > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append(openPortList[i]);
                            }
                            AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                            AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_PORTEXCEPTION") + ": " + buffer + "</HTML>");
                        } else if (unblockedIPs.length > 0) {
                            StringBuffer buffer = new StringBuffer();
                            for (int i = 0; i < unblockedIPs.length; ++i) {
                                if (i > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append(unblockedIPs[i]);
                            }
                            AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                            AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_IPEXCEPTION") + ": " + buffer + "</HTML>");
                        } else {
                            AdminStatusTest.this.firewallFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/red.svg,32"));
                            AdminStatusTest.this.firewallDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_FIREWALL_BAD") + "</HTML>");
                        }
                    }
                }
                AdminStatusTest.this.stdPortsDesc.setForeground(AdminStatusTest.this.publiclyAvailableFlag.getForeground());
                if (AdminStatusTest.this.usingPort80And443) {
                    AdminStatusTest.this.stdPortsFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/green.svg,32"));
                    AdminStatusTest.this.stdPortsDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_PORTS_YES") + "</HTML>");
                } else {
                    AdminStatusTest.this.stdPortsFlag.setIcon(ImageLoader.getImageIcon((String)"images/svg/alert-flags/red.svg,32"));
                    AdminStatusTest.this.stdPortsDesc.setText("<HTML>" + Language.get("ADMIN_OVERVIEW_PORTS_NO") + "</HTML>");
                }
            }
            finally {
                AdminStatusTest.this.automaticallyOpenPort.setEnabled(true);
                AdminStatusTest.this.checkServerStatusButton.setEnabled(true);
            }
        }
    }
}

