/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminDiskCleanup
extends SubSection
implements ActionListener {
    private JCheckBox automaticDiskCleanup;
    private JComboBox unitBox;
    private JTextField quantityField;
    private JButton removeNowButton;
    private GbPanel configPanel;

    @Override
    protected void initUI() {
        this.automaticDiskCleanup = new JCheckBox(Language.get("CLEANUP_ENABLE"));
        this.quantityField = TextField.getTextFieldForType((int)1, (String)"10");
        this.unitBox = new JComboBox<String>(new String[]{Language.get("UNIT_MONTHS"), Language.get("UNIT_YEARS")});
        this.removeNowButton = new JButton(Language.get("CLEANUP_NOW"));
        this.removeNowButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
        GbPanelWrapper blockWrapper = new GbPanelWrapper((Container)this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("CLEANUP_DESC"));
        JLabel timeoutLabel = new JLabel(Language.get("CLEANUP_MSG"));
        int Y = 0;
        blockWrapper.add((Component)descriptionLabel, 0, Y++, 3, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 5, 0));
        blockWrapper.add((Component)this.automaticDiskCleanup, 0, Y++, 3, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0));
        SwingUtil.setWidth((JComponent)this.quantityField, (int)SimpleHelpLookAndFeel.scale((int)50));
        this.configPanel = new GbPanel();
        this.configPanel.add((Component)timeoutLabel, 0, 0, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(0, 30, 5, 0));
        this.configPanel.add((Component)this.quantityField, 1, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 5, 5, 0));
        this.configPanel.add((Component)this.unitBox, 2, 0, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(0, 5, 5, 0));
        this.configPanel.add((Component)this.removeNowButton, 3, 0, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(0, 25, 5, 0));
        blockWrapper.add((Component)this.configPanel, 0, Y, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.automaticDiskCleanup.addActionListener(this);
        this.quantityField.addKeyListener(this.validateListener);
        this.unitBox.addActionListener(this.validateListener);
        this.removeNowButton.addActionListener(this);
        SwingUtil.setHeight((JComponent)this.removeNowButton, (int)this.unitBox.getPreferredSize().height);
    }

    @Override
    public String getTitle() {
        return Language.get("SERVER_DISK_CLEANUP");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.automaticDiskCleanup.setSelected(config.diskCleanupEnabled);
        int months = config.diskCleanupTimeoutMonths;
        if (months % 12 == 0) {
            int years = months / 12;
            this.quantityField.setText(String.valueOf(years));
            this.unitBox.setSelectedIndex(1);
        } else {
            this.quantityField.setText(String.valueOf(months));
            this.unitBox.setSelectedIndex(0);
        }
        this.updateEnabled();
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.diskCleanupEnabled = this.automaticDiskCleanup.isSelected();
        config.diskCleanupTimeoutMonths = this.getConfiguredMonths();
    }

    private int getConfiguredMonths() {
        try {
            if (this.unitBox.getSelectedIndex() == 1) {
                return 12 * Integer.parseInt(this.quantityField.getText());
            }
            return Integer.parseInt(this.quantityField.getText());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 12;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.removeNowButton == e.getSource()) {
            if (SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("CLEANUP_D_MSG"), (String)Language.get("SERVER_DISK_CLEANUP"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("CLEANUP"))) {
                this.cleanupNow();
            }
            return;
        }
        this.updateEnabled();
        this.contentChanged(this.checkIfValid());
    }

    private void cleanupNow() {
        InfiniteCircularProgressIcon circularInfinite = SHProgressIcons.getCircularInfinite(SHProgressIcons.SIZE_16);
        circularInfinite.setUpdateComponent((Component)this.removeNowButton);
        circularInfinite.switchOn();
        this.removeNowButton.setEnabled(false);
        this.removeNowButton.setIcon((Icon)circularInfinite);
        new DiskCleanupThread().start();
    }

    private void updateEnabled() {
        boolean on = this.automaticDiskCleanup.isSelected();
        this.configPanel.setVisible(on);
    }

    private class DiskCleanupThread
    extends Thread {
        public DiskCleanupThread() {
            super("CleanupThread");
        }

        @Override
        public void run() {
            try {
                AdminDiskCleanup.this.techClient.runDiskCleanupNow(AdminDiskCleanup.this.getConfiguredMonths());
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AdminDiskCleanup.this.removeNowButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
                            AdminDiskCleanup.this.removeNowButton.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

