/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.APIToken;
import com.aem.shelp.proxy.techclient.TechClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import testing.classes.access.AccessPanelTester;
import utils.progtools.OnDemandThreadPool;
import utils.swing.SwingUtil;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class TokenDialog
extends OKCancelDialogPanel
implements ListSelectionListener {
    private final TechClient client;
    private SimpleList<APIToken> tokenList;
    private SimpleTableModel tableModel = null;
    private SHJTable keyTable;
    private JButton deleteButton;
    private JButton newButton;
    private static final int CELL_PADDING = 4;
    private OnDemandThreadPool odtp = new OnDemandThreadPool("TokenUIPool", 1, 1, 5);
    private NoContentsInfoPanel noContentsInfoPanel;

    public TokenDialog(RootPaneContainer rootPane, final TechClient client) {
        super(Language.get("CLOSE"));
        this.client = client;
        this.newButton = this.addLeftButton(Language.get("ADD_API_KEY"), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TokenDialog.this.newButton.setEnabled(false);
                    TokenDialog.this.newButton.repaint();
                    TokenDialog.this.odtp.runAsync(new Runnable(){

                        @Override
                        public void run() {
                            APIToken token = null;
                            try {
                                token = client.createAPIToken();
                                TokenDialog.this.tokenList.add(token);
                                TokenDialog.this.updateNoContentsPanel();
                            }
                            catch (Exception e1) {
                                try {
                                    e1.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            TokenDialog.this.newButton.setEnabled(true);
                                            TokenDialog.this.newButton.repaint();
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.deleteButton = this.addLeftButton(Language.get("REMOVE_API_KEY"), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TokenDialog.this.keyTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                final APIToken token = (APIToken)TokenDialog.this.tokenList.get(row);
                TokenDialog.this.odtp.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        TokenDialog.this.delete(token);
                    }
                });
                TokenDialog.this.tokenList.remove(row);
            }
        });
        this.deleteButton.setEnabled(false);
        SHButtonUI.makeButtonRed((JButton)this.deleteButton);
        JPanel contentPanel = this.getContentPanel();
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
        SwingUtil.setHeight((JComponent)panel, (int)SimpleHelpLookAndFeel.scale((int)300));
        this.setContent((FixedWidthComponent)panel);
        this.odtp.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    APIToken[] tokens = client.getAPITokens();
                    TokenDialog.this.tokenList.addAll(Arrays.asList(tokens));
                    TokenDialog.this.updateNoContentsPanel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateNoContentsPanel() {
        if (this.tokenList.size() == 0) {
            this.noContentsInfoPanel.setTitle(Language.get("API_TOKEN_NONE"));
            this.noContentsInfoPanel.setHasContents(false);
        } else {
            this.noContentsInfoPanel.setHasContents(true);
        }
    }

    protected void delete(APIToken token) {
        try {
            this.client.deleteAPIToken(token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showDialog(RootPaneContainer rpc, TechClient client) {
        TokenDialog dialog = new TokenDialog(rpc, client);
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 800, (AbstractDialogPanel)dialog);
        abstractGlassDialog.setTitle(Language.get("API_DIALOG_TITLE"));
        abstractGlassDialog.showDialog();
    }

    protected JPanel getContentPanel() {
        JPanel userPanel = new JPanel();
        this.tokenList = new SimpleList();
        TableStructure ts = TableStructure.createTableStructure(APIToken.class, new String[]{"description", "token", "created"}, new String[]{Language.get("DESCRIPTION"), Language.get("API_TOKEN"), Language.get("API_CREATED")});
        ts.setWidths(new int[]{SimpleHelpLookAndFeel.scale((int)250), SimpleHelpLookAndFeel.scale((int)350), SimpleHelpLookAndFeel.scale((int)75)});
        ts.setEditable(new boolean[]{true, false, false});
        this.tableModel = new SimpleTableModel(this.tokenList, ts){

            @Override
            public void setValueAt(Object aValue, final int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                TokenDialog.this.odtp.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TokenDialog.this.client.setAPIToken((APIToken)TokenDialog.this.tokenList.get(rowIndex));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        };
        this.keyTable = new SHJTable(this.tableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = TokenDialog.this.keyTable.rowAtPoint(e.getPoint());
                int col = TokenDialog.this.keyTable.columnAtPoint(e.getPoint());
                if (col == 1 && row > -1) {
                    String token = ((APIToken)((TokenDialog)TokenDialog.this).tokenList.get((int)row)).token;
                    int textWidth = SwingUtilities.computeStringWidth(TokenDialog.this.keyTable.getFontMetrics(TokenDialog.this.keyTable.getFont()), token);
                    Rectangle cellRect = TokenDialog.this.keyTable.getCellRect(row, col, true);
                    int iconX = cellRect.x + textWidth + 4;
                    if (e.getPoint().x > iconX && e.getPoint().x < iconX + SimpleHelpLookAndFeel.scale((int)16)) {
                        return Language.get("API_COPY_CLIPBOARD");
                    }
                }
                return null;
            }
        };
        this.keyTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)32));
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final int row = TokenDialog.this.keyTable.rowAtPoint(e.getPoint());
                int col = TokenDialog.this.keyTable.columnAtPoint(e.getPoint());
                if (col == 1 && row > -1) {
                    String token = ((APIToken)((TokenDialog)TokenDialog.this).tokenList.get((int)row)).token;
                    int textWidth = SwingUtilities.computeStringWidth(TokenDialog.this.keyTable.getFontMetrics(TokenDialog.this.keyTable.getFont()), token);
                    final Rectangle cellRect = TokenDialog.this.keyTable.getCellRect(row, col, true);
                    int iconX = cellRect.x + textWidth + 4;
                    if (e.getPoint().x > iconX && e.getPoint().x < iconX + SimpleHelpLookAndFeel.scale((int)16)) {
                        ((APIToken)((TokenDialog)TokenDialog.this).tokenList.get((int)row)).metadata = Boolean.TRUE;
                        TokenDialog.this.keyTable.repaint(cellRect);
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                ((APIToken)((TokenDialog)TokenDialog.this).tokenList.get((int)row)).metadata = null;
                                TokenDialog.this.keyTable.repaint(cellRect);
                            }
                        }.start();
                        ClipboardUtil.setClipboardAsText(token);
                    }
                }
            }
        });
        APITTokenRenderer tokenRenderer = new APITTokenRenderer();
        this.keyTable.setDefaultRenderer(Object.class, tokenRenderer);
        this.keyTable.setDefaultRenderer(Long.class, tokenRenderer);
        this.keyTable.getTableHeader().setDefaultRenderer(new AlignTableCellRendererWrapper(this.keyTable.getTableHeader().getDefaultRenderer(), new int[]{2, 2, 4}));
        ts.initTableDimensions(this.keyTable);
        JScrollPane tableScroller = new JScrollPane(this.keyTable);
        this.noContentsInfoPanel = new NoContentsInfoPanel(Language.get("LOADING"), null, false);
        this.noContentsInfoPanel.setContentsPanel(tableScroller);
        userPanel.setLayout(new GridLayout(1, 1));
        userPanel.add(this.noContentsInfoPanel);
        return userPanel;
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        TechClient techClient = AccessPanelTester.getTechClient();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        TokenDialog.showDialog((RootPaneContainer)frame, techClient);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.deleteButton.setEnabled(this.keyTable.getSelectedRow() != -1);
        this.deleteButton.repaint();
    }

    private boolean copiedToClipboard(int row) {
        return this.tokenList.get((int)row).metadata != null;
    }

    class APITTokenRenderer
    extends DefaultTableCellRenderer {
        private DateFormat df = DateFormat.getDateInstance(3);

        APITTokenRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
            if (isSelected) {
                label.setForeground(UIManager.getColor("TextField.selectionForeground"));
            } else {
                label.setForeground(UIManager.getColor("TextField.foreground"));
            }
            label.setIcon(null);
            switch (column) {
                case 0: {
                    label.setHorizontalAlignment(2);
                    if (value != null && String.valueOf(value).trim().length() > 0) {
                        label.setText(String.valueOf(value));
                        break;
                    }
                    if (!isSelected) {
                        label.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/pencil.svg,16"));
                    } else {
                        label.setIcon(ImageLoader.getImageIconLighter((String)"images/svg/general/pencil.svg,16"));
                    }
                    label.setHorizontalTextPosition(2);
                    if (!isSelected) {
                        label.setForeground(Color.GRAY);
                    }
                    label.setText(Language.get("API_DESCRIPTION_ADD"));
                    break;
                }
                case 1: {
                    label.setText(String.valueOf(value));
                    label.setHorizontalAlignment(2);
                    if (!TokenDialog.this.copiedToClipboard(row)) {
                        if (!isSelected) {
                            label.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/arrows/share.svg,16"));
                        } else {
                            label.setIcon(ImageLoader.getImageIconLighter((String)"images/svg/arrows/share.svg,16"));
                        }
                    } else {
                        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
                    }
                    label.setHorizontalTextPosition(2);
                    break;
                }
                case 2: {
                    label.setText(this.df.format(value));
                    label.setHorizontalAlignment(4);
                }
            }
            return label;
        }
    }
}

