/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyHashPassword;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthGbPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class PasswordDialog
implements KeyListener {
    private final AbstractGlassDialog dialog;
    private final OKCancelDialogPanel dialogPanel;
    private JFixedWidthPasswordField oldPasswordField;
    private JFixedWidthPasswordField newPassword1;
    private JFixedWidthPasswordField newPassword2;
    private boolean requireOldPassword;
    private String username;
    private PasswordValidator passwordValidator;
    private char[] newPassword;

    public PasswordDialog(RootPaneContainer rpc, boolean requireOldPassword, String username, PasswordValidator passwordValidator, boolean isAdminUser) {
        this.requireOldPassword = requireOldPassword;
        this.username = username;
        this.passwordValidator = passwordValidator;
        this.dialogPanel = new OKCancelDialogPanel(Language.get("PASSWORD_DIALOG_SET_PASSWORD"), Language.get("CANCEL"));
        this.dialogPanel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,48"));
        if (isAdminUser) {
            this.dialogPanel.setTitle(Language.get("PASSWORD_DIALOG_DESC_ADMIN"), false);
        } else {
            this.dialogPanel.setTitle(Language.get("PASSWORD_DIALOG_DESC", username), false);
        }
        FixedWidthGbPanel fixedWidthComponent = new FixedWidthGbPanel(new ScaledInsets(5, 5, 5, 5));
        JLabel oldPasswordLabel = new JLabel(Language.get("PASSWORD_DIALOG_OLD"));
        JLabel newPassword1Label = new JLabel(Language.get("PASSWORD_DIALOG_NEW1"));
        JLabel newPassword2Label = new JLabel(Language.get("PASSWORD_DIALOG_NEW2"));
        this.oldPasswordField = new JFixedWidthPasswordField();
        this.newPassword1 = new JFixedWidthPasswordField();
        this.newPassword2 = new JFixedWidthPasswordField();
        int Y = 0;
        if (requireOldPassword) {
            fixedWidthComponent.add((Component)oldPasswordLabel, 0, Y, 1, 1, 0, 0, 13, 0);
            fixedWidthComponent.add((Component)this.oldPasswordField, 1, Y++, 1, 1, 1, 0, 17, 2);
        }
        fixedWidthComponent.add((Component)newPassword1Label, 0, Y, 1, 1, 0, 0, 13, 0);
        fixedWidthComponent.add((Component)this.newPassword1, 1, Y++, 1, 1, 1, 0, 17, 2);
        fixedWidthComponent.add((Component)newPassword2Label, 0, Y, 1, 1, 0, 0, 13, 0);
        fixedWidthComponent.add((Component)this.newPassword2, 1, Y++, 1, 1, 1, 0, 17, 2);
        if (requireOldPassword) {
            this.oldPasswordField.addKeyListener(this);
        }
        this.newPassword1.addKeyListener(this);
        this.newPassword2.addKeyListener(this);
        this.dialogPanel.setOkEnabled(false);
        this.dialogPanel.setContent((FixedWidthComponent)fixedWidthComponent);
        this.dialog = new AbstractGlassDialog(rpc, 550, (AbstractDialogPanel)this.dialogPanel);
        this.dialog.setTitle(Language.get("PASSWORD_DIALOG_TITLE"));
        this.dialog.setModal(true);
        this.dialog.showDialog();
    }

    public char[] getSetPassword() {
        return this.newPassword;
    }

    public boolean isOK() {
        return this.dialogPanel.isOK();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean valid;
        if (e.getKeyCode() == 27) {
            this.dialog.cancelPressed();
            return;
        }
        boolean bl = valid = Arrays.equals(this.newPassword1.getPassword(), this.newPassword2.getPassword()) && this.newPassword1.getPassword().length > 0;
        if (valid && this.requireOldPassword && this.passwordValidator != null) {
            valid = this.passwordValidator.matchesPassword(new String(this.oldPasswordField.getPassword()));
        }
        this.dialogPanel.setOkEnabled(valid);
        if (valid) {
            this.newPassword = this.newPassword1.getPassword();
            if (e.getKeyCode() == 10) {
                this.dialog.okPressed();
            }
        } else {
            this.newPassword = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static class HashPasswordValidator
    implements PasswordValidator {
        private final LazyHashPassword oldPassword;

        public HashPasswordValidator(LazyHashPassword oldPassword) {
            this.oldPassword = oldPassword;
        }

        @Override
        public boolean matchesPassword(String newPassword) {
            return this.oldPassword.matches(newPassword);
        }
    }

    public static class StringPasswordValidator
    implements PasswordValidator {
        private final String oldPassword;

        public StringPasswordValidator(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        @Override
        public boolean matchesPassword(String newPassword) {
            return this.oldPassword.equals(newPassword);
        }
    }

    public static interface PasswordValidator {
        public boolean matchesPassword(String var1);
    }
}

