/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import utils.files.FileUtil;
import utils.message.Message;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ColorUtils;

public class BrandingSettings {
    public byte[] splashImagePNG = null;
    public byte[] favico = null;
    public String appName = null;
    public String supportExeFormat = null;
    public boolean supportExeKeepOS = true;
    public boolean supportExeKeepType = true;
    public Color supportAppHeaderColor;
    public Color webHeaderColor;
    public static final String PROP_SUPPORT_EXE = "SUPPORT_EXE_NAME";
    public static final String PROP_KEEP_OS = "SUPPORT_EXE_NAME_KEEP_OS";
    public static final String PROP_KEEP_TYPE = "SUPPORT_EXE_NAME_KEEP_TYPE";
    public static final String PROP_APP_NAME = "APPLICATION_NAME";
    public static final String PROP_COLOR_WEB = "COLOR_WEB_HEADER";
    public static final String PROP_COLOR_APP = "COLOR_APP_HEADER";

    public Message toMessage() {
        Message m = new Message();
        m.append(this.splashImagePNG);
        m.append(this.favico);
        m.append(this.appName);
        m.append(this.supportExeFormat);
        m.append(this.supportExeKeepOS);
        m.append(this.supportExeKeepType);
        m.append(this.supportAppHeaderColor.getRGB());
        m.append(this.webHeaderColor.getRGB());
        return m;
    }

    public static BrandingSettings fromMessage(Message m) {
        BrandingSettings settings = new BrandingSettings();
        settings.splashImagePNG = m.getNextByteArray();
        settings.favico = m.getNextByteArray();
        settings.appName = m.getNextString();
        settings.supportExeFormat = m.getNextString();
        settings.supportExeKeepOS = m.getNextBoolean();
        settings.supportExeKeepType = m.getNextBoolean();
        settings.supportAppHeaderColor = new Color(m.getNextInt());
        settings.webHeaderColor = new Color(m.getNextInt());
        return settings;
    }

    public void loadFromProperties(File propertiesFile) {
        if (propertiesFile == null || !propertiesFile.exists()) {
            return;
        }
        try {
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(FileUtil.readFile((File)propertiesFile)));
            String supportExeName = (String)props.get(PROP_SUPPORT_EXE);
            if (supportExeName != null) {
                this.supportExeFormat = (supportExeName = supportExeName.trim()).length() == 0 ? null : new String(this.convertToValidCDName(supportExeName.toCharArray()));
            }
            try {
                this.supportExeKeepOS = ((String)props.get(PROP_KEEP_OS)).equalsIgnoreCase("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.supportExeKeepType = ((String)props.get(PROP_KEEP_TYPE)).equalsIgnoreCase("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.appName = (String)props.get(PROP_APP_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.webHeaderColor = SHStyle.WEBPAGE_HEADER;
                this.webHeaderColor = Color.decode((String)props.get(PROP_COLOR_WEB));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.supportAppHeaderColor = Color.WHITE;
                this.supportAppHeaderColor = Color.decode((String)props.get(PROP_COLOR_APP));
            }
            catch (Exception exception) {}
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private char[] convertToValidCDName(char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == ' ' || cs[i] == '_' || cs[i] >= '0' && cs[i] <= '9' || cs[i] >= 'A' && cs[i] <= 'Z' || cs[i] >= 'a' && cs[i] <= 'z') continue;
            cs[i] = 95;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToPropertiesFile(File file) throws IOException {
        Properties props = new Properties();
        props.setProperty(PROP_SUPPORT_EXE, this.supportExeFormat);
        props.setProperty(PROP_KEEP_OS, Boolean.toString(this.supportExeKeepOS));
        props.setProperty(PROP_KEEP_TYPE, Boolean.toString(this.supportExeKeepType));
        props.setProperty(PROP_APP_NAME, this.appName);
        props.setProperty(PROP_COLOR_APP, ColorUtils.colorToHexRGBString((Color)this.supportAppHeaderColor));
        props.setProperty(PROP_COLOR_WEB, ColorUtils.colorToHexRGBString((Color)this.webHeaderColor));
        file.getParentFile().mkdirs();
        FileOutputStream fout = new FileOutputStream(file);
        try {
            props.store(fout, "SimpleHelp Branding Configuration");
        }
        finally {
            try {
                fout.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

