/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.details.RDPSessionRenderer;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jwrapper.jwutils.JWWindowsOS;
import utils.ostools.OS;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class RDPSessionTable {
    private SimpleList<JWWindowsOS.RDPSessionInfo> sessionList = new SimpleList();
    private SimpleTableModel model;
    private SHJTable table;
    private AccessPanelListener accessPanelListener;
    private RDPSessionRenderer rdpSessionRenderer;
    private Machine machine;

    public RDPSessionTable(MachineTreeModel model, AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    public JComponent getRootComponent() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessions(Machine machine, JWWindowsOS.RDPSessionInfo[] sessions) {
        this.machine = machine;
        this.sessionList.startBatch();
        try {
            this.sessionList.clear();
            if (sessions != null) {
                for (JWWindowsOS.RDPSessionInfo info : sessions) {
                    this.sessionList.add(info);
                }
            }
        }
        finally {
            this.sessionList.endBatch();
        }
    }

    private void initUI() {
        ConnectListener listener = new ConnectListener();
        TableStructure ts = TableStructure.createTableStructure(JWWindowsOS.RDPSessionInfo.class, new String[]{"username", "winStationName", "getStateAsString", ""}, new String[]{"", "", "", ""});
        this.model = new SimpleTableModel(this.sessionList, ts);
        this.table = new SHJTable(this.model);
        this.table.addMouseMotionListener(listener);
        this.table.addMouseListener(listener);
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.rdpSessionRenderer = new RDPSessionRenderer();
        this.table.setDefaultRenderer(Object.class, this.rdpSessionRenderer);
        this.table.setDefaultRenderer(Long.class, this.rdpSessionRenderer);
        ts.setMinWidths(this.rdpSessionRenderer.getFixedColumnSizes());
        ts.setMaxWidths(this.rdpSessionRenderer.getFixedColumnSizes());
        ts.initTableDimensions(this.table);
    }

    class ConnectListener
    implements MouseMotionListener,
    MouseListener {
        int hoverRow = -1;

        ConnectListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                if (e.getSource() == RDPSessionTable.this.table) {
                    int previousRow = this.hoverRow;
                    this.hoverRow = RDPSessionTable.this.table.rowAtPoint(e.getPoint());
                    if (this.hoverRow == previousRow) {
                        return;
                    }
                    this.repaintRows(this.hoverRow, previousRow);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void repaintRows(int hoverRow, int previousRow) {
            RDPSessionTable.this.rdpSessionRenderer.setHoverRow(hoverRow);
            if (hoverRow != -1) {
                RDPSessionTable.this.table.repaint(RDPSessionTable.this.table.getCellRect(hoverRow, 3, false));
            }
            if (previousRow != -1) {
                RDPSessionTable.this.table.repaint(RDPSessionTable.this.table.getCellRect(previousRow, 3, false));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Rectangle rect;
            int row = RDPSessionTable.this.table.rowAtPoint(e.getPoint());
            if (row == this.hoverRow && (rect = RDPSessionTable.this.table.getCellRect(row, 3, false)).contains(e.getPoint())) {
                JWWindowsOS.RDPSessionInfo rdpSessionInfo;
                int buttonWidth = ((RDPSessionTable)RDPSessionTable.this).rdpSessionRenderer.getButtonSize().width;
                if (OS.isOSXRetina()) {
                    buttonWidth /= 2;
                }
                if (e.getX() < rect.x + buttonWidth && (rdpSessionInfo = (JWWindowsOS.RDPSessionInfo)RDPSessionTable.this.sessionList.get(row)) != null && rdpSessionInfo.state == 1) {
                    if (e.getX() < rect.x + buttonWidth - RDPSessionTable.this.rdpSessionRenderer.getDropDownButtonWidth()) {
                        RDPSessionTable.this.accessPanelListener.connectToMachine(RDPSessionTable.this.machine, "" + rdpSessionInfo.sessionID);
                    } else {
                        JPopupMenu menu = RDPSessionTable.this.accessPanelListener.getMachineConnectionMenu(RDPSessionTable.this.machine, "" + rdpSessionInfo.sessionID);
                        menu.show(RDPSessionTable.this.table, e.getX(), e.getY());
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int previousRow = this.hoverRow;
            this.hoverRow = -1;
            this.repaintRows(this.hoverRow, previousRow);
        }
    }
}

