/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapTextAreaLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ProblemsPanel
extends GbPanel
implements ActionListener {
    private JPanel hashPanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
    private JPanel http10Panel = new ColorPropagatingPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
    private JPanel overLimitPanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
    private JPanel refusedUpdatePanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
    private JButton hashButton = new JButton();
    private JButton http10Button = new JButton();
    private JButton overLimitButton = new JButton();
    private JButton refusedUpdateRetryButton = new JButton();
    private JWrapTextAreaLabel hashLabel = new JWrapTextAreaLabel();
    private JWrapTextAreaLabel http10Label = new JWrapTextAreaLabel();
    private JWrapTextAreaLabel overLimitLabel = new JWrapTextAreaLabel();
    private JWrapTextAreaLabel refusedUpdateLabel = new JWrapTextAreaLabel();
    private TechClient techClient;
    private Machine machine;
    private HashSet<String> retryRefusedUpdateMachineIDs = new HashSet();

    public void setBackground(Color c) {
    }

    public void setBorder(Border b) {
    }

    public ProblemsPanel() {
        super(new ScaledInsets(3, 3, 3, 3));
        this.initUI();
    }

    private void initUI() {
        GbPanel rightPanel;
        super.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)1, (int)0, (Color)SHStyle.WARNING_GRADIENT_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3)));
        super.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.hashPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.http10Panel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.overLimitPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.refusedUpdatePanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        this.hashLabel.setText(Language.get("PROBLEM_HASH"));
        this.http10Label.setText(Language.get("PROBLEM_HTTP10"));
        this.overLimitLabel.setText(Language.get("OVER_MACHINE_LIMIT"));
        this.refusedUpdateLabel.setText(Language.get("REFUSED_UPDATE"));
        this.hashLabel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        this.http10Label.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        this.overLimitLabel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        this.refusedUpdateLabel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        this.hashPanel.add((Component)this.hashLabel, "Center");
        this.http10Panel.add((Component)this.http10Label, "Center");
        this.overLimitPanel.add((Component)this.overLimitLabel, "Center");
        this.refusedUpdatePanel.add((Component)this.refusedUpdateLabel, "Center");
        if (OemBranding.OEM_IS_SH) {
            rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add((Component)this.hashButton, 0, 0, 1, 1, 0, 0, 10, 0);
            this.hashPanel.add((Component)rightPanel, "East");
            rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add((Component)this.http10Button, 0, 0, 1, 1, 0, 0, 10, 0);
            this.http10Panel.add((Component)rightPanel, "East");
            rightPanel = new GbPanel();
            rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
            rightPanel.add((Component)this.overLimitButton, 0, 0, 1, 1, 0, 0, 10, 0);
            this.overLimitPanel.add((Component)rightPanel, "East");
        }
        rightPanel = new GbPanel();
        rightPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        rightPanel.add((Component)this.refusedUpdateRetryButton, 0, 0, 1, 1, 0, 0, 10, 0);
        this.refusedUpdatePanel.add((Component)rightPanel, "East");
        JLabel iconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        GbPanel leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add((Component)iconLabel, 0, 0, 1, 1, 0, 0, 11, 0);
        this.hashPanel.add((Component)leftPanel, "West");
        iconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add((Component)iconLabel, 0, 0, 1, 1, 0, 0, 10, 0);
        this.http10Panel.add((Component)leftPanel, "West");
        iconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add((Component)iconLabel, 0, 0, 1, 1, 0, 0, 10, 0);
        this.overLimitPanel.add((Component)leftPanel, "West");
        iconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        leftPanel = new GbPanel();
        leftPanel.setBackground(SHStyle.WARNING_GRADIENT_COLOR_LIGHTER);
        leftPanel.add((Component)iconLabel, 0, 0, 1, 1, 0, 0, 10, 0);
        this.refusedUpdatePanel.add((Component)leftPanel, "West");
        this.add(this.hashPanel, 0, 0, 1, 1, 1, 1, 10, 2);
        this.add(this.http10Panel, 0, 1, 1, 1, 1, 1, 10, 2);
        this.add(this.overLimitPanel, 0, 2, 1, 1, 1, 1, 10, 2);
        this.add(this.refusedUpdatePanel, 0, 3, 1, 1, 1, 1, 10, 2);
        this.hashButton.setToolTipText(Language.get("FIND_OUT_MORE"));
        this.http10Button.setToolTipText(Language.get("FIND_OUT_MORE"));
        this.overLimitButton.setText(Language.get("UPGRADE"));
        this.refusedUpdateRetryButton.setText(Language.get("RETRY"));
        this.hashButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"));
        this.http10Button.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"));
        this.overLimitButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/right.svg,16"));
        this.hashButton.addActionListener(this);
        this.http10Button.addActionListener(this);
        this.overLimitButton.addActionListener(this);
        this.refusedUpdateRetryButton.addActionListener(this);
    }

    public void initFor(Machine machine, TechClient client) {
        this.machine = machine;
        this.techClient = client;
        if (machine != null) {
            this.hashPanel.setVisible(machine.isProblemHashMismatch());
            this.http10Panel.setVisible(machine.isProblemHTTP_1_0());
            this.refusedUpdatePanel.setVisible(machine.isProblemUpdateRefused());
            if (machine.getMachineID() != null) {
                this.refusedUpdateRetryButton.setEnabled(!this.retryRefusedUpdateMachineIDs.contains(machine.getMachineID()));
            }
        } else {
            this.hashPanel.setVisible(false);
            this.http10Panel.setVisible(false);
            this.refusedUpdatePanel.setVisible(false);
        }
        if (client != null) {
            this.overLimitPanel.setVisible(client.amOverMachineLimit());
        } else {
            this.overLimitPanel.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hashButton) {
            SHWebsiteURLUtil.launchTroubleShootingServerID();
        } else if (e.getSource() == this.http10Button) {
            SHWebsiteURLUtil.launchTroubleShootingHTTP10Page();
        } else if (e.getSource() == this.overLimitButton) {
            if (this.techClient.getServerLicenses().isVersion2Business()) {
                TrialUtils.entUpgradeRequestPopup(SwingUtil.getRootPaneContainer((Component)((Object)this)), (Component)((Object)this), this.techClient);
            } else {
                TrialUtils.bizUpgradeRequestPopup(SwingUtil.getRootPaneContainer((Component)((Object)this)), (Component)((Object)this), this.techClient);
            }
        } else if (e.getSource() == this.refusedUpdateRetryButton) {
            try {
                this.retryRefusedUpdateMachineIDs.add(this.machine.getMachineID());
                this.refusedUpdateRetryButton.setEnabled(false);
                TechUi.TECH_THREAD_POOL.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProblemsPanel.this.techClient.requestRefusedUpdateRetry(ProblemsPanel.this.machine.getMachineID());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

