/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.common.IPC;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.tech.TechHelpUIArguments;
import com.aem.shelp.tech.TechHelpUi;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import utils.message.BasicSTTransactionClient;
import utils.message.BasicSTTransactionServer;
import utils.message.Message;
import utils.message.TransactionListener;
import utils.progtools.Cleanable;
import utils.switches.Switches;

public class TechHelpUIIPCHandler
extends Thread
implements JWSockIPCListener,
TransactionListener,
Cleanable {
    private BasicSTTransactionClient transactionClient;
    private BasicSTTransactionServer transactionServer;
    public static TechHelpUIIPCHandler INSTANCE;
    private ArrayList<JWSockIPCListener> additionalListeners = new ArrayList();
    JWSockIPC ipc;

    public TechHelpUIIPCHandler() {
        super("TechHelpUIIPCHandler");
        INSTANCE = this;
        this.start();
    }

    public void addAdditionalSockIPCListener(JWSockIPCListener listener) {
        this.additionalListeners.add(listener);
    }

    public void sendNewSessionProperties(byte[] sessionProperties) throws IOException {
        Message message = new Message(4096);
        message.append(sessionProperties);
        if (this.transactionClient != null) {
            this.transactionClient.doTransaction(message);
        }
    }

    public void notifyNewSessionID(byte[] sessionID) throws IOException {
        Message message = new Message(4103);
        message.append(sessionID);
        if (this.transactionClient != null) {
            this.transactionClient.doTransaction(message);
        }
    }

    public void setConnected() throws IOException {
        Message message = new Message(4099);
        if (this.transactionClient != null) {
            this.transactionClient.doTransaction(message);
        }
    }

    public void sendHeadlessMessage(String text) throws IOException {
        Message message = new Message(4098);
        message.append(text);
        if (this.transactionClient != null) {
            this.transactionClient.doTransaction(message);
        }
    }

    public void sendPortForwardPort(int localPort) throws IOException {
        Message message = new Message(4100);
        message.append(localPort);
        if (this.transactionClient != null) {
            this.transactionClient.doTransaction(message);
        }
    }

    public String[][] getGroupList() throws IOException {
        Message m = new Message(4097);
        m = this.transactionClient.doTransaction(m);
        int length = m.length();
        String[][] result = new String[length][];
        for (int i = 0; i < length; ++i) {
            result[i] = m.getNextStringArray();
        }
        return result;
    }

    public String requestMachinePassword() throws IOException {
        Message m = new Message(4101);
        m = this.transactionClient.doTransaction(m);
        return m.getNextString();
    }

    @Override
    public void run() {
        try {
            this.ipc = JWSockIPC.connectChild();
            this.ipc.setupMultipleChannels();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        this.ipc.setupPingsAndReportClosure((JWSockIPCListener)this, (short)999, 20000L);
        OutputStream outChannel = this.ipc.getOutChannel(IPC.SESSION_UI_IPC_MESSAGE_CHANNEL);
        InputStream inChannel = this.ipc.getInChannel(IPC.SESSION_UI_IPC_MESSAGE_CHANNEL);
        this.transactionClient = new BasicSTTransactionClient(inChannel, outChannel);
        if (Switches.SH_tabbedSessions && !Switches.SH_sessionsInTechUiProcess) {
            outChannel = this.ipc.getOutChannel(IPC.SESSION_UI_IPC_LAUNCH_CHANNEL);
            inChannel = this.ipc.getInChannel(IPC.SESSION_UI_IPC_LAUNCH_CHANNEL);
            this.transactionServer = new BasicSTTransactionServer(inChannel, outChannel, this);
        }
    }

    public void ipcClosed() {
        System.out.println("[TechHelpUIIPCHandler] IPC Closed.");
        this.die();
        for (JWSockIPCListener listener : this.additionalListeners) {
            listener.ipcClosed();
        }
    }

    private void die() {
        this.transactionClient = null;
    }

    @Override
    public Message doTransaction(Message m) throws Exception {
        Message ret;
        int type = m.getType();
        if (type == 4102) {
            byte[] dat = m.getNextByteArray();
            TechHelpUIArguments args = new TechHelpUIArguments(dat);
            ProxyConnectSettings proxyConnectSettings = ProxyConnectSettings.getProxyConnectSettingsForTechHelpUI(args);
            TechHelpUi.launchAdditionalSession(proxyConnectSettings);
            ret = new Message(1);
        } else {
            ret = new Message(-1);
            ret.append("Tech IPC tequest type not recognised: " + type);
        }
        return ret;
    }

    public void cleanupNow() {
        try {
            this.ipc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.die();
    }
}

