/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.GUI;

public class ActivityTracker
extends Thread {
    public static ActivityTracker INSTANCE;
    private final GUI gui;
    private long maxTimeout;
    private long lastActivity = System.currentTimeMillis();
    private boolean die = false;

    public ActivityTracker(long maxTimeout, GUI gui) {
        System.out.println("[ActivityTracker] Initialising with maxTimeout of " + maxTimeout);
        INSTANCE = this;
        this.gui = gui;
        this.maxTimeout = maxTimeout;
        if (maxTimeout > 0L) {
            this.start();
        }
    }

    public static void touch() {
        if (INSTANCE != null) {
            INSTANCE.touchTime();
        }
    }

    private void touchTime() {
        if (CentralDebugging.ACTIVITY_TRACKER_DEBUG) {
            System.out.println("[ActivityTracker] Reset");
        }
        this.lastActivity = System.currentTimeMillis();
    }

    @Override
    public void run() {
        ActivityTracker.touch();
        while (!this.die) {
            try {
                long diff = System.currentTimeMillis() - this.lastActivity;
                diff = this.maxTimeout - diff;
                if (diff > 0L) {
                    if (CentralDebugging.ACTIVITY_TRACKER_DEBUG) {
                        System.out.println("[ActivityTracker] Sleeping " + diff);
                    }
                    Thread.sleep(diff);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.die) {
                return;
            }
            if (System.currentTimeMillis() - this.lastActivity <= this.maxTimeout) continue;
            this.die = true;
            this.timeoutExceeded();
        }
    }

    public void timeoutExceeded() {
        System.out.println("[ActivityTracker] Inactivity session timeout exceeded");
        this.gui.timeoutSession();
    }

    public void die() {
        this.die = true;
    }
}

