/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.filters;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineGroupNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.MachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNodeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import utils.message.Message;
import utils.xml.XML14Util;

public class SimpleMachineFilter
implements SimpleMachineNodeListener {
    private final MachineGroupNode filterStateGroupTree;
    private transient HashMap<String, MachineNode> machineIDToMachineNode = new HashMap();
    private int totalIncludes = 0;
    private int totalExcludes = 0;

    public SimpleMachineFilter() {
        this.filterStateGroupTree = new MachineGroupNode((SimpleMachineNodeListener)this, "ROOT");
    }

    public SimpleMachineFilter(Message m) {
        this.filterStateGroupTree = new MachineGroupNode((SimpleMachineNodeListener)this, m);
    }

    public static String getRootTag() {
        return "SimpleMachineFilter";
    }

    public MachineGroupNode getGroupTree() {
        return this.filterStateGroupTree;
    }

    public void groundWith(MachineTreeModel model) {
        this.filterStateGroupTree.groundWith(model);
    }

    public void saveToXML(StringBuffer buffer, int indentationTabs) {
        if (this.filterStateGroupTree.getChildCount() == 0) {
            return;
        }
        buffer.append(XML14Util.getIndent((int)indentationTabs)).append("<SimpleMachineFilter>\n");
        buffer.append(XML14Util.getIndent((int)(indentationTabs + 1))).append("<Groups>\n");
        for (MachineGroupNode machineGroupNode : this.filterStateGroupTree.getGroups()) {
            this.appendToXML(buffer, indentationTabs + 2, machineGroupNode);
        }
        for (MachineNode machineNode : this.filterStateGroupTree.getMachines()) {
            this.appendToXML(buffer, indentationTabs + 2, machineNode);
        }
        buffer.append(XML14Util.getIndent((int)(indentationTabs + 1))).append("</Groups>\n");
        buffer.append(XML14Util.getIndent((int)indentationTabs)).append("</SimpleMachineFilter>\n");
    }

    private void appendToXML(StringBuffer buffer, int indentationTabs, SimpleMachineNode filter) {
        if (filter instanceof MachineGroupNode) {
            MachineGroupNode machineFilter = (MachineGroupNode)filter;
            buffer.append(XML14Util.getIndent((int)(indentationTabs + 1))).append("<Group name=\"").append(machineFilter.groupName).append("\"");
            if (machineFilter.getState() != null) {
                buffer.append(" state=\"").append(machineFilter.getState()).append("\"");
            }
            buffer.append(">\n");
            for (MachineGroupNode machineGroupNode : machineFilter.getGroups()) {
                this.appendToXML(buffer, indentationTabs + 2, machineGroupNode);
            }
            for (MachineNode machineNode : machineFilter.getMachines()) {
                this.appendToXML(buffer, indentationTabs + 2, machineNode);
            }
            buffer.append(XML14Util.getIndent((int)(indentationTabs + 1))).append("</Group>\n");
        } else if (filter instanceof MachineNode) {
            MachineNode machineFilter = (MachineNode)filter;
            buffer.append(XML14Util.getIndent((int)(indentationTabs + 1))).append("<Machine id=\"").append(machineFilter.machineID).append("\"");
            if (machineFilter.getState() != null) {
                buffer.append(" state=\"").append(machineFilter.getState()).append("\"");
            }
            buffer.append("/>\n");
        }
    }

    private void loadGroupFromXML(Element groupElement, MachineGroupNode result) {
        String state = groupElement.getAttribute("state");
        if (state != null && state.length() > 0) {
            result.setState(Boolean.parseBoolean(state));
        }
        ArrayList groupsList = XML14Util.getChildrenByName((Element)groupElement, (String)"Group");
        for (Element aGroupsList : groupsList) {
            MachineGroupNode node = new MachineGroupNode((SimpleMachineNodeListener)this, aGroupsList.getAttribute("name"));
            this.loadGroupFromXML(aGroupsList, node);
            result.addChild(node);
        }
        ArrayList machinesList = XML14Util.getChildrenByName((Element)groupElement, (String)"Machine");
        for (Element aMachine : machinesList) {
            result.addChild(this.loadMachineFromXML(aMachine));
        }
    }

    private MachineNode loadMachineFromXML(Element machineElement) {
        MachineNode node = new MachineNode(this, null, machineElement.getAttribute("id"));
        String state = machineElement.getAttribute("state");
        if (state != null && state.length() > 0) {
            node.setState(Boolean.parseBoolean(state));
        }
        return node;
    }

    public void loadFromXML(Element childElement) {
        Element includeRoot = XML14Util.getChildByName((Element)childElement, (String)"Groups");
        if (includeRoot != null) {
            this.loadGroupFromXML(includeRoot, this.filterStateGroupTree);
        }
    }

    public static Message toMessage(SimpleMachineFilter filters) {
        Message m = new Message();
        m.append(filters.filterStateGroupTree.toMessage());
        return m;
    }

    public static SimpleMachineFilter fromMessage(Message m) {
        if (m == null) {
            return null;
        }
        return new SimpleMachineFilter(m.getNextMessage());
    }

    public boolean containsAnyIncludes() {
        return this.totalIncludes > 0;
    }

    public Boolean getStateFor(Machine machine, boolean checkParents) {
        MachineNode node = this.machineIDToMachineNode.get(machine.getID());
        if (node != null && node.getState() != null) {
            return node.getState();
        }
        if (checkParents) {
            String[] path = machine.getName().getGroup();
            return this.filterStateGroupTree.getMostRecentStateForPath(path);
        }
        return null;
    }

    public Boolean getStateFor(TreeElement element, boolean checkParents) {
        if (element instanceof Machine) {
            return this.getStateFor((Machine)element, checkParents);
        }
        return this.getStateFor((MachineGroup)((Object)element), checkParents);
    }

    public Boolean getStateFor(MachineGroup machine, boolean checkParents) {
        String[] path = SimpleMachineFilter.getPathToRootFor(machine);
        return this.getStateFor(path, checkParents);
    }

    public Boolean getStateFor(String[] groupPath, boolean checkParents) {
        if (checkParents) {
            return this.filterStateGroupTree.getMostRecentStateForPath(groupPath);
        }
        MachineGroupNode node = this.filterStateGroupTree.getMachineGroupNodeFor(groupPath);
        if (node == null) {
            return null;
        }
        return node.getState();
    }

    public void set(Machine m, Boolean state) {
        String[] groupPath = m.getMachineName().getGroup();
        MachineGroupNode parentNode = this.filterStateGroupTree.createPath(groupPath);
        MachineNode machineNode = parentNode.createMachineFor(m.getMachineName().getName(), m.getMachineID());
        machineNode.setState(state);
    }

    public static String[] getPathToRootFor(MachineGroup group) {
        ArrayList<String> pathToRoot = new ArrayList<String>();
        MachineGroup[] machineGroupPath = group.getPathToRoot();
        for (int i = 1; i < machineGroupPath.length; ++i) {
            pathToRoot.add(machineGroupPath[i].groupName);
        }
        return pathToRoot.toArray(new String[0]);
    }

    public void set(MachineGroup group, Boolean state) {
        String[] path = SimpleMachineFilter.getPathToRootFor(group);
        MachineGroupNode parentNode = this.filterStateGroupTree.createPath(path);
        parentNode.setState(state);
    }

    public void set(String[] groupPath, Boolean state) {
        MachineGroupNode parentNode = this.filterStateGroupTree.createPath(groupPath);
        parentNode.setState(state);
    }

    private MachineGroupNode getMatching(ArrayList<MachineGroupNode> groups, MachineGroup group) {
        for (MachineGroupNode node : groups) {
            if (!node.groupName.equals(group.groupName)) continue;
            return node;
        }
        return null;
    }

    public void set(TreeElement element, Boolean state) {
        if (element instanceof MachineGroup) {
            this.set((MachineGroup)((Object)element), state);
        } else if (element instanceof Machine) {
            this.set((Machine)element, state);
        }
    }

    @Override
    public void nodeAdded(SimpleMachineNode group) {
        if (group.getState() != null) {
            if (group.getState().booleanValue()) {
                ++this.totalIncludes;
            } else {
                ++this.totalExcludes;
            }
        }
        if (group instanceof MachineNode) {
            MachineNode machineNode = (MachineNode)group;
            this.machineIDToMachineNode.put(machineNode.machineID, machineNode);
        }
    }

    @Override
    public void stateChanged(SimpleMachineNode simpleMachineNode, Boolean old, Boolean state) {
        if (old == state) {
            return;
        }
        if (old != null) {
            if (old.booleanValue()) {
                --this.totalIncludes;
            } else {
                --this.totalExcludes;
            }
        }
        if (state != null) {
            if (state.booleanValue()) {
                ++this.totalIncludes;
            } else {
                ++this.totalExcludes;
            }
        }
    }

    @Override
    public void nodeRemoved(SimpleMachineNode group) {
        if (group.getState() != null) {
            if (group.getState().booleanValue()) {
                --this.totalIncludes;
            } else {
                --this.totalExcludes;
            }
        }
        if (group instanceof MachineNode) {
            this.machineIDToMachineNode.remove(((MachineNode)group).machineID);
        }
    }

    public int getTotalIncludes() {
        return this.totalIncludes;
    }

    public int getTotalExcludes() {
        return this.totalExcludes;
    }

    public boolean isEmpty() {
        return this.totalIncludes + this.totalExcludes == 0;
    }

    public SimpleNodeIterator getNodeIterator() {
        return new SimpleNodeIterator(this.filterStateGroupTree);
    }

    public class SimpleNodeIterator
    implements Iterator<SimpleMachineNode> {
        private SimpleMachineNode next;
        private LinkedList<SimpleMachineNode> stack = new LinkedList();
        private int index = 0;

        public SimpleNodeIterator(MachineGroupNode parent) {
            this.stack.add(parent);
        }

        @Override
        public boolean hasNext() {
            this.next = null;
            while (this.stack.size() > 0) {
                this.next = this.stack.remove();
                if (this.next instanceof MachineNode) {
                    return true;
                }
                MachineGroupNode groupNode = (MachineGroupNode)this.next;
                for (int i = 0; i < groupNode.getChildCount(); ++i) {
                    this.stack.add((SimpleMachineNode)groupNode.getChildByIndex(i));
                }
                if (this.next.getState() == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public SimpleMachineNode next() {
            return this.next;
        }

        @Override
        public void remove() {
        }
    }
}

