/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.net.Socket;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.TypedMap;

public class TcpAccessibleThreshold
extends Alert {
    public static final Object ID = "TcpAccessibleTrigger";
    String host = "";
    int port = 80;
    boolean accessible = true;
    String matched;
    String reason;
    public static final String KEY_CONNECT_MS = "${CONTEXT_KEY_TCP_CONNECT_MS}";
    long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_TCP_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_TCP_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/monolith.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.accessible) {
            return Language.get("ALERT_TCP_ACCESSIBLE", this.host + ":" + this.port);
        }
        return Language.get("ALERT_TCP_NOTACCESSIBLE", this.host + ":" + this.port);
    }

    @Override
    public Alert createCorollary() {
        TcpAccessibleThreshold clone = (TcpAccessibleThreshold)this.cloneWithNewID();
        clone.accessible = !clone.accessible;
        return clone;
    }

    public void setTriggerOn(String host, int port, boolean isAccessible) {
        this.host = host;
        this.port = port;
        this.accessible = isAccessible;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getTriggerIfAccessible() {
        return this.accessible;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.host);
        m.append(this.port);
        m.append(this.accessible);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.host = m.getNextString();
        this.port = m.getNextInt();
        this.accessible = m.getNextBoolean();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_CONNECT_MS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_CONNECT_MS, this.matched);
        return map;
    }

    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        if (now - this.lastChecked > 30000L) {
            this.lastChecked = now;
            long ms = System.currentTimeMillis();
            boolean through = false;
            try {
                new Socket(this.host, this.port);
                through = true;
                ms = System.currentTimeMillis() - ms;
                this.reason = "${TCP_CONNECT_OK} (" + this.host + ":" + this.port + " " + ms + " ms)";
                this.matched = ms + "";
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " (" + this.accessible + ") connected OK to " + this.host + ":" + this.port + " (" + through + ")");
                }
            }
            catch (Exception x) {
                this.reason = "${TCP_CONNECT_FAILED} (" + this.host + ":" + this.port + " " + x + ")";
                this.matched = null;
            }
            boolean state = false;
            if (through && this.accessible) {
                state = true;
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " state is triggered (1)");
                }
            }
            if (!through && !this.accessible) {
                state = true;
                if (CentralDebugging.ALERT_TCP_VERBOSE) {
                    System.out.println("[TcpAccessible] " + this.getName() + " state is triggered (2)");
                }
            }
            if (!state && CentralDebugging.ALERT_TCP_VERBOSE) {
                System.out.println("[TcpAccessible] " + this.getName() + " state is reset");
            }
            this.updateTriggeredState(state);
        }
    }
}

