/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.TypedMap;
import utils.string.SimpleRegex;

public class FileAccessibleThreshold
extends Alert {
    private long lastSearched = 0L;
    private String searchFolder = "";
    private String nameMatch = null;
    private boolean exists = true;
    public static final Object ID = "FileAccessibleTrigger";
    String matched;
    String reason;
    public static final String KEY_MATCHED = "${CONTEXT_KEY_MATCHED_FILE}";

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_MATCHED);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_MATCHED, this.matched);
        return map;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_FILE_ACCESS_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_FILE_ACCESS_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/ok.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.exists) {
            return Language.get("ALERT_FILE_EXISTS", this.nameMatch, this.searchFolder);
        }
        return Language.get("ALERT_FILE_NOTEXISTS", this.nameMatch, this.searchFolder);
    }

    @Override
    public Alert createCorollary() {
        FileAccessibleThreshold clone = (FileAccessibleThreshold)this.cloneWithNewID();
        clone.exists = !clone.exists;
        return clone;
    }

    public void setTriggerOnFileExists(String searchFolder, String nameMatch, boolean exists) {
        this.searchFolder = searchFolder;
        this.nameMatch = nameMatch;
        this.exists = exists;
        if (this.nameMatch != null) {
            this.nameMatch = this.nameMatch.trim();
        }
    }

    public boolean getTriggerIfExists() {
        return this.exists;
    }

    public String getSearchFolder() {
        return this.searchFolder;
    }

    public String getNameMatch() {
        return this.nameMatch;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.searchFolder);
        m.append(this.nameMatch);
        m.append(this.exists);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.searchFolder = m.getNextString();
        this.nameMatch = m.getNextString();
        this.exists = m.getNextBoolean();
    }

    @Override
    public void timePassed() {
        boolean STATE;
        boolean doSearch;
        long now = SafeClock.currentTimeMillis();
        boolean bl = doSearch = this.nameMatch.contains("*") || this.nameMatch.contains("?");
        if (doSearch) {
            if (now - this.lastSearched < 120000L) {
                if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                    System.out.println("[FileAccessibleThreshold] Skipping search as we did one recently.");
                }
                return;
            }
            this.lastSearched = now;
            if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                System.out.println("[FileAccessibleThreshold] Searching for match in " + this.searchFolder);
            }
            StringBuffer path = new StringBuffer();
            boolean found = this.search(new File(this.searchFolder), path);
            if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                System.out.println("[FileAccessibleThreshold] found: " + found + " exists:" + this.exists);
            }
            if (found && this.exists) {
                this.matched = path.toString();
                this.reason = "${FILE} " + path.toString() + " ${EXISTS}";
                STATE = true;
            } else if (!found && !this.exists) {
                this.matched = null;
                this.reason = "${FILE} ${DOES_NOT_EXIST}";
                STATE = true;
            } else {
                if (this.exists) {
                    this.matched = null;
                    this.reason = "${FILE} ${DOES_NOT_EXIST}";
                } else {
                    this.matched = path.toString();
                    this.reason = "${FILE} " + path.toString() + " ${EXISTS}";
                }
                STATE = false;
            }
        } else {
            File fileToCheck;
            if (this.nameMatch.length() == 0) {
                fileToCheck = new File(this.searchFolder);
                if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                    System.out.println("[FileAccessibleThreshold] Searching folder " + fileToCheck);
                }
            } else {
                fileToCheck = new File(this.searchFolder, this.nameMatch);
                if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                    System.out.println("[FileAccessibleThreshold] Searching file " + fileToCheck);
                }
            }
            if (CentralDebugging.ALERT_FILE_ACCESSIBLE_DEBUG) {
                System.out.println("[FileAccessibleThreshold] found: " + fileToCheck.exists() + " exists:" + this.exists);
            }
            this.matched = fileToCheck.getAbsolutePath();
            if (fileToCheck.exists()) {
                if (this.exists) {
                    this.reason = "${FILE} " + fileToCheck.getAbsolutePath() + " ${EXISTS}";
                    STATE = true;
                } else {
                    this.reason = "${FILE} " + fileToCheck.getAbsolutePath() + " ${DOES_NOT_EXIST}";
                    STATE = false;
                }
            } else if (!this.exists) {
                this.reason = "${FILE} " + fileToCheck.getAbsolutePath() + " ${DOES_NOT_EXIST}";
                STATE = true;
            } else {
                this.reason = "${FILE} " + fileToCheck.getAbsolutePath() + " ${EXISTS}";
                STATE = false;
            }
        }
        this.updateTriggeredState(STATE);
    }

    private boolean search(File folder, StringBuffer path) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!this.search(file, path)) continue;
                    return true;
                }
                if (!SimpleRegex.simpleToPattern(this.nameMatch, false).matcher(file.getName()).matches()) continue;
                path.setLength(0);
                path.append(file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }
}

