/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;

public class CPUThreshold
extends Alert
implements SimplePercentThreshold {
    public static final String ID = "CPUTrigger";
    String reason;
    NumberFormat pf = NumberFormat.getPercentInstance();
    double trig = 90.0;
    boolean over = true;
    DecimalFormat df = new DecimalFormat("########0.0");
    public static final String KEY_CPU = "${CONTEXT_KEY_CPU}";
    public static final String KEY_CPU_PROCS = "${CONTEXT_KEY_CPU_PROCS}";
    String cpuProcs;
    double cpuUsage = -99.0;

    @Override
    public Alert createCorollary() {
        CPUThreshold clone = (CPUThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_CPU_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_CPU_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/charts/meter.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_CPU_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        double dVal = this.trig / 100.0;
        String value = (double)Math.round(dVal) == dVal ? this.pf.format((long)dVal) : this.pf.format(dVal);
        if (this.over) {
            return Language.get("ALERT_CPU_OVER", value);
        }
        return Language.get("ALERT_CPU_UNDER", value);
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_CPU);
        keys.add(KEY_CPU_PROCS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_CPU, this.df.format(this.cpuUsage));
        map.setString(KEY_CPU_PROCS, this.cpuProcs);
        return map;
    }

    @Override
    public void machineStats(Stats stats) {
        boolean ON;
        if (stats.getCpuUsagePercent() > this.trig) {
            ON = this.over;
            this.reason = "${ALERT_CONTEXT_CPU} " + stats.getCpuUsagePercent() + "% > " + this.trig + "%";
        } else {
            ON = !this.over;
            this.reason = "${ALERT_CONTEXT_CPU} " + stats.getCpuUsagePercent() + "% < " + this.trig + "%";
        }
        this.cpuUsage = stats.getCpuUsagePercent();
        Stats.ProcessStatistic[] procs = (Stats.ProcessStatistic[])stats.getProcessStatistics().clone();
        Arrays.sort(procs, new Comparator<Stats.ProcessStatistic>(){

            @Override
            public int compare(Stats.ProcessStatistic o1, Stats.ProcessStatistic o2) {
                Integer i1 = o1.cpuPercentage;
                Integer i2 = o2.cpuPercentage;
                return i2.compareTo(i1);
            }
        });
        int documented = 0;
        HashMap<String, String> pids = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < procs.length; ++i) {
            String PID = "" + procs[i].id;
            if (!pids.containsKey(PID)) {
                pids.put(PID, PID);
                ++documented;
                sb.append(procs[i].cpuPercentage).append("%");
                sb.append(" ").append(procs[i].name);
                sb.append(" (").append(procs[i].id).append(")");
                sb.append(" [").append(procs[i].cmdLineArgs).append("]");
                sb.append("\n\n");
            }
            if (documented >= 15) break;
        }
        this.cpuProcs = sb.toString();
        this.updateTriggeredState(ON);
    }
}

