/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import java.util.Arrays;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.string.SafeCmp;

public class MachineName
implements Comparable<MachineName> {
    private String name;
    private String[] group = new String[0];

    public MachineName(String name) {
        this.name = name;
    }

    public MachineName(String name, String[] group) {
        this.name = name;
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGroup() {
        return this.group;
    }

    public String getParentGroup() {
        if (this.group == null || this.group.length == 0) {
            return null;
        }
        return this.group[this.group.length - 1];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof MachineName) {
            boolean secondEmpty;
            MachineName mName = (MachineName)o;
            if (!mName.name.equals(this.name)) {
                return false;
            }
            boolean firstEmpty = mName.group == null || mName.group.length == 0;
            boolean bl = secondEmpty = this.group == null || this.group.length == 0;
            if (firstEmpty && secondEmpty) {
                return true;
            }
            if (!firstEmpty && !secondEmpty) {
                return SafeCmp.equal(mName.group, this.group);
            }
            return false;
        }
        return false;
    }

    public static String[] parseGroups(String groupString) {
        if (groupString == null) {
            return null;
        }
        String delim = "/";
        String esc = "\\";
        String regex = "(?<!" + Pattern.quote(esc) + ")" + Pattern.quote(delim);
        String[] result = groupString.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].replace(esc + delim, delim);
        }
        return result;
    }

    public static MachineName extractFromNameWithGroup(String nameWithGroup) {
        if (nameWithGroup == null) {
            return null;
        }
        int lastSlash = nameWithGroup.lastIndexOf(47);
        if (lastSlash == -1) {
            return new MachineName(nameWithGroup, null);
        }
        String delim = "/";
        String esc = "\\";
        String regex = "(?<!" + Pattern.quote(esc) + ")" + Pattern.quote(delim);
        String[] result = nameWithGroup.split(regex);
        String[] group = new String[result.length - 1];
        for (int i = 0; i < group.length; ++i) {
            group[i] = result[i].replace(esc + delim, delim);
        }
        return new MachineName(result[result.length - 1], group);
    }

    public String toString() {
        if (this.group == null || this.group.length == 0) {
            return this.name;
        }
        StringBuilder buffer = new StringBuilder();
        for (String g : this.group) {
            buffer.append(g.replace("/", "\\/")).append("/");
        }
        buffer.append(this.name);
        return buffer.toString();
    }

    public static MachineName fromMessage(Message m) {
        String name = m.getNextString();
        int groupCount = m.getNextByte();
        String[] group = new String[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            group[i] = m.getNextString();
        }
        return new MachineName(name, group);
    }

    public void toMessage(Message m) {
        m.append(this.name);
        if (this.group == null) {
            m.append((byte)0);
        } else {
            m.append((byte)this.group.length);
            for (String aGroup : this.group) {
                m.append(aGroup);
            }
        }
    }

    @Override
    public int compareTo(MachineName o) {
        return this.toString().toLowerCase().compareTo(o.toString().toLowerCase());
    }

    public boolean isInGroup() {
        return this.group != null && this.group.length > 0;
    }

    public void setGroup(String[] groupPath) {
        this.group = groupPath;
    }

    public String getGroupString() {
        return MachineName.toGroupString(this.group);
    }

    public static String toGroupString(String[] group) {
        if (group == null) {
            return null;
        }
        return MachineName.toGroupString(group, group.length);
    }

    public static String toGroupString(String[] group, int numberOfGroupsToUse) {
        if (group == null || group.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numberOfGroupsToUse; ++i) {
            if (i > 0) {
                buffer.append("/");
            }
            buffer.append(group[i].replace("/", "\\/"));
        }
        return buffer.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInGroup(String[] parentGroup) {
        if (!(parentGroup != null && parentGroup.length != 0 || this.group != null && this.group.length != 0)) {
            return true;
        }
        if (parentGroup == null || this.group == null) {
            return false;
        }
        return Arrays.equals(this.group, parentGroup);
    }

    public boolean isInDescendentGroup(String[] parentGroup) {
        if (this.group == null || this.group.length == 0) {
            return false;
        }
        int parentGroupLength = 0;
        if (parentGroup != null) {
            parentGroupLength = parentGroup.length;
        }
        if (this.group.length <= parentGroupLength) {
            return false;
        }
        for (int i = 0; i < parentGroupLength; ++i) {
            if (parentGroup[i].equals(this.group[i])) continue;
            return false;
        }
        return true;
    }
}

