/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.proxy.alerts.AlertRegistryAPI;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.LocatedResource;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.alertlocs.ServerSideAloc;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import java.util.ArrayList;
import java.util.Random;
import utils.loggingframework.targets.AbstractTarget;
import utils.message.Message;
import utils.string.StringUtil;

public class LocatedAlert
extends LocatedResource {
    public static final String SERIALISATION_ID = "LocatedAlert";
    private Alert alert;
    private final Object triggered_LOCK = new Object();
    private ArrayList<String> triggeredMachines = new ArrayList();
    private transient Object uiMetadata = null;
    private MachineName name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMachineTriggered(String id) {
        Object object = this.triggered_LOCK;
        synchronized (object) {
            return this.triggeredMachines.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asmMachineTriggered(String id) {
        Object object = this.triggered_LOCK;
        synchronized (object) {
            if (!this.triggeredMachines.contains(id)) {
                this.triggeredMachines.add(id);
            }
            this.alert.setTriggeredState(this.triggeredMachines.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asmMachineReset(String id) {
        Object object = this.triggered_LOCK;
        synchronized (object) {
            this.triggeredMachines.remove(id);
            this.alert.setTriggeredState(this.triggeredMachines.size() == 0);
        }
    }

    @Override
    public void setLocation(AlertLocation loc, AlertRegistryAPI reg) {
        this.aloc = loc;
        if (reg != null) {
            this.alert.updateModifiedClock(reg);
        }
    }

    public void setTriggeredMachines(ArrayList<String> list) {
        this.triggeredMachines = list;
    }

    public ArrayList<String> getTriggeredMachines() {
        return new ArrayList<String>(this.triggeredMachines);
    }

    public void forceRemoveTriggeredMachine(String id) {
        this.triggeredMachines.remove(id);
    }

    public LocatedAlert(Alert alert, AlertLocation aloc) {
        super(aloc);
        this.alert = alert;
        if (alert != null && alert.getName() != null) {
            this.setName(new MachineName(alert.getName()));
        }
    }

    public LocatedAlert(Alert alert) {
        this(alert, new ServerSideAloc());
    }

    public LocatedAlert() {
        this(null, null);
    }

    public static LocatedAlert createTestAlert() {
        Random r = new Random();
        LocatedAlert la = new LocatedAlert(Alert.createTestAlert());
        la.setName(MachineName.extractFromNameWithGroup("Test Group/" + r.nextInt(10) + "/Alert " + r.nextInt(100)));
        return la;
    }

    @Override
    public Machine.MachineChanges copyStateFrom(TreeElement sourceElement) {
        LocatedAlert source = (LocatedAlert)sourceElement;
        Machine.MachineChanges changes = new Machine.MachineChanges();
        changes.nameChange = false;
        if (!sourceElement.getName().equals(this.getName())) {
            changes.nameChange = true;
        }
        this.triggeredMachines = source.triggeredMachines;
        this.alert = source.alert;
        this.aloc = source.aloc;
        this.triggerTargets = source.triggerTargets;
        this.resetTargets = source.resetTargets;
        return changes;
    }

    @Override
    public String getID() {
        return this.alert.getID();
    }

    @Override
    public MachineName getName() {
        return this.name;
    }

    @Override
    public void setName(MachineName name) {
        this.name = name;
    }

    @Override
    public boolean matchesFilter(String filter) {
        filter = filter.toLowerCase();
        MachineName name = this.getName();
        return name.toString().toLowerCase().contains(filter);
    }

    public Object getUIMetadata() {
        return this.uiMetadata;
    }

    public void setUIMetadata(Object metadata) {
        this.uiMetadata = metadata;
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean isTriggered() {
        return this.triggeredMachines.size() > 0;
    }

    public int getTriggeredCount() {
        return this.triggeredMachines.size();
    }

    public boolean equals(Object o) {
        if (o instanceof LocatedAlert) {
            LocatedAlert m = (LocatedAlert)o;
            return StringUtil.equal((String)m.getID(), (String)this.getID());
        }
        return false;
    }

    @Override
    public void fromMessage(byte version, Message m) {
        this.name = MachineName.fromMessage(m);
        this.alert = ResourceSerialiser.alertFromMessage(m.getNextMessage());
        super.fromMessage(version, m);
        Message sub = m.getNextMessage();
        ArrayList<String> trigs = new ArrayList<String>();
        int count = sub.getNextInt();
        for (int i = 0; i < count; ++i) {
            trigs.add(sub.getNextString());
        }
        this.setTriggeredMachines(trigs);
        if (m.hasNext()) {
            this.fromMessageAppend(m.getNextMessage());
        }
    }

    @Override
    public void toMessage(Message m) {
        this.name.toMessage(m);
        m.append(ResourceSerialiser.alertToMessage(this.getAlert()));
        super.toMessage(m);
        Message sub = new Message(14901);
        ArrayList<String> trigs = this.getTriggeredMachines();
        sub.append(trigs.size());
        for (String trig : trigs) {
            sub.append(trig);
        }
        m.append(sub);
        m.append(this.toMessageAppend());
    }

    @Override
    protected final Message toMessageAppend() {
        Message m = new Message();
        Message parent = super.toMessageAppend();
        m.append(parent);
        return m;
    }

    @Override
    protected final void fromMessageAppend(Message m) {
        if (m.hasNext()) {
            Message parentMessage = m.getNextMessage();
            super.fromMessageAppend(parentMessage);
        }
    }

    public Alert getAlert() {
        if (!Alert.isReadOnly()) {
            this.alert.setName(this.getName() + "");
        }
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }

    @Override
    public String getSerialisationID() {
        return SERIALISATION_ID;
    }

    public AbstractTarget[] getTriggerTargets() {
        if (this.triggerTargets == null) {
            return new AbstractTarget[0];
        }
        return this.triggerTargets;
    }

    public AbstractTarget[] getResetTargets() {
        if (this.resetTargets == null) {
            return new AbstractTarget[0];
        }
        return this.resetTargets;
    }

    public void setTriggerTargets(AbstractTarget[] targets) {
        this.triggerTargets = targets;
    }

    public void setResetTargets(AbstractTarget[] targets) {
        this.resetTargets = targets;
    }

    @Override
    public boolean isActive() {
        return this.alert.isActive();
    }

    @Override
    public void setActive(boolean isActive) {
        this.alert.setActive(isActive);
        this.isActive = isActive;
    }

    public ArrayList<String> getContextKeys() {
        return this.alert.getContextKeys();
    }
}

