/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.PresentationMachine;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.proxy.types.TypeUtil;
import java.util.Random;
import utils.message.Message;

public class DemoSession
extends AbstractSession {
    private String name;
    private String desc;
    private int attendeeCount;

    public DemoSession(PresentationMachine remoteDevice, String demoID) {
        super(remoteDevice);
        this.setSessionID(demoID);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getAttendeeCount() {
        return this.attendeeCount;
    }

    public void setAttendeeCount(int attendeeCount) {
        this.attendeeCount = attendeeCount;
    }

    public DemoSession() {
        super(new PresentationMachine());
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public String getAdditionalDescription() {
        return null;
    }

    @Override
    public Message toMessage() {
        Message m = new Message(2);
        this.toMessage(m);
        return m;
    }

    @Override
    public void loadFrom(Message m) {
        super.loadFrom(m);
        m.setCurrentIndex(m.length() - 3);
        this.name = m.getNextString();
        this.desc = m.getNextString();
        this.attendeeCount = m.getNextInt();
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.name);
        m.append(this.desc);
        m.append(this.attendeeCount);
    }

    public static DemoSession createTestSession() {
        PresentationMachine machine = PresentationMachine.createTestMachine();
        Random r = new Random();
        DemoSession session = new DemoSession(machine, System.currentTimeMillis() + "" + r.nextInt());
        session.attendeeCount = r.nextInt(100);
        session.desc = "Presentation description # " + r.nextInt(10000);
        session.name = SupportSession.testTechnicianNames[r.nextInt(SupportSession.testTechnicianNames.length)] + "'s presentation";
        String displayName = SupportSession.testTechnicianNames[r.nextInt(SupportSession.testTechnicianNames.length)];
        String username = displayName.replace(' ', '_').toLowerCase();
        session.setTechnicianDisplayName(displayName);
        session.setTechnicianUsername(username);
        session.setDuration(r.nextInt(300000));
        return session;
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        super.toXML(buffer, tabs);
        TypeUtil.append(buffer, "PresentationName", this.name, tabs);
        TypeUtil.append(buffer, "PresentationDesc", this.desc, tabs);
        TypeUtil.append(buffer, "AttendeeCount", this.attendeeCount, tabs);
    }

    @Override
    public String getRootTag() {
        return "DemoSession";
    }

    public static DemoSession fromXML(String xml) {
        DemoSession session = new DemoSession();
        TypeUtil.fromXML(xml, session);
        return session;
    }

    @Override
    public void handleXMLElement(String element, String value, String attributeValue) {
        if (element.equals("PresentationName")) {
            this.name = value;
        } else if (element.equals("PresentationDesc")) {
            this.desc = value;
        } else if (element.equals("AttendeeCount")) {
            this.attendeeCount = Integer.parseInt(value);
        } else {
            super.handleXMLElement(element, value, attributeValue);
        }
    }
}

