/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.ResourceContainer;
import utils.loggingframework.targets.AbstractTarget;
import utils.message.Message;

public abstract class ActionableResourceContainer
extends ResourceContainer {
    protected AbstractTarget[] triggerTargets = null;
    protected AbstractTarget[] resetTargets = null;
    protected boolean isActive = true;

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.isActive());
        if (this.triggerTargets == null) {
            m.append(0);
        } else {
            m.append(this.triggerTargets.length);
            for (AbstractTarget triggerTarget : this.triggerTargets) {
                Message targetMessage = new Message();
                if (triggerTarget != null) {
                    triggerTarget.toMessage(targetMessage);
                }
                m.append(targetMessage);
            }
        }
    }

    protected Message toMessageAppend() {
        Message m = new Message();
        if (this.resetTargets == null) {
            m.append(0);
        } else {
            m.append(this.resetTargets.length);
            for (AbstractTarget resetTarget : this.resetTargets) {
                Message targetMessage = new Message();
                if (resetTarget != null) {
                    resetTarget.toMessage(targetMessage);
                }
                m.append(targetMessage);
            }
        }
        return m;
    }

    protected void fromMessageAppend(Message m) {
        int resetCount = m.getNextInt();
        this.resetTargets = new AbstractTarget[resetCount];
        for (int i = 0; i < resetCount; ++i) {
            Message resetMessage = m.getNextMessage();
            this.resetTargets[i] = resetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(resetMessage, Language.DEFLANG);
        }
    }

    @Override
    public void fromMessage(byte version, Message m) {
        super.fromMessage(version, m);
        this.setActive(m.getNextBoolean());
        if (version <= 12) {
            int targetCount = m.getNextInt();
            if (this instanceof LocatedAlert && targetCount == 2) {
                this.triggerTargets = new AbstractTarget[1];
                Message targetMessage = m.getNextMessage();
                this.triggerTargets[0] = targetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(targetMessage, Language.DEFLANG);
                this.resetTargets = new AbstractTarget[1];
                targetMessage = m.getNextMessage();
                this.resetTargets[0] = targetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(targetMessage, Language.DEFLANG);
            } else {
                this.triggerTargets = new AbstractTarget[targetCount];
                for (int i = 0; i < targetCount; ++i) {
                    Message targetMessage = m.getNextMessage();
                    this.triggerTargets[i] = targetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(targetMessage, Language.DEFLANG);
                }
            }
        } else {
            int targetCount = m.getNextInt();
            this.triggerTargets = new AbstractTarget[targetCount];
            for (int i = 0; i < targetCount; ++i) {
                Message targetMessage = m.getNextMessage();
                this.triggerTargets[i] = targetMessage.length() == 0 ? null : AbstractTarget.loadFromMessage(targetMessage, Language.DEFLANG);
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

