/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.targets.runtool;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTarget;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.AccessPanel;
import com.aem.shelp.tech.utils.tools.popup.PickToolPopup;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class RunToolTargetUI
extends AbstractTargetUI {
    private GbPanel rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
    private JLabel pickToolLabel;
    private JButton pickToolButton;
    private JLabel pickedToolLabel;
    private String toolBoxItemID;
    private String toolBoxItemName;
    private int toolBoxOwner;
    private String toolBoxOwnerName;

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        RunToolTarget ntt = (RunToolTarget)target;
        ntt.setTooToRun(this.toolBoxItemID, this.toolBoxItemName, this.toolBoxOwner, this.toolBoxOwnerName);
    }

    @Override
    public void setEventsToTarget(LogEvent[] events) {
        if (Arrays.equals(events, this.events)) {
            return;
        }
        super.setEventsToTarget(events);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
        this.pickToolLabel.setEnabled(enabled);
        this.pickedToolLabel.setEnabled(enabled);
    }

    @Override
    public void notifyIfComplete() {
        this.notifyComplete();
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof RunToolTarget)) {
            return;
        }
        RunToolTarget ntt = (RunToolTarget)target;
        this.toolBoxItemID = ntt.getToolBoxItemID();
        this.toolBoxOwner = ntt.getToolBoxOwnerID();
        this.toolBoxItemName = ntt.getToolName();
        this.toolBoxOwnerName = ntt.getToolBoxOwnerName();
        this.updateSummaryLabel();
    }

    private void updateSummaryLabel() {
        if (this.toolBoxItemID == null || this.toolBoxItemID.length() == 0) {
            this.pickedToolLabel.setIcon(null);
            this.pickedToolLabel.setText(Language.get("RUN_TOOL_NONE"));
            this.pickedToolLabel.setText("<html><font color=#626262>" + Language.get("RUN_TOOL_NONE"));
        } else {
            this.pickedToolLabel.setText(Language.get("OWNED_BY", this.toolBoxItemName, this.toolBoxOwnerName));
            this.pickedToolLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/spanner-dark.svg,16"));
        }
    }

    protected void showPickerDialog() {
        PickToolPopup popup = new PickToolPopup(1, PickToolPopup.getForAllOS()){

            @Override
            protected void pickedTool(ToolBoxItem pickedItem) {
                TransientTechUser user = TechClient.LAST_INSTANCE.getTechUser();
                RunToolTargetUI.this.toolBoxOwnerName = user.displayName;
                RunToolTargetUI.this.toolBoxOwner = user.uniqueID;
                RunToolTargetUI.this.toolBoxItemID = pickedItem.getID();
                RunToolTargetUI.this.toolBoxItemName = pickedItem.getName();
                RunToolTargetUI.this.notifyIfComplete();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunToolTargetUI.this.updateSummaryLabel();
                    }
                });
            }
        };
        popup.show(AccessPanel.INSTANCE.getCurrentToolBox(), this.pickToolButton);
    }

    @Override
    protected void initUI() {
        this.pickToolLabel = new JLabel(Language.get("RUN_TOOL_LABEL"));
        this.pickedToolLabel = new JLabel();
        this.pickToolButton = new JButton(Language.get("RUN_TOOL_PICK_BUTTON"));
        GbPanel notifyPanel = new GbPanel(new ScaledInsets(0, 0, 3, 0));
        notifyPanel.add((Component)this.pickToolLabel, 0, 0, 1, 1, 0, 0, 13, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        notifyPanel.add((Component)this.pickedToolLabel, 1, 0, 1, 1, 1, 1, 17, 1, (Insets)new ScaledInsets(3, 3, 3, 3));
        notifyPanel.add((Component)this.pickToolButton, 2, 0, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        int Y = 0;
        this.rootComponent.add((Component)notifyPanel, 0, Y++, 1, 1, 100, 0, 17, 1);
        this.pickToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunToolTargetUI.this.showPickerDialog();
            }
        });
    }
}

